/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.prereqs;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefHost;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import oracle.sysman.prov.prereqs.NetworkChecks;
import oracle.sysman.prov.prereqs.RefCheckFile;
import oracle.sysman.prov.remoteinterfaces.clusterops.ClusterFileOps;
import oracle.sysman.prov.remoteinterfaces.exception.ClusterException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteFileOperationException;
import oracle.sysman.prov.remoteinterfaces.exception.RemoteShellFatalException;
import oracle.sysman.prov.remoteinterfaces.result.ClusterResult;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileChecks {
    private FileChecks() {
    }

    public static OipcrIResult doFilesExist(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine != null) {
            try {
                ArrayList oFilesList = new ArrayList();
                boolean bIsOr = FileChecks.parseXMLToPrepareCheck(oRulesEngine, sRefFile, oFilesList);
                if (oFilesList != null && oFilesList.size() > 0) {
                    ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                    boolean bExit = false;
                    for (int i = 0; i < oFilesList.size() && !bExit; ++i) {
                        RefCheckFile oRefFile = (RefCheckFile)oFilesList.get(i);
                        String sName = oRefFile.getName();
                        boolean bType = oRefFile.getType();
                        File oFile = new File(sName);
                        OipcrIResult oRes = null;
                        if (!(oFile.exists() ^ bType)) {
                            oRes = OipcrResult.PASSED_RESULT;
                            if (bIsOr) {
                                oResDetails.clear();
                                bExit = true;
                            }
                        } else {
                            oRes = OipcrResult.FAILED_RESULT;
                        }
                        oResDetails.add(new OipcrResultDetails(null, (Object)sName, oRes));
                    }
                    oResult = new OipcrResult(oResDetails);
                }
            }
            catch (OipcrExecuteRuleException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckNoReferenceSpecifiedException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownBuilderException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    private static boolean parseXMLToPrepareCheck(OipcrIRulesEngine oRulesEngine, String sRefFile, List oFilesList) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        boolean bIsOr = false;
        OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
        OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
        Node oFilesNode = oGenRefHost.getNode("FILES");
        if (oFilesNode != null) {
            NodeList oNodes;
            NamedNodeMap oFilesAtts = null;
            oFilesAtts = oFilesNode.getAttributes();
            if (oFilesAtts != null) {
                String sType;
                Node oFileAttrib = null;
                oFileAttrib = oFilesAtts.getNamedItem("TYPE");
                if (oFileAttrib != null && (sType = oFileAttrib.getNodeValue()) != null && sType.equalsIgnoreCase("OR")) {
                    bIsOr = true;
                }
            }
            if ((oNodes = oFilesNode.getChildNodes()) != null) {
                int iNodes = oNodes.getLength();
                Node oNode = null;
                NamedNodeMap oNodeAttribs = null;
                Node oAttrib = null;
                for (int i = 0; i < iNodes; ++i) {
                    oNode = oNodes.item(i);
                    if (oNode.getNodeType() != 1 || !oNode.getNodeName().equalsIgnoreCase("FILE")) continue;
                    oNodeAttribs = oNode.getAttributes();
                    if (oNodeAttribs != null) {
                        String sFileName;
                        String sNodeVal;
                        boolean bType = true;
                        oAttrib = oNodeAttribs.getNamedItem("EXISTS");
                        if (oAttrib != null && (sNodeVal = oAttrib.getNodeValue()) != null && sNodeVal.equalsIgnoreCase("FALSE")) {
                            bType = false;
                        }
                        oAttrib = oNodeAttribs.getNamedItem("VAR");
                        String sFileNameVar = null;
                        if (oAttrib == null) {
                            Object[] args = new String[]{sRefFile};
                            throw new OipcrExecuteRuleException("S_NO_VAR_FOR_FILE_UNDER_FILES", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_VAR_FOR_FILE_UNDER_FILES", (Object[])args));
                        }
                        sFileNameVar = oAttrib.getNodeValue();
                        OiisVariable oVar = oContext.getVariable(sFileNameVar);
                        if (oVar == null || (sFileName = (String)oVar.getValue()) == null) continue;
                        RefCheckFile oRcf = new RefCheckFile(sFileName, bType);
                        oFilesList.add(oRcf);
                        continue;
                    }
                    Object[] args = new String[]{sRefFile};
                    throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_FILE_UNDER_FILES", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_FILE_UNDER_FILES", (Object[])args));
                }
            }
        } else {
            Object[] args = new String[]{sRefFile};
            throw new OipcrExecuteRuleException("S_NO_FILES_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_FILES_INFO", (Object[])args));
        }
        return bIsOr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OipcrIResult doFilesExistOnNodes(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        ClusterFileOps oClusterOps = null;
        if (oRulesEngine == null) return OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        try {
            ArrayList oFilesList = new ArrayList();
            FileChecks.parseXMLToPrepareCheckOnNodes(oRulesEngine, sRefFile, oFilesList);
            String sUsername = null;
            if (oFilesList == null) return oResult;
            if (oFilesList.size() <= 0) return oResult;
            sUsername = NetworkChecks.getUserName(oRulesEngine, sRefFile);
            List oClusterNodes = NetworkChecks.getNodeNames(oRulesEngine, sRefFile);
            String[] oNodesArray = OiixVectorOps.list2StrArr((List)oClusterNodes);
            if (oNodesArray == null) return oResult;
            if (oNodesArray.length == 0) return oResult;
            try {
                oClusterOps = new ClusterFileOps();
            }
            catch (FatalException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            if (oClusterOps == null) return oResult;
            oClusterOps.shutdown();
            oClusterOps.startup(oNodesArray, sUsername, null);
            ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
            for (int i = 0; i < oFilesList.size(); ++i) {
                RefCheckFile oRefFile = (RefCheckFile)oFilesList.get(i);
                String sFileName = oRefFile.getName();
                boolean bType = oRefFile.getType();
                for (int j = 0; j < oNodesArray.length; ++j) {
                    OipcrIResult oRes = null;
                    boolean bExists = false;
                    String sExpected = null;
                    try {
                        ClusterResult oClusterRes = oClusterOps.fileExists(oNodesArray[j], sFileName);
                        if (((Boolean)oClusterRes.getResultOnNode(oNodesArray[j]).getResult()).booleanValue()) {
                            // empty if block
                        }
                        bExists = true;
                    }
                    catch (FatalException e) {
                        throw e;
                    }
                    catch (RemoteFileOperationException e) {
                        bExists = false;
                    }
                    oRes = !(bExists ^ bType) ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                    sExpected = null;
                    Object[] args = new String[]{sFileName, oNodesArray[j]};
                    sExpected = OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_FILE_EXISTS_ON", (Object[])args);
                    oResDetails.add(new OipcrResultDetails(null, (Object)sExpected, oRes));
                }
            }
            oResult = new OipcrResult(oResDetails);
            return oResult;
        }
        catch (ClusterException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            return oResult;
        }
        catch (RemoteShellFatalException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            return oResult;
        }
        catch (FatalException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            return oResult;
        }
        catch (OipcrExecuteRuleException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            return oResult;
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            return oResult;
        }
        catch (OipckKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            return oResult;
        }
        catch (OipckNoReferenceSpecifiedException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            return oResult;
        }
        catch (OipckUnknownBuilderException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            return oResult;
        }
        finally {
            if (oClusterOps != null) {
                oClusterOps.shutdown();
            }
        }
    }

    private static void parseXMLToPrepareCheckOnNodes(OipcrIRulesEngine oRulesEngine, String sRefFile, List oFilesList) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
        OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
        Node oFilesNode = oGenRefHost.getNode("REMOTE_FILES");
        if (oFilesNode != null) {
            NodeList oNodes = oFilesNode.getChildNodes();
            if (oNodes != null) {
                int iNodes = oNodes.getLength();
                Node oNode = null;
                NamedNodeMap oNodeAttribs = null;
                Node oAttrib = null;
                for (int i = 0; i < iNodes; ++i) {
                    oNode = oNodes.item(i);
                    if (oNode.getNodeType() != 1 || !oNode.getNodeName().equalsIgnoreCase("REMOTE_FILE")) continue;
                    oNodeAttribs = oNode.getAttributes();
                    if (oNodeAttribs != null) {
                        String sFile;
                        String sNodeVal;
                        boolean bType = true;
                        oAttrib = oNodeAttribs.getNamedItem("EXISTS");
                        if (oAttrib != null && (sNodeVal = oAttrib.getNodeValue()) != null && sNodeVal.equalsIgnoreCase("FALSE")) {
                            bType = false;
                        }
                        oAttrib = oNodeAttribs.getNamedItem("VAR");
                        String sFileVar = null;
                        if (oAttrib == null) {
                            Object[] args = new String[]{sRefFile};
                            throw new OipcrExecuteRuleException("S_NO_VAR_FOR_REMOTE_FILE_UNDER_REMOTE_FILES", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_VAR_FOR_REMOTE_FILE_UNDER_REMOTE_FILES", (Object[])args));
                        }
                        sFileVar = oAttrib.getNodeValue();
                        OiisVariable oVar = oContext.getVariable(sFileVar);
                        if (oVar == null || (sFile = (String)oVar.getValue()) == null) continue;
                        RefCheckFile oRcl = new RefCheckFile(sFile, bType);
                        oFilesList.add(oRcl);
                        continue;
                    }
                    Object[] args = new String[]{sRefFile};
                    throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_REMOTE_FILE_UNDER_REMOTE_FILES", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_REMOTE_FILE_UNDER_REMOTE_FILES", (Object[])args));
                }
            }
        } else {
            Object[] args = new String[]{sRefFile};
            throw new OipcrExecuteRuleException("S_NO_REMOTE_FILES_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_REMOTE_FILES_INFO", (Object[])args));
        }
    }
}

