/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.prereqs;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixNetOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixVectorOps;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefHost;
import oracle.sysman.oip.oipc.oipch.OipchHost;
import oracle.sysman.oip.oipc.oipch.OipchNIC;
import oracle.sysman.oip.oipc.oipch.OipchNetworkDetails;
import oracle.sysman.oip.oipc.oipch.OipchSystem;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import oracle.sysman.prov.prereqs.NetworkResult;
import oracle.sysman.prov.remoteinterfaces.clusterops.ClusterBaseOps;
import oracle.sysman.prov.remoteinterfaces.exception.ClusterException;
import oracle.sysman.prov.remoteinterfaces.exception.FatalException;
import oracle.sysman.prov.remoteinterfaces.exception.NodesAliveException;
import oracle.sysman.prov.remoteinterfaces.exception.UserEquivalenceException;
import oracle.sysman.prov.remoteinterfaces.result.ClusterResult;
import oracle.sysman.prov.remoteinterfaces.result.CommandResult;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NetworkChecks {
    private NetworkChecks() {
    }

    public static OipcrIResult areNodesAlive(OipcrIRulesEngine oRulesEngine, String sRefFile) throws OipcrExecuteRuleException {
        Object oResult = OipcrResult.NOT_EXECUTED_RESULT;
        try {
            List oNodesList;
            oResult = oRulesEngine != null ? ((oNodesList = NetworkChecks.getNodeNames(oRulesEngine, sRefFile)) != null ? NetworkChecks.areNodesAliveHelper(oNodesList) : OipcrResult.NOT_EXECUTED_RESULT) : OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        catch (OipcrExecuteRuleException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckNoReferenceSpecifiedException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownBuilderException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        return oResult;
    }

    public static OipcrIResult checkIfNodesInSameDomain(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        try {
            if (oRulesEngine != null) {
                if (oRulesEngine != null) {
                    List oNodesList = NetworkChecks.getNodeNames(oRulesEngine, sRefFile);
                    oResult = oNodesList != null ? NetworkChecks.checkIfNodesInSameDomainHelper(oRulesEngine, sRefFile, oNodesList) : OipcrResult.NOT_EXECUTED_RESULT;
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        catch (OipcrExecuteRuleException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckNoReferenceSpecifiedException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownBuilderException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        return oResult;
    }

    public static OipcrIResult checkIPNodeNameConflict(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        try {
            if (oRulesEngine != null) {
                if (oRulesEngine != null) {
                    List oNodesList = NetworkChecks.getNodeNames(oRulesEngine, sRefFile);
                    oResult = oNodesList != null ? NetworkChecks.checkIPNodeNameConflictHelper(oNodesList) : OipcrResult.NOT_EXECUTED_RESULT;
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        catch (OipcrExecuteRuleException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckNoReferenceSpecifiedException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownBuilderException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        return oResult;
    }

    public static OipcrIResult checkPrivateNodeSetup(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult;
        block20: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    ArrayList oIpsList = new ArrayList();
                    List oNodesList = NetworkChecks.getNodeNames(oRulesEngine, sRefFile, oIpsList);
                    String[] oNodesArray = OiixVectorOps.list2StrArr((List)oNodesList);
                    String[] oIpsArray = OiixVectorOps.list2StrArr(oIpsList);
                    if (oNodesArray == null || oNodesArray.length == 0) break block20;
                    ClusterBaseOps oClusterOps = null;
                    try {
                        oClusterOps = new ClusterBaseOps();
                    }
                    catch (FatalException e) {
                        oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                    }
                    int iSize = oNodesArray.length;
                    if (oClusterOps == null) break block20;
                    ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                    try {
                        ClusterResult oClusterResult = oClusterOps.areNodesAlive(oNodesArray, 5);
                        oResult = OipcrResult.PASSED_RESULT;
                    }
                    catch (FatalException e) {
                        oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                    }
                    catch (NodesAliveException e) {
                        for (int i = 0; i < iSize; ++i) {
                            String problem = null;
                            OipcrIResult oRes = null;
                            boolean bDoFixUp = false;
                            String sNode = oNodesArray[i];
                            String msg = e.getErrorMessageOnNode(oNodesArray[i]);
                            NetworkResult oNetRes = new NetworkResult(sNode, bDoFixUp);
                            if (msg == null) {
                                oRes = OipcrResult.PASSED_RESULT;
                            } else {
                                oRes = OipcrResult.FAILED_RESULT;
                                if (oIpsArray != null && oIpsArray.length > 0) {
                                    String sCurIP = oIpsArray[i];
                                    oNetRes.setIP(sCurIP);
                                    String[] asIP = new String[]{sCurIP};
                                    try {
                                        ClusterResult oIpRes = oClusterOps.areNodesAlive(asIP, 5);
                                        oNetRes.setDoFixup(true);
                                    }
                                    catch (FatalException eNew) {
                                    }
                                    catch (NodesAliveException eNew) {
                                        // empty catch block
                                    }
                                }
                                Object[] probArgs = new String[]{msg};
                                problem = OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_PROBLEM", (Object[])probArgs);
                            }
                            oResDetails.add(new OipcrResultDetails(problem, (Object)oNetRes, oRes));
                        }
                        oResult = new OipcrResult(oResDetails);
                    }
                }
                catch (OipcrExecuteRuleException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    public static OipcrIResult checkVIPPublic(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult;
        block16: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            try {
                if (oRulesEngine != null) {
                    ArrayList oIpsList = new ArrayList();
                    List oNodesList = NetworkChecks.getNodeNames(oRulesEngine, sRefFile, oIpsList);
                    String[] oNodesArray = OiixVectorOps.list2StrArr((List)oNodesList);
                    String[] oIpsArray = OiixVectorOps.list2StrArr(oIpsList);
                    OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                    OipchSystem oSys = oHost.getSystem();
                    OipchNetworkDetails oNetDetails = oSys.getNetworkDetails();
                    List oHostNICs = null;
                    if (oNetDetails != null) {
                        oHostNICs = oNetDetails.getHostNICs();
                    }
                    if (oHostNICs == null || oHostNICs.size() <= 0) {
                        throw new OipcrExecuteRuleException("S_NO_HOST_INTERCONNECTS_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_HOST_INTERCONNECTS_INFO"));
                    }
                    ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                    block8: for (int i = 0; i < oNodesArray.length; ++i) {
                        BitSet ipBits;
                        String ipAddress;
                        block15: {
                            ipAddress = "";
                            if (oIpsArray.length != oNodesArray.length) {
                                try {
                                    ipAddress = OiixNetOps.getIPAddressForHostName((String)oNodesArray[i]);
                                    break block15;
                                }
                                catch (UnknownHostException e) {
                                    continue;
                                }
                            }
                            ipAddress = oIpsArray[i];
                        }
                        if (ipAddress == null || ipAddress.equals("") || (ipBits = NetworkChecks.getBitset(ipAddress)) == null) continue;
                        OipcrIResult oRes = OipcrResult.FAILED_RESULT;
                        int oHostSize = oHostNICs.size();
                        for (int j = 0; j < oHostSize; ++j) {
                            OipchNIC oHostNIC = (OipchNIC)oHostNICs.get(j);
                            String sType = oHostNIC.getType();
                            String subnet = oHostNIC.getSubnet();
                            String mask = oHostNIC.getMask();
                            BitSet maskBits = NetworkChecks.getBitset(mask);
                            BitSet subnetBits = NetworkChecks.getBitset(subnet);
                            if (maskBits == null || subnetBits == null) continue;
                            maskBits.and(ipBits);
                            if (!maskBits.equals(subnetBits)) continue;
                            if (sType.equals("PUBLIC")) {
                                oRes = OipcrResult.PASSED_RESULT;
                            }
                            oResDetails.add(new OipcrResultDetails((Object)(oNodesArray[i] + ":" + sType), (Object)(oNodesArray[i] + ":PUBLIC"), oRes));
                            continue block8;
                        }
                    }
                    oResult = new OipcrResult(oResDetails);
                    break block16;
                }
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
            catch (OipcrExecuteRuleException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckNoReferenceSpecifiedException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownBuilderException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
        }
        return oResult;
    }

    public static OipcrIResult checkVIPAvailability(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult;
        block22: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    ArrayList oIpsList = new ArrayList();
                    List oNodesList = NetworkChecks.getNodeNames(oRulesEngine, sRefFile, oIpsList);
                    String[] oNodesArray = OiixVectorOps.list2StrArr((List)oNodesList);
                    String[] oIpsArray = OiixVectorOps.list2StrArr(oIpsList);
                    if (oNodesArray == null || oNodesArray.length == 0) break block22;
                    ClusterBaseOps oClusterOps = null;
                    try {
                        oClusterOps = new ClusterBaseOps();
                    }
                    catch (FatalException e) {
                        oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                    }
                    int iSize = oNodesArray.length;
                    if (oClusterOps == null) break block22;
                    ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                    try {
                        ClusterResult oClusterResult = oClusterOps.areNodesAliveEx(oNodesArray, 30, true, true, true);
                        oResult = OipcrResult.FAILED_RESULT;
                    }
                    catch (FatalException e) {
                        oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                    }
                    catch (NodesAliveException e) {
                        Iterator oCmdResults = e.getCommandResults();
                        if (oCmdResults == null) break block22;
                        int i = -1;
                        while (oCmdResults.hasNext()) {
                            String problem;
                            NetworkResult oNetRes;
                            OipcrIResult oRes;
                            block23: {
                                ++i;
                                CommandResult oCmdRes = (CommandResult)oCmdResults.next();
                                oRes = null;
                                boolean bDoFixUp = false;
                                String sNode = oCmdRes.getNodeName();
                                oNetRes = new NetworkResult(sNode, bDoFixUp);
                                int iExit = oCmdRes.getExitCode();
                                problem = null;
                                String msg = e.getErrorMessageOnNode(sNode);
                                if (msg != null) {
                                    Object[] probArgs = new String[]{msg};
                                    problem = OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_PROBLEM", (Object[])probArgs);
                                }
                                if (iExit == 1) {
                                    oRes = OipcrResult.PASSED_RESULT;
                                } else if (iExit == 0) {
                                    oRes = OipcrResult.FAILED_RESULT;
                                } else {
                                    oRes = OipcrResult.FAILED_RESULT;
                                    String sCurIP = oIpsArray[i];
                                    oNetRes.setIP(sCurIP);
                                    String[] asIP = new String[]{sCurIP};
                                    try {
                                        ClusterResult oIpRes = oClusterOps.areNodesAliveEx(asIP, 30, true, true, true);
                                    }
                                    catch (FatalException eNew) {
                                    }
                                    catch (NodesAliveException eNew) {
                                        Iterator oIpCmdRes = eNew.getCommandResults();
                                        if (((CommandResult)oIpCmdRes.next()).getExitCode() != 1) break block23;
                                        oNetRes.setDoFixup(true);
                                    }
                                }
                            }
                            oResDetails.add(new OipcrResultDetails((Object)problem, (Object)oNetRes, oRes));
                        }
                        oResult = new OipcrResult(oResDetails);
                    }
                }
                catch (OipcrExecuteRuleException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OipcrIResult checkSSH(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine == null) return OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        try {
            boolean formatRefHost = NetworkChecks.ifNewOrOldFormat(oRulesEngine, sRefFile, 1);
            List oNodesList = null;
            oNodesList = formatRefHost ? NetworkChecks.getNodeNames(oRulesEngine, sRefFile, 1) : NetworkChecks.getNodeNames(oRulesEngine, sRefFile);
            String[] oNodesArray = OiixVectorOps.list2StrArr((List)oNodesList);
            if (oNodesArray == null) return oResult;
            if (oNodesArray.length == 0) return oResult;
            ClusterBaseOps oClusterOps = null;
            try {
                oClusterOps = new ClusterBaseOps();
            }
            catch (FatalException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            if (oClusterOps == null) return oResult;
            int iSize = oNodesArray.length;
            ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
            try {
                ClusterResult oClusterResult = oClusterOps.checkSSHServer(oNodesArray);
                return OipcrResult.PASSED_RESULT;
            }
            catch (FatalException e) {
                return OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (ClusterException e) {
                int i = 0;
                while (i < iSize) {
                    OipcrIResult oRes = null;
                    String msg = e.getErrorMessageOnNode(oNodesArray[i]);
                    String problem = null;
                    if (msg == null) {
                        oRes = OipcrResult.PASSED_RESULT;
                    } else {
                        oRes = OipcrResult.FAILED_RESULT;
                        Object[] probArgs = new String[]{msg};
                        problem = OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_PROBLEM", (Object[])probArgs);
                    }
                    oResDetails.add(new OipcrResultDetails(problem, (Object)oNodesArray[i], oRes));
                    oResult = new OipcrResult(oResDetails);
                    ++i;
                }
                return oResult;
            }
        }
        catch (OipcrExecuteRuleException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckKnowledgeSourceException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckNoReferenceSpecifiedException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownBuilderException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OipcrIResult checkSSHEquivalence(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine == null) return OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        try {
            List oNodesList = null;
            boolean formatRefHost = NetworkChecks.ifNewOrOldFormat(oRulesEngine, sRefFile, 1);
            oNodesList = formatRefHost ? NetworkChecks.getNodeNames(oRulesEngine, sRefFile, 1) : NetworkChecks.getNodeNames(oRulesEngine, sRefFile);
            String sUserName = NetworkChecks.getUserName(oRulesEngine, sRefFile);
            String[] oNodesArray = OiixVectorOps.list2StrArr((List)oNodesList);
            if (oNodesArray == null) return oResult;
            if (oNodesArray.length == 0) return oResult;
            ClusterBaseOps oClusterOps = null;
            try {
                oClusterOps = new ClusterBaseOps();
            }
            catch (FatalException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            if (oClusterOps == null) return oResult;
            int iSize = oNodesArray.length;
            ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
            try {
                ClusterResult oClusterResult = oClusterOps.validateSSHEquivalence(oNodesArray, sUserName);
                return OipcrResult.PASSED_RESULT;
            }
            catch (FatalException e) {
                return OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (UserEquivalenceException e) {
                int i = 0;
                while (i < iSize) {
                    OipcrIResult oRes = null;
                    String msg = e.getErrorMessageOnNode(oNodesArray[i]);
                    String problem = null;
                    if (msg == null) {
                        oRes = OipcrResult.PASSED_RESULT;
                    } else {
                        oRes = OipcrResult.FAILED_RESULT;
                        Object[] probArgs = new String[]{msg};
                        problem = OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_PROBLEM", (Object[])probArgs);
                    }
                    oResDetails.add(new OipcrResultDetails(problem, (Object)oNodesArray[i], oRes));
                    oResult = new OipcrResult(oResDetails);
                    ++i;
                }
                return oResult;
            }
        }
        catch (OipcrExecuteRuleException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckKnowledgeSourceException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckNoReferenceSpecifiedException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownBuilderException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OipcrIResult checkRSHEquivalence(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine == null) return OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        try {
            List oNodesList = null;
            boolean formatRefHost = NetworkChecks.ifNewOrOldFormat(oRulesEngine, sRefFile, 1);
            oNodesList = formatRefHost ? NetworkChecks.getNodeNames(oRulesEngine, sRefFile, 1) : NetworkChecks.getNodeNames(oRulesEngine, sRefFile);
            String[] oNodesArray = OiixVectorOps.list2StrArr((List)oNodesList);
            String sUserName = NetworkChecks.getUserName(oRulesEngine, sRefFile);
            if (oNodesArray == null) return oResult;
            if (oNodesArray.length == 0) return oResult;
            ClusterBaseOps oClusterOps = null;
            try {
                oClusterOps = new ClusterBaseOps();
            }
            catch (FatalException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            if (oClusterOps == null) return oResult;
            int iSize = oNodesArray.length;
            ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
            try {
                ClusterResult oClusterResult = oClusterOps.validateRSHEquivalence(oNodesArray, sUserName);
                return OipcrResult.PASSED_RESULT;
            }
            catch (FatalException e) {
                return OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (UserEquivalenceException e) {
                int i = 0;
                while (i < iSize) {
                    OipcrIResult oRes = null;
                    String msg = e.getErrorMessageOnNode(oNodesArray[i]);
                    String problem = null;
                    if (msg == null) {
                        oRes = OipcrResult.PASSED_RESULT;
                    } else {
                        oRes = OipcrResult.FAILED_RESULT;
                        Object[] probArgs = new String[]{msg};
                        problem = OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_PROBLEM", (Object[])probArgs);
                    }
                    oResDetails.add(new OipcrResultDetails(problem, (Object)oNodesArray[i], oRes));
                    oResult = new OipcrResult(oResDetails);
                    ++i;
                }
                return oResult;
            }
        }
        catch (OipcrExecuteRuleException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckKnowledgeSourceException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckNoReferenceSpecifiedException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownBuilderException e) {
            return OipcrResult.getNotExecutedResult((OiixException)e);
        }
    }

    static List getNodeNames(OipcrIRulesEngine oRulesEngine, String sRefFile) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        List oNullList = null;
        return NetworkChecks.getNodeNames(oRulesEngine, sRefFile, oNullList);
    }

    static List getNodeNames(OipcrIRulesEngine oRulesEngine, String sRefFile, int Type2) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        List oNullList = null;
        return NetworkChecks.getNodeNames(oRulesEngine, sRefFile, oNullList, Type2);
    }

    static List getNodeNames(OipcrIRulesEngine oRulesEngine, String sRefFile, List ips) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        boolean bFindIps = false;
        if (ips != null) {
            bFindIps = true;
            ips.clear();
        }
        ArrayList<String> oNodesList = new ArrayList<String>();
        OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
        OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
        Node oNetworkNode = oGenRefHost.getNode("NETWORK");
        if (oNetworkNode != null) {
            NodeList oNodes = oNetworkNode.getChildNodes();
            if (oNodes != null) {
                int iNodes = oNodes.getLength();
                Node oNode = null;
                NamedNodeMap oNodeAttribs = null;
                Node oAttrib = null;
                for (int i = 0; i < iNodes; ++i) {
                    oNode = oNodes.item(i);
                    if (oNode.getNodeType() != 1 || !oNode.getNodeName().equalsIgnoreCase("NODES")) continue;
                    oNodeAttribs = oNode.getAttributes();
                    if (oNodeAttribs != null) {
                        String[] asIPs;
                        String[] asNodeNames;
                        oAttrib = oNodeAttribs.getNamedItem("VAR");
                        String sNodeNamesVar = null;
                        if (oAttrib == null) {
                            Object[] args = new String[]{sRefFile};
                            throw new OipcrExecuteRuleException("S_NO_VAR_FOR_NODES_UNDER_NETWORK", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_VAR_FOR_NODES_UNDER_NETWORK", (Object[])args));
                        }
                        sNodeNamesVar = oAttrib.getNodeValue();
                        OiisVariable oVar = oContext.getVariable(sNodeNamesVar);
                        if (oVar != null && (asNodeNames = (String[])oVar.getValue()) != null) {
                            for (int j = 0; j < asNodeNames.length; ++j) {
                                oNodesList.add(asNodeNames[j]);
                            }
                        }
                        if (!bFindIps) continue;
                        oAttrib = oNodeAttribs.getNamedItem("IP_VAR");
                        String sIPsVar = null;
                        if (oAttrib == null || (oVar = oContext.getVariable(sIPsVar = oAttrib.getNodeValue())) == null || (asIPs = (String[])oVar.getValue()) == null) continue;
                        for (int j = 0; j < asIPs.length; ++j) {
                            ips.add(asIPs[j]);
                        }
                        continue;
                    }
                    Object[] args = new String[]{sRefFile};
                    throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_NODES_UNDER_NETWORK", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_NODES_UNDER_NETWORK", (Object[])args));
                }
            }
        } else {
            Object[] args = new String[]{sRefFile};
            throw new OipcrExecuteRuleException("S_NO_NETWORK_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_EXISTENCE_MAT_INFO", (Object[])args));
        }
        return oNodesList;
    }

    static List getNodeNames(OipcrIRulesEngine oRulesEngine, String sRefFile, List ips, int Type2) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        String strValForType = null;
        if (Type2 == 0) {
            strValForType = "PRIVATE_NODES";
        } else if (Type2 == 1) {
            strValForType = "CLUSTER_NODES";
        } else if (Type2 == 2) {
            strValForType = "VIRTUAL_NODES";
        }
        boolean bFindIps = false;
        if (ips != null) {
            bFindIps = true;
            ips.clear();
        }
        ArrayList<String> oNodesList = new ArrayList<String>();
        OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
        OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
        Node oNetworkNode = oGenRefHost.getNode("NETWORK/NODELIST");
        if (oNetworkNode != null) {
            NodeList oNodes = oNetworkNode.getChildNodes();
            if (oNodes != null) {
                int iNodes = oNodes.getLength();
                Node oNode = null;
                NamedNodeMap oNodeAttribs = null;
                Node oAttrib = null;
                for (int i = 0; i < iNodes; ++i) {
                    oNode = oNodes.item(i);
                    if (oNode.getNodeType() != 1 || !oNode.getNodeName().equalsIgnoreCase("NODE")) continue;
                    oNodeAttribs = oNode.getAttributes();
                    if (oNodeAttribs != null) {
                        String[] asIPs;
                        String[] asNodeNames;
                        oAttrib = oNodeAttribs.getNamedItem("VAR");
                        String sNodeNamesVar = null;
                        if (oAttrib == null) {
                            Object[] args = new String[]{sRefFile};
                            throw new OipcrExecuteRuleException("S_NO_VAR_FOR_NODES_UNDER_NETWORK", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_VAR_FOR_NODES_UNDER_NETWORK", (Object[])args));
                        }
                        sNodeNamesVar = oAttrib.getNodeValue();
                        OiisVariable oVar = null;
                        if (strValForType.equalsIgnoreCase(sNodeNamesVar)) {
                            oVar = oContext.getVariable(sNodeNamesVar);
                        }
                        if (oVar != null && (asNodeNames = (String[])oVar.getValue()) != null) {
                            for (int j = 0; j < asNodeNames.length; ++j) {
                                oNodesList.add(asNodeNames[j]);
                            }
                        }
                        if (!bFindIps) continue;
                        oAttrib = oNodeAttribs.getNamedItem("IP_VAR");
                        String sIPsVar = null;
                        if (oAttrib == null) continue;
                        sIPsVar = oAttrib.getNodeValue();
                        if (strValForType.equalsIgnoreCase(sNodeNamesVar)) {
                            oVar = oContext.getVariable(sIPsVar);
                        }
                        if (oVar == null || (asIPs = (String[])oVar.getValue()) == null) continue;
                        for (int j = 0; j < asIPs.length; ++j) {
                            ips.add(asIPs[j]);
                        }
                        continue;
                    }
                    Object[] args = new String[]{sRefFile};
                    throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_NODES_UNDER_NETWORK", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_NODES_UNDER_NETWORK", (Object[])args));
                }
            }
        } else {
            Object[] args = new String[]{sRefFile};
            throw new OipcrExecuteRuleException("S_NO_NETWORK_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_EXISTENCE_MAT_INFO", (Object[])args));
        }
        return oNodesList;
    }

    public static OipcrIResult checkIfInterconnectsExist(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oRulesEngine != null) {
            try {
                OipchHost oHost = (OipchHost)oRulesEngine.getKnowledgeSource("host");
                List oRefNICs = NetworkChecks.getRefNICs(oRulesEngine, sRefFile);
                OipchSystem oSys = oHost.getSystem();
                OipchNetworkDetails oNetDetails = oSys.getNetworkDetails();
                List oHostNICs = null;
                if (oNetDetails != null) {
                    oHostNICs = oNetDetails.getHostNICs();
                }
                if (oHostNICs == null || oHostNICs.size() <= 0) {
                    throw new OipcrExecuteRuleException("S_NO_HOST_INTERCONNECTS_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_HOST_INTERCONNECTS_INFO"));
                }
                if (oRefNICs != null && oRefNICs.size() > 0) {
                    int iRefSize = oRefNICs.size();
                    int iSize = oHostNICs.size();
                    ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                    for (int j = 0; j < iRefSize; ++j) {
                        OipcrIResult oRes = OipcrResult.FAILED_RESULT;
                        OipchNIC oRefNIC = (OipchNIC)oRefNICs.get(j);
                        OipchNIC oFoundNIC = null;
                        for (int k = 0; k < iSize; ++k) {
                            OipchNIC oHostNIC = (OipchNIC)oHostNICs.get(k);
                            if (!oRefNIC.getName().equals(oHostNIC.getName())) continue;
                            oFoundNIC = oHostNIC;
                            if (!oRefNIC.getSubnet().equals(oHostNIC.getSubnet())) continue;
                            oRes = OipcrResult.PASSED_RESULT;
                        }
                        oResDetails.add(new OipcrResultDetails(oFoundNIC, (Object)oRefNIC, oRes));
                    }
                    oResult = new OipcrResult(oResDetails);
                }
            }
            catch (OipcrExecuteRuleException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckNoReferenceSpecifiedException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownBuilderException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    public static OipcrIResult checkAtLeastOnePrivatePublicInterface(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.FAILED_RESULT;
        if (oRulesEngine != null) {
            try {
                List oRefNICs = NetworkChecks.getRefNICs(oRulesEngine, sRefFile);
                int iPublic = 0;
                int iPrivate = 0;
                if (oRefNICs != null && oRefNICs.size() > 0) {
                    int iRefSize = oRefNICs.size();
                    for (int j = 0; j < iRefSize; ++j) {
                        OipchNIC oRefNIC = (OipchNIC)oRefNICs.get(j);
                        String sType = oRefNIC.getType();
                        if (sType == null) continue;
                        if (sType.equalsIgnoreCase("PRIVATE")) {
                            ++iPrivate;
                            continue;
                        }
                        if (!sType.equalsIgnoreCase("PUBLIC")) continue;
                        ++iPublic;
                    }
                }
                if (iPublic > 0 && iPrivate > 0) {
                    oResult = OipcrResult.PASSED_RESULT;
                }
            }
            catch (OipcrExecuteRuleException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckKnowledgeSourceException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckNoReferenceSpecifiedException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            catch (OipckUnknownBuilderException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
        } else {
            oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
        }
        return oResult;
    }

    private static List getRefNICs(OipcrIRulesEngine oRulesEngine, String sRefFile) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        ArrayList<OipchNIC> oNICsList = new ArrayList<OipchNIC>();
        OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
        OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
        Node oNetworkNode = oGenRefHost.getNode("NETWORK");
        if (oNetworkNode != null) {
            NodeList oNodes = oNetworkNode.getChildNodes();
            if (oNodes != null) {
                int iNodes = oNodes.getLength();
                Node oNode = null;
                NamedNodeMap oNodeAttribs = null;
                Node oAttrib = null;
                for (int i = 0; i < iNodes; ++i) {
                    oNode = oNodes.item(i);
                    if (oNode.getNodeType() != 1 || !oNode.getNodeName().equalsIgnoreCase("INTERCONNECTS")) continue;
                    oNodeAttribs = oNode.getAttributes();
                    if (oNodeAttribs != null) {
                        String[] asNICs;
                        oAttrib = oNodeAttribs.getNamedItem("VAR");
                        String sVar = null;
                        if (oAttrib == null) {
                            Object[] args = new String[]{sRefFile};
                            throw new OipcrExecuteRuleException("S_NO_VAR_FOR_INTERCONNECTS_UNDER_NETWORK", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_VAR_FOR_INTERCONNECTS_UNDER_NETWORK", (Object[])args));
                        }
                        sVar = oAttrib.getNodeValue();
                        OiisVariable oVar = oContext.getVariable(sVar);
                        if (oVar == null || (asNICs = (String[])oVar.getValue()) == null) continue;
                        for (int j = 0; j < asNICs.length; ++j) {
                            StringTokenizer oTokens = new StringTokenizer(asNICs[j], ":");
                            OipchNIC oNIC = null;
                            if (oTokens != null && oTokens.countTokens() == 3) {
                                oNIC = new OipchNIC();
                                oNIC.setName(oTokens.nextToken());
                                oNIC.setSubnet(oTokens.nextToken());
                                oNIC.setType(oTokens.nextToken());
                            }
                            if (oNIC == null) continue;
                            oNICsList.add(oNIC);
                        }
                        continue;
                    }
                    Object[] args = new String[]{sRefFile};
                    throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_INTERCONNECTS_UNDER_NETWORK", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_INTERCONNECTS_UNDER_NETWORK", (Object[])args));
                }
            }
        } else {
            Object[] args = new String[]{sRefFile};
            throw new OipcrExecuteRuleException("S_NO_NETWORK_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_EXISTENCE_MAT_INFO", (Object[])args));
        }
        return oNICsList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getUserName(OipcrIRulesEngine oRulesEngine, String sRefFile) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        String sValue = null;
        String sTag = "INSTALL_USER";
        OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
        OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
        Node oNode = oGenRefHost.getNode("USER_INPUTS/" + sTag);
        if (oNode != null) {
            Object oHomeNode = null;
            NamedNodeMap oNodeAttribs = null;
            Node oAttrib = null;
            oNodeAttribs = oNode.getAttributes();
            if (oNodeAttribs != null) {
                oAttrib = oNodeAttribs.getNamedItem("VAR");
                String sVar = null;
                if (oAttrib == null) {
                    Object[] args = new String[]{sRefFile};
                    throw new OipcrExecuteRuleException("S_NO_VAR_FOR_TAG", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_VAR_FOR_TAG", (Object[])args));
                }
                sVar = oAttrib.getNodeValue();
                OiisVariable oVar = oContext.getVariable(sVar);
                if (oVar == null) return sValue;
                return (String)oVar.getValue();
            }
            Object[] args = new String[]{sRefFile, sTag};
            throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_TAG", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_TAG", (Object[])args));
        }
        Object[] args = new String[]{sRefFile, sTag};
        throw new OipcrExecuteRuleException("S_NO_TAG_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_TAG_INFO", (Object[])args));
    }

    private static BitSet getBitset(String ipAddress) {
        try {
            BitSet bitset = new BitSet(32);
            StringTokenizer tk = new StringTokenizer(ipAddress, ".");
            if (tk.countTokens() != 4) {
                return null;
            }
            int num = 0;
            int len = 0;
            int offset = 24;
            while (tk.hasMoreTokens()) {
                num = Integer.parseInt(tk.nextToken());
                String binaryString = Integer.toBinaryString(num);
                len = binaryString.length();
                if (len <= 8) {
                    int i;
                    for (i = 8; i > len; --i) {
                        bitset.set(i - 1 + offset, false);
                    }
                    for (i = len; i >= 1; --i) {
                        if (binaryString.charAt(len - i) == '0') {
                            bitset.set(i - 1 + offset, false);
                            continue;
                        }
                        bitset.set(i - 1 + offset, true);
                    }
                    offset -= 8;
                    continue;
                }
                return null;
            }
            return bitset;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static boolean ifNewOrOldFormat(OipcrIRulesEngine oRulesEngine, String sRefFile, int Type2) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        boolean returnType = false;
        OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
        Node oNetworkNode = oGenRefHost.getNode("NETWORK/NODELIST");
        if (oNetworkNode != null) {
            NodeList oNodes = oNetworkNode.getChildNodes();
            if (oNodes != null) {
                int iNodes = oNodes.getLength();
                Node oNode = null;
                NamedNodeMap oNodeAttribs = null;
                Node oAttrib = null;
                int nodeType = -1;
                for (int i = 0; i < iNodes; ++i) {
                    oNode = oNodes.item(i);
                    if (oNode.getNodeType() != 1 || !oNode.getNodeName().equalsIgnoreCase("NODE") || (oNodeAttribs = oNode.getAttributes()) == null) continue;
                    oAttrib = oNodeAttribs.getNamedItem("NAME");
                    String sNodeNamesVar = null;
                    if (oAttrib != null) {
                        sNodeNamesVar = oAttrib.getNodeValue();
                    }
                    oAttrib = oNodeAttribs.getNamedItem("TYPE");
                    String sNodeTypeVar = null;
                    if (oAttrib != null) {
                        sNodeTypeVar = oAttrib.getNodeValue();
                    }
                    if ((nodeType = sNodeNamesVar.equalsIgnoreCase("PRIVATE_NODES") || sNodeTypeVar.equalsIgnoreCase("PRIVATE") ? 0 : (sNodeNamesVar.equalsIgnoreCase("CLUSTER_NODES") || sNodeTypeVar.equalsIgnoreCase("CLUSTER") ? 1 : (sNodeNamesVar.equalsIgnoreCase("VIRTUAL_NODES") || sNodeTypeVar.equalsIgnoreCase("VIRTUAL") ? 2 : -1))) != Type2) continue;
                    returnType = true;
                    break;
                }
            }
        } else {
            returnType = false;
        }
        return returnType;
    }

    private static OipcrIResult areNodesAliveHelper(List oNodesList) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        String[] oNodesArray = OiixVectorOps.list2StrArr((List)oNodesList);
        if (oNodesArray != null && oNodesArray.length != 0) {
            ClusterBaseOps oClusterOps = null;
            try {
                oClusterOps = new ClusterBaseOps();
            }
            catch (FatalException e) {
                oResult = OipcrResult.getNotExecutedResult((OiixException)e);
            }
            if (oClusterOps != null) {
                int iSize = oNodesArray.length;
                ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                try {
                    ClusterResult oClusterResult = oClusterOps.areNodesAlive(oNodesArray, 5);
                    oResult = OipcrResult.PASSED_RESULT;
                }
                catch (FatalException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (NodesAliveException e) {
                    for (int i = 0; i < iSize; ++i) {
                        String msg = e.getErrorMessageOnNode(oNodesArray[i]);
                        String problem = null;
                        OipcrIResult oRes = null;
                        if (msg == null) {
                            oRes = OipcrResult.PASSED_RESULT;
                        } else {
                            oRes = OipcrResult.FAILED_RESULT;
                            Object[] probArgs = new String[]{msg};
                            problem = OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_PROBLEM", (Object[])probArgs);
                        }
                        oResDetails.add(new OipcrResultDetails(problem, (Object)oNodesArray[i], oRes));
                        oResult = new OipcrResult(oResDetails);
                    }
                }
            }
        }
        return oResult;
    }

    public static OipcrIResult areVIPNodesAlive(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        try {
            if (oRulesEngine != null) {
                List oNodesList = null;
                boolean formatRefHost = NetworkChecks.ifNewOrOldFormat(oRulesEngine, sRefFile, 2);
                oResult = formatRefHost ? ((oNodesList = NetworkChecks.getNodeNames(oRulesEngine, sRefFile, 2)) != null ? NetworkChecks.areNodesAliveHelper(oNodesList) : OipcrResult.NOT_EXECUTED_RESULT) : NetworkChecks.areNodesAlive(oRulesEngine, sRefFile);
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        catch (OipcrExecuteRuleException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckNoReferenceSpecifiedException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownBuilderException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        return oResult;
    }

    public static OipcrIResult arePrivateNodesAlive(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        try {
            if (oRulesEngine != null) {
                List oNodesList = null;
                boolean formatRefHost = NetworkChecks.ifNewOrOldFormat(oRulesEngine, sRefFile, 0);
                oResult = formatRefHost ? ((oNodesList = NetworkChecks.getNodeNames(oRulesEngine, sRefFile, 0)) != null ? NetworkChecks.areNodesAliveHelper(oNodesList) : OipcrResult.NOT_EXECUTED_RESULT) : NetworkChecks.areNodesAlive(oRulesEngine, sRefFile);
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        catch (OipcrExecuteRuleException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckNoReferenceSpecifiedException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownBuilderException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        return oResult;
    }

    public static OipcrIResult areClusterNodesAlive(OipcrIRulesEngine oRulesEngine, String sRefFile) throws OipcrExecuteRuleException {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        try {
            if (oRulesEngine != null) {
                List oNodesList = null;
                boolean formatRefHost = NetworkChecks.ifNewOrOldFormat(oRulesEngine, sRefFile, 1);
                oResult = formatRefHost ? ((oNodesList = NetworkChecks.getNodeNames(oRulesEngine, sRefFile, 1)) != null ? NetworkChecks.areNodesAliveHelper(oNodesList) : OipcrResult.NOT_EXECUTED_RESULT) : NetworkChecks.areNodesAlive(oRulesEngine, sRefFile);
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        catch (OipcrExecuteRuleException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckNoReferenceSpecifiedException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownBuilderException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        return oResult;
    }

    private static OipcrIResult checkIfNodesInSameDomainHelper(OipcrIRulesEngine oRulesEngine, String sRefFile, List oNodesList) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        if (oNodesList != null) {
            int iSize = oNodesList.size();
            ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
            String sDomain = null;
            for (int i = 0; i < iSize; ++i) {
                String sName = (String)oNodesList.get(i);
                OipcrIResult oRes = null;
                String sActual = null;
                try {
                    InetAddress oAddress = InetAddress.getByName(sName);
                    sActual = oAddress.getCanonicalHostName();
                    int idx = sActual.indexOf(".");
                    String sCurDomain = sActual.substring(idx);
                    if (sDomain == null) {
                        sDomain = sCurDomain;
                    }
                    oRes = sCurDomain.equals(sDomain) ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                    oResDetails.add(new OipcrResultDetails((Object)sActual, (Object)sName, oRes));
                    continue;
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            oResult = new OipcrResult(oResDetails);
        } else {
            oResult = OipcrResult.PASSED_RESULT;
        }
        return oResult;
    }

    public static OipcrIResult checkIfPrivateNodesInSameDomain(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        try {
            if (oRulesEngine != null) {
                List oNodesList = null;
                boolean formatRefHost = NetworkChecks.ifNewOrOldFormat(oRulesEngine, sRefFile, 0);
                oResult = formatRefHost ? ((oNodesList = NetworkChecks.getNodeNames(oRulesEngine, sRefFile, 0)) != null ? NetworkChecks.checkIfNodesInSameDomainHelper(oRulesEngine, sRefFile, oNodesList) : OipcrResult.NOT_EXECUTED_RESULT) : NetworkChecks.checkIfNodesInSameDomain(oRulesEngine, sRefFile);
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        catch (OipcrExecuteRuleException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckNoReferenceSpecifiedException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownBuilderException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        return oResult;
    }

    public static OipcrIResult checkIfVIPNodesInSameDomain(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        try {
            if (oRulesEngine != null) {
                List oNodesList = null;
                boolean formatRefHost = NetworkChecks.ifNewOrOldFormat(oRulesEngine, sRefFile, 2);
                oResult = formatRefHost ? ((oNodesList = NetworkChecks.getNodeNames(oRulesEngine, sRefFile, 2)) != null ? NetworkChecks.checkIfNodesInSameDomainHelper(oRulesEngine, sRefFile, oNodesList) : OipcrResult.NOT_EXECUTED_RESULT) : NetworkChecks.checkIfNodesInSameDomain(oRulesEngine, sRefFile);
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        catch (OipcrExecuteRuleException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckNoReferenceSpecifiedException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownBuilderException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        return oResult;
    }

    public static OipcrIResult checkIfClusterNodesInSameDomain(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        try {
            if (oRulesEngine != null) {
                List oNodesList = null;
                boolean formatRefHost = NetworkChecks.ifNewOrOldFormat(oRulesEngine, sRefFile, 1);
                oResult = formatRefHost ? ((oNodesList = NetworkChecks.getNodeNames(oRulesEngine, sRefFile, 1)) != null ? NetworkChecks.checkIfNodesInSameDomainHelper(oRulesEngine, sRefFile, oNodesList) : OipcrResult.NOT_EXECUTED_RESULT) : NetworkChecks.checkIfNodesInSameDomain(oRulesEngine, sRefFile);
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        catch (OipcrExecuteRuleException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckNoReferenceSpecifiedException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownBuilderException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        return oResult;
    }

    private static OipcrIResult checkIPNodeNameConflictHelper(List oNodesList) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        ArrayList oIpsList = new ArrayList();
        if (oNodesList != null && oIpsList != null && oIpsList.size() > 0) {
            int iSize = oNodesList.size();
            ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
            for (int i = 0; i < iSize; ++i) {
                String sName = (String)oNodesList.get(i);
                String sIP = (String)oIpsList.get(i);
                Object[] expArgs = new String[]{sName, sIP};
                String sExpected = OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_IP_NODE_NAME_FORMAT", (Object[])expArgs);
                OipcrIResult oRes = null;
                String sActual = null;
                try {
                    InetAddress oAddress = InetAddress.getByName(sName);
                    sActual = oAddress.getHostAddress();
                    oRes = sActual.equals(sIP) ? OipcrResult.PASSED_RESULT : OipcrResult.FAILED_RESULT;
                    oResDetails.add(new OipcrResultDetails((Object)sActual, (Object)sExpected, oRes));
                    continue;
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            oResult = new OipcrResult(oResDetails);
        } else {
            oResult = OipcrResult.PASSED_RESULT;
        }
        return oResult;
    }

    public static OipcrIResult checkIPClusterNodeNameConflict(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        try {
            if (oRulesEngine != null) {
                List oNodesList = null;
                boolean formatRefHost = NetworkChecks.ifNewOrOldFormat(oRulesEngine, sRefFile, 1);
                oResult = formatRefHost ? ((oNodesList = NetworkChecks.getNodeNames(oRulesEngine, sRefFile, 1)) != null ? NetworkChecks.checkIPNodeNameConflictHelper(oNodesList) : OipcrResult.NOT_EXECUTED_RESULT) : NetworkChecks.checkIPNodeNameConflict(oRulesEngine, sRefFile);
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        catch (OipcrExecuteRuleException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckNoReferenceSpecifiedException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownBuilderException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        return oResult;
    }

    public static OipcrIResult checkIPPrivateNodeNameConflict(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        try {
            if (oRulesEngine != null) {
                List oNodesList = null;
                boolean formatRefHost = NetworkChecks.ifNewOrOldFormat(oRulesEngine, sRefFile, 0);
                oResult = formatRefHost ? ((oNodesList = NetworkChecks.getNodeNames(oRulesEngine, sRefFile, 0)) != null ? NetworkChecks.checkIPNodeNameConflictHelper(oNodesList) : OipcrResult.NOT_EXECUTED_RESULT) : NetworkChecks.checkIPNodeNameConflict(oRulesEngine, sRefFile);
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        catch (OipcrExecuteRuleException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckNoReferenceSpecifiedException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownBuilderException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        return oResult;
    }

    public static OipcrIResult checkIPVIPNodeNameConflict(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult = OipcrResult.NOT_EXECUTED_RESULT;
        try {
            if (oRulesEngine != null) {
                List oNodesList = null;
                boolean formatRefHost = NetworkChecks.ifNewOrOldFormat(oRulesEngine, sRefFile, 2);
                oResult = formatRefHost ? ((oNodesList = NetworkChecks.getNodeNames(oRulesEngine, sRefFile, 2)) != null ? NetworkChecks.checkIPNodeNameConflictHelper(oNodesList) : OipcrResult.NOT_EXECUTED_RESULT) : NetworkChecks.checkIPNodeNameConflict(oRulesEngine, sRefFile);
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        catch (OipcrExecuteRuleException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckKnowledgeSourceException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckNoReferenceSpecifiedException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        catch (OipckUnknownBuilderException e) {
            oResult = OipcrResult.getNotExecutedResult((OiixException)e);
        }
        return oResult;
    }
}

