/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.prov.prereqs;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import oracle.sysman.oii.oiis.OiisVariable;
import oracle.sysman.oii.oiis.OiisVariableOwner;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oii.oiix.OiixFunctionOps;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oii.oiix.OiixSpawnException;
import oracle.sysman.oii.oiix.OiixSpawner;
import oracle.sysman.oip.oipc.oipch.OipchGenericRefHost;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipck.OipckNoReferenceSpecifiedException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownBuilderException;
import oracle.sysman.oip.oipc.oipck.OipckUnknownKnowledgeSourceException;
import oracle.sysman.oip.oipc.oipcr.OipcrExecuteRuleException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIRulesEngine;
import oracle.sysman.oip.oipc.oipcr.OipcrResult;
import oracle.sysman.oip.oipc.oipcr.OipcrResultDetails;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ScriptChecks {
    private ScriptChecks() {
    }

    public static OipcrIResult checkScripts(OipcrIRulesEngine oRulesEngine, String sRefFile) {
        OipcrIResult oResult;
        block18: {
            oResult = OipcrResult.NOT_EXECUTED_RESULT;
            if (oRulesEngine != null) {
                try {
                    ArrayList oScriptsList = new ArrayList();
                    boolean bIsOr = ScriptChecks.parseXMLToPrepareCheck(oRulesEngine, sRefFile, oScriptsList);
                    if (oScriptsList == null || oScriptsList.size() <= 0) break block18;
                    ArrayList<OipcrResultDetails> oResDetails = new ArrayList<OipcrResultDetails>();
                    boolean bExit = false;
                    for (int i = 0; i < oScriptsList.size() && !bExit; ++i) {
                        File oFile;
                        String sFullScript = (String)oScriptsList.get(i);
                        OipcrIResult oRes = null;
                        boolean bSuccess = false;
                        String sActual = null;
                        int idx = sFullScript.indexOf(" ");
                        String sScript = sFullScript;
                        if (idx != -1) {
                            sScript = sFullScript.substring(0, idx);
                        }
                        if ((oFile = new File(sScript)).exists()) {
                            ByteArrayOutputStream oOut = new ByteArrayOutputStream();
                            ArrayList<OutputStream> oOuts = new ArrayList<OutputStream>();
                            ArrayList<OutputStream> oErrs = new ArrayList<OutputStream>();
                            oOuts.add(System.out);
                            oOuts.add(oOut);
                            oErrs.add(System.err);
                            oErrs.add(oOut);
                            OiixSpawner oSpawner = new OiixSpawner(oOuts, oErrs);
                            try {
                                oSpawner.execute(sFullScript);
                            }
                            catch (OiixSpawnException e) {
                                throw new OipcrExecuteRuleException((Throwable)e);
                            }
                            if (oSpawner.getResultCode() == 0) {
                                oRes = OipcrResult.PASSED_RESULT;
                                if (bIsOr) {
                                    oResDetails.clear();
                                    bExit = true;
                                }
                            } else {
                                oRes = OipcrResult.FAILED_RESULT;
                            }
                            sActual = oOut.toString();
                            try {
                                oOut.close();
                            }
                            catch (IOException e) {
                                throw new OipcrExecuteRuleException((Throwable)e);
                            }
                        }
                        oRes = OipcrResult.PASSED_RESULT;
                        oResDetails.add(new OipcrResultDetails(sActual, (Object)sFullScript, oRes));
                    }
                    oResult = new OipcrResult(oResDetails);
                }
                catch (OipcrExecuteRuleException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckKnowledgeSourceException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckNoReferenceSpecifiedException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
                catch (OipckUnknownBuilderException e) {
                    oResult = OipcrResult.getNotExecutedResult((OiixException)e);
                }
            } else {
                oResult = OipcrResult.getNotExecutedResult((OiixException)new OipcrExecuteRuleException("OUI-15042", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcr.resources.OipcrRuntimeRes", (String)"OUI-15042")));
            }
        }
        return oResult;
    }

    private static boolean parseXMLToPrepareCheck(OipcrIRulesEngine oRulesEngine, String sRefFile, List oScriptsList) throws OipcrExecuteRuleException, OipckUnknownKnowledgeSourceException, OipckNoReferenceSpecifiedException, OipckUnknownBuilderException, OipckKnowledgeSourceException {
        boolean bIsOr = false;
        OipchGenericRefHost oGenRefHost = (OipchGenericRefHost)oRulesEngine.getRefKnowledgeSource("genrefhost", sRefFile);
        OiisVariableOwner oContext = (OiisVariableOwner)oRulesEngine.getKnowledgeSource("sessioncontext");
        Node oScriptsNode = oGenRefHost.getNode("SCRIPTS");
        if (oScriptsNode != null) {
            NodeList oNodes;
            NamedNodeMap oScriptsAtts = null;
            oScriptsAtts = oScriptsNode.getAttributes();
            if (oScriptsAtts != null) {
                String sType;
                Node oScriptAttrib = null;
                oScriptAttrib = oScriptsAtts.getNamedItem("TYPE");
                if (oScriptAttrib != null && (sType = oScriptAttrib.getNodeValue()) != null && sType.equalsIgnoreCase("OR")) {
                    bIsOr = true;
                }
            }
            if ((oNodes = oScriptsNode.getChildNodes()) != null) {
                int iNodes = oNodes.getLength();
                Node oNode = null;
                NamedNodeMap oNodeAttribs = null;
                for (int i = 0; i < iNodes; ++i) {
                    oNode = oNodes.item(i);
                    if (oNode.getNodeType() != 1 || !oNode.getNodeName().equalsIgnoreCase("SCRIPT")) continue;
                    oNodeAttribs = oNode.getAttributes();
                    String sScript = null;
                    if (oNodeAttribs == null) {
                        Object[] args = new String[]{sRefFile};
                        throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_SCRIPT_UNDER_SCRIPTS", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_SCRIPT_UNDER_SCRIPTS", (Object[])args));
                    }
                    sScript = ScriptChecks.getValue(oNodeAttribs, oContext);
                    if (sScript == null) continue;
                    NodeList oArgNodes = oNode.getChildNodes();
                    if (oArgNodes != null) {
                        int iArgNodes = oArgNodes.getLength();
                        Node oArgNode = null;
                        NamedNodeMap oArgNodeAttribs = null;
                        for (int j = 0; j < iArgNodes; ++j) {
                            oArgNode = oArgNodes.item(j);
                            if (oArgNode.getNodeType() != 1 || !oArgNode.getNodeName().equalsIgnoreCase("ARG")) continue;
                            oArgNodeAttribs = oArgNode.getAttributes();
                            if (oArgNodeAttribs != null) {
                                String sArg = ScriptChecks.getValue(oArgNodeAttribs, oContext);
                                if (sArg == null) continue;
                                sScript = sScript + sArg;
                                continue;
                            }
                            Object[] args = new String[]{sRefFile};
                            throw new OipcrExecuteRuleException("S_NO_ATTS_FOR_SCRIPT_UNDER_SCRIPTS", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_ATTS_FOR_SCRIPT_UNDER_SCRIPTS", (Object[])args));
                        }
                    }
                    oScriptsList.add(sScript);
                }
            }
        } else {
            Object[] args = new String[]{sRefFile};
            throw new OipcrExecuteRuleException("S_NO_SCRIPTS_INFO", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_SCRIPTS_INFO", (Object[])args));
        }
        return bIsOr;
    }

    private static String getValue(NamedNodeMap oAtts, OiisVariableOwner oCtxt) throws OipcrExecuteRuleException {
        String sValue = null;
        if (oAtts != null) {
            Node oAttrib = null;
            oAttrib = oAtts.getNamedItem("VAR");
            if (oAttrib != null) {
                OiisVariable oVar;
                String sVar = oAttrib.getNodeValue();
                if (sVar != null && (oVar = oCtxt.getVariable(sVar)) != null) {
                    try {
                        sValue = (String)oVar.getValue();
                    }
                    catch (ClassCastException oCce1) {
                        try {
                            String[] asVal = (String[])oVar.getValue();
                            sValue = OiixFunctionOps.implodeList((String[])asVal, (String)",");
                        }
                        catch (ClassCastException oCce2) {}
                    }
                }
            } else {
                oAttrib = oAtts.getNamedItem("VALUE");
                if (oAttrib != null) {
                    sValue = oAttrib.getNodeValue();
                } else {
                    throw new OipcrExecuteRuleException("S_NO_VAR_OR_VALUE_FOR_SCRIPT_ARG_UNDER_SCRIPTS", OiixResourceBundle.getString((String)"oracle.sysman.prov.prereqs.resources.PrereqsRuntimeRes", (String)"S_NO_VAR_OR_VALUE_FOR_SCRIPT_ARG_UNDER_SCRIPTS"));
                }
            }
        }
        return sValue;
    }
}

