/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.verification;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.impl.verification.FixupNodeResultImpl;
import oracle.cluster.verification.FixupNodeResult;
import oracle.cluster.verification.FixupOverallStatus;
import oracle.cluster.verification.FixupResultSet;
import oracle.cluster.verification.InvalidFixupNodeException;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.verification.framework.util.VerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixupResultSetImpl
implements FixupResultSet {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private boolean m_anyExecutionFailure = false;
    private List<String> m_succNodes = new ArrayList<String>();
    private List<String> m_failNodes = new ArrayList<String>();
    private List<VerificationError> m_overallErrors = new ArrayList<VerificationError>();
    private Hashtable m_resultTable = new Hashtable();

    public FixupResultSetImpl(String[] nodeList) {
        for (int i = 0; i < nodeList.length; ++i) {
            String node = nodeList[i];
            this.m_resultTable.put(node, new FixupNodeResultImpl(node));
            this.m_succNodes.add(node);
        }
    }

    @Override
    public FixupOverallStatus getFixupOverallStatus() {
        if (this.m_anyExecutionFailure) {
            return FixupOverallStatus.FAILED;
        }
        return FixupOverallStatus.SUCCESSFUL;
    }

    @Override
    public List<String> getSuccessfulNodes() {
        return this.m_succNodes;
    }

    @Override
    public List<String> getFailedNodes() {
        return this.m_failNodes;
    }

    @Override
    public List<FixupNodeResult> getNodeResults() {
        ArrayList<FixupNodeResult> nodeResults = new ArrayList<FixupNodeResult>(this.m_resultTable.size());
        Enumeration e = this.m_resultTable.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            nodeResults.add((FixupNodeResult)this.m_resultTable.get(node));
        }
        return nodeResults;
    }

    @Override
    public FixupNodeResult getNodeResult(String node) throws InvalidFixupNodeException {
        if (this.m_resultTable.isEmpty()) {
            throw new InvalidFixupNodeException(s_msgBundle.getMessage("7503", false));
        }
        return (FixupNodeResult)this.m_resultTable.get(node);
    }

    @Override
    public List<VerificationError> getErrors() {
        return this.m_overallErrors;
    }
}

