/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification;

import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.impl.verification.CommandExecResultSetImpl;
import oracle.cluster.impl.verification.FixupResultSetImpl;
import oracle.cluster.impl.verification.NodeConnectivityResultSetImpl;
import oracle.cluster.impl.verification.SharedStorageResultSetImpl;
import oracle.cluster.verification.CommandExecID;
import oracle.cluster.verification.CommandExecResultSet;
import oracle.cluster.verification.FixupGeneratorResult;
import oracle.cluster.verification.FixupResultSet;
import oracle.cluster.verification.HAInstalledException;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.NoFixupGeneratorResultException;
import oracle.cluster.verification.NodeConnectivityResultSet;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.ParamPreReqCRSInst;
import oracle.cluster.verification.ParamPreReqDBConfig;
import oracle.cluster.verification.ParamPreReqDBInst;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.PreReqType;
import oracle.cluster.verification.PrivilegedUserInfo;
import oracle.cluster.verification.SharedStorageResultSet;
import oracle.cluster.verification.ShellLimitType;
import oracle.cluster.verification.ShellResourceType;
import oracle.cluster.verification.ShellType;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.SubtasksNotCompleteException;
import oracle.cluster.verification.UserEquivCheckType;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationResultSet;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskAdminPrivileges;
import oracle.ops.verification.framework.engine.task.TaskArchitecture;
import oracle.ops.verification.framework.engine.task.TaskAvailableMemory;
import oracle.ops.verification.framework.engine.task.TaskBinaryMatching;
import oracle.ops.verification.framework.engine.task.TaskCFSIntegrity;
import oracle.ops.verification.framework.engine.task.TaskCRSIntegrity;
import oracle.ops.verification.framework.engine.task.TaskClusterIntegrity;
import oracle.ops.verification.framework.engine.task.TaskClusterMgrIntegrity;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.engine.task.TaskGroupExistence;
import oracle.ops.verification.framework.engine.task.TaskGroupMembership;
import oracle.ops.verification.framework.engine.task.TaskHAIntegrity;
import oracle.ops.verification.framework.engine.task.TaskKernelParam;
import oracle.ops.verification.framework.engine.task.TaskKernelVersion;
import oracle.ops.verification.framework.engine.task.TaskNodeAppCreation;
import oracle.ops.verification.framework.engine.task.TaskNodeConnectivity;
import oracle.ops.verification.framework.engine.task.TaskOCRIntegrity;
import oracle.ops.verification.framework.engine.task.TaskOLRIntegrity;
import oracle.ops.verification.framework.engine.task.TaskOSPatch;
import oracle.ops.verification.framework.engine.task.TaskPackage;
import oracle.ops.verification.framework.engine.task.TaskPhysicalMemory;
import oracle.ops.verification.framework.engine.task.TaskProcessAlive;
import oracle.ops.verification.framework.engine.task.TaskRunLevel;
import oracle.ops.verification.framework.engine.task.TaskSharedStorageAccess;
import oracle.ops.verification.framework.engine.task.TaskShellLimits;
import oracle.ops.verification.framework.engine.task.TaskSpaceAvail;
import oracle.ops.verification.framework.engine.task.TaskSwapSize;
import oracle.ops.verification.framework.engine.task.TaskTimeZoneSetting;
import oracle.ops.verification.framework.engine.task.TaskUserExistence;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.param.InvalidCommandlineException;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.util.InvalidEnvironmentException;
import oracle.ops.verification.framework.util.VerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClusterVerification {
    private static ParamManager m_pm = null;
    private static ClusterVerification s_clusterVerification;
    private static MessageBundle s_msgBundle;

    private ClusterVerification(String workDir, String frameworkHome) throws VerificationException {
        VerificationUtil.setDestLoc(workDir);
        VerificationUtil.setCVHome(frameworkHome);
        try {
            VerificationUtil.getExecutionEnvironment();
        }
        catch (InvalidEnvironmentException e) {
            throw new VerificationException((Throwable)((Object)e));
        }
    }

    public void setTracing(boolean trace) {
        String traceLvl;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. trace = " + trace));
        }
        if ((traceLvl = System.getProperty("TRACING.LEVEL")) == null) {
            traceLvl = new String("5");
        }
        if (trace) {
            System.setProperty("TRACING.ENABLED", "true");
            System.setProperty("TRACING.LEVEL", traceLvl);
        } else {
            System.setProperty("TRACING.ENABLED", "false");
        }
        VerificationUtil.setupTracing(false);
    }

    public static synchronized ClusterVerification getInstance() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        if (s_clusterVerification == null) {
            ClusterVerification.setParamManager();
            s_clusterVerification = new ClusterVerification(ClusterVerification.getDefaultWorkDir(), ClusterVerification.getDefaultFrameworkHome());
        }
        return s_clusterVerification;
    }

    public static synchronized ClusterVerification getInstance(String workDir, String frameworkHome) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. workDir=" + workDir + " frameworkHome=" + frameworkHome));
        }
        if (s_clusterVerification == null) {
            ClusterVerification.assertWorkDir(workDir);
            ClusterVerification.assertFrameworkHome(frameworkHome);
            ClusterVerification.setParamManager();
            s_clusterVerification = new ClusterVerification(workDir, frameworkHome);
        }
        return s_clusterVerification;
    }

    public static synchronized ClusterVerification getInstance(String path, PathType type) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. path=" + path + " type=" + (Object)((Object)type)));
        }
        if (s_clusterVerification == null) {
            String frameworkHome;
            String workDir;
            if (type == PathType.WORK_DIR) {
                ClusterVerification.assertWorkDir(path);
                workDir = path;
                ClusterVerification.setParamManager();
                frameworkHome = ClusterVerification.getDefaultFrameworkHome();
            } else {
                ClusterVerification.assertFrameworkHome(path);
                frameworkHome = path;
                ClusterVerification.setParamManager();
                workDir = ClusterVerification.getDefaultWorkDir();
            }
            s_clusterVerification = new ClusterVerification(workDir, frameworkHome);
        }
        return s_clusterVerification;
    }

    private static void setParamManager() throws VerificationException {
        try {
            m_pm = ParamManager.getInstance(ParamManager.OperationMode.MODE_API, null);
        }
        catch (InvalidCommandlineException e) {
            throw new VerificationException(e);
        }
    }

    public List<VerificationTask> getPreReqTasksForCRSInst(String[] nodeList) throws PreReqNotSupportedException, VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        ClusterVerification.assertNodes(nodeList);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_CRS_INST, nodeList);
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForCRSInst(String[] nodeList, ParamPreReqCRSInst param) throws VerificationException, PreReqNotSupportedException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " param=" + param));
        }
        ClusterVerification.assertNodes(nodeList);
        this.assertParamPreReq(param);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_CRS_INST, nodeList, param);
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForDBInst(String[] nodeList) throws VerificationException, PreReqNotSupportedException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        ClusterVerification.assertNodes(nodeList);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_DB_INST, nodeList);
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForDBInst(String[] nodeList, ParamPreReqDBInst param) throws VerificationException, PreReqNotSupportedException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " param=" + param));
        }
        ClusterVerification.assertNodes(nodeList);
        this.assertParamPreReq(param);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_DB_INST, nodeList, param);
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForSIHAInst() throws VerificationException, PreReqNotSupportedException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationUtil.setLocalNodeOperation(true);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_SI_HA_INST, nodeList);
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForSIDBInst() throws VerificationException, PreReqNotSupportedException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationUtil.setLocalNodeOperation(true);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_SI_DB_INST, nodeList);
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForDBConfig(String oracleHome) throws VerificationException, PreReqNotSupportedException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. oracleHome=" + oracleHome));
        }
        ClusterVerification.assertOracleHome(oracleHome, true);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        ParamPreReqDBConfig paramCfg = new ParamPreReqDBConfig(oracleHome);
        VerificationUtil.setLocalNodeOperation(true);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_DB_CONFIG, nodeList, paramCfg);
            return Arrays.asList(taskList.toArray(new Task[taskList.size()]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForDBConfig(String[] nodeList, String oracleHome) throws VerificationException, PreReqNotSupportedException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " oracleHome=" + oracleHome));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertOracleHome(oracleHome, false);
        ParamPreReqDBConfig paramCfg = new ParamPreReqDBConfig(oracleHome);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_DB_CONFIG, nodeList, paramCfg);
            return Arrays.asList(taskList.toArray(new Task[taskList.size()]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForDBConfig(String[] nodeList, ParamPreReqDBConfig param) throws VerificationException, PreReqNotSupportedException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " param=" + param));
        }
        ClusterVerification.assertNodes(nodeList);
        this.assertParamPreReq(param);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_DB_CONFIG, nodeList, param);
            return Arrays.asList(taskList.toArray(new Task[taskList.size()]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForSIDBConfig(String oracleHome) throws VerificationException, PreReqNotSupportedException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. oracleHome=" + oracleHome));
        }
        ClusterVerification.assertOracleHome(oracleHome, true);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        ParamPreReqDBConfig paramCfg = new ParamPreReqDBConfig(oracleHome);
        VerificationUtil.setLocalNodeOperation(true);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_SI_DB_CONFIG, nodeList, paramCfg);
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public CommandExecResultSet executeCommand(String[] nodeList, String oracleHome, CommandExecID commandID, String[] args, int timeout) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " oracleHome=" + oracleHome + " commandID=" + (Object)((Object)commandID) + "args=" + VerificationUtil.strArr2List(args) + " timeout=" + timeout));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertOracleHomeForCmdExec(oracleHome);
        CommandExecResultSetImpl cmdExecResultset = new CommandExecResultSetImpl(nodeList);
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(nodeList);
        if (!setupResultSet.allSuccess()) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"At least one failure in checking framework setup");
            }
            cmdExecResultset.setErrors(setupResultSet);
            if (!setupResultSet.anySuccess()) {
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"Failure on all the nodes in checking framework setup");
                }
                return cmdExecResultset;
            }
        }
        String[] validNodes = setupResultSet.getSuccessfulNodes().toArray(new String[0]);
        String cmd = oracleHome + VerificationConstants.FSEP + "bin" + VerificationConstants.FSEP + (Object)((Object)commandID);
        if (args != null) {
            cmd = cmd + " " + VerificationUtil.strArr2List(args, " ");
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("cmd=" + cmd));
        }
        GlobalExecution globalExec = new GlobalExecution();
        Hashtable htRunExe = globalExec.runExeWithOutput(validNodes, cmd, new ResultSet());
        cmdExecResultset.setCommandExecutionResults(htRunExe);
        return cmdExecResultset;
    }

    public VerificationResult checkSpaceAvailability(String path, long size, StorageUnit unit) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. path=" + path + " size=" + size + " unit=" + (Object)((Object)unit)));
        }
        ClusterVerification.assertPath(path);
        ClusterVerification.assertSize(size);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            clusterCmd.pathExists(new String[]{"localnode"}, path, 1);
        }
        catch (ClusterException ce) {
            throw new InvalidPathException(s_msgBundle.getMessage("7509", false, (Object[])new String[]{path}), ce);
        }
        catch (ClusterOperationException ce) {
            throw new VerificationException(ce);
        }
        VerificationResultSet resultSet = this.checkSpaceAvailability(true, nodeList, path, size, unit);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkSpaceAvailability(String[] nodeList, String path, long size, StorageUnit unit) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " path=" + path + " size=" + size + " unit=" + (Object)((Object)unit)));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertPath(path);
        ClusterVerification.assertSize(size);
        ClusterVerification.assertStorageUnit(unit);
        return this.checkSpaceAvailability(false, nodeList, path, size, unit);
    }

    private VerificationResultSet checkSpaceAvailability(boolean localNode, String[] nodeList, String path, long size, StorageUnit unit) throws VerificationException, InvalidPathException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskSpaceAvail spaceTask = new TaskSpaceAvail(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        spaceTask.setLocation(path);
        StorageSize reqdSpace = new StorageSize(size, unit);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)(" required space = " + reqdSpace));
        }
        spaceTask.setReqdSpace(reqdSpace);
        try {
            resultSet = spaceTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(spaceTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkOLRIntegrity() throws VerificationException, HAInstalledException {
        VerificationResultSet resultSet;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup();
        if (!setupResultSet.anySuccess()) {
            try {
                return setupResultSet.getNodeResult(localNode, true);
            }
            catch (NodeResultsUnavailableException e1) {
                throw new VerificationException(e1);
            }
        }
        if (!VerificationUtil.isHAInstalled() && !VerificationUtil.isCRSInstalled()) {
            throw new HAInstalledException(s_msgBundle.getMessage("5314", true));
        }
        TaskOLRIntegrity taskOLRI = new TaskOLRIntegrity(nodeList);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("Check OLR integrity on: " + localNode));
        }
        try {
            resultSet = taskOLRI.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskOLRI, resultSet);
        }
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResult checkHAIntegrity() throws VerificationException, HAInstalledException {
        VerificationResultSet resultSet;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup();
        if (!setupResultSet.anySuccess()) {
            try {
                return setupResultSet.getNodeResult(localNode, true);
            }
            catch (NodeResultsUnavailableException e) {
                throw new VerificationException(e);
            }
        }
        if (!VerificationUtil.isHAInstalled()) {
            throw new HAInstalledException(s_msgBundle.getMessage("4112", false));
        }
        TaskHAIntegrity taskHAI = new TaskHAIntegrity(nodeList);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("Check HA integrity on: " + localNode));
        }
        try {
            resultSet = taskHAI.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskHAI, resultSet);
        }
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkNodeReachability(String[] nodeList) throws VerificationException {
        VerificationResultSet resultSet;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        ClusterVerification.assertNodes(nodeList);
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup();
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskNodeConnectivity nodeReachTask = new TaskNodeConnectivity(nodeList);
        nodeReachTask.setTaskType(1);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("Check node reachability to: " + nodeList));
        }
        try {
            resultSet = nodeReachTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(nodeReachTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResultSet checkNodeReachability(String referenceNode, String[] nodeList) throws VerificationException {
        VerificationResultSet resultSet;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. referenceNode= " + referenceNode + "nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        ClusterVerification.assertNode(referenceNode);
        ClusterVerification.assertNodes(nodeList);
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(new String[]{referenceNode});
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskNodeConnectivity nodeReachTask = new TaskNodeConnectivity(nodeList);
        nodeReachTask.setSourceNode(referenceNode);
        nodeReachTask.setTaskType(1);
        if (Trace.isLevelEnabled((int)1)) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("referenceNode: " + referenceNode));
            }
            for (int i = 0; i < nodeList.length; ++i) {
                Trace.out((String)("Check node reachability from " + referenceNode + " to: " + nodeList[i]));
            }
        }
        try {
            resultSet = nodeReachTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(nodeReachTask, resultSet);
        }
        return resultSet;
    }

    public NodeConnectivityResultSet checkNodeConnectivity(String[] nodeList) throws VerificationException {
        VerificationResultSet resultSet;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"No interface(s) specified.");
        }
        ClusterVerification.assertNodes(nodeList);
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(nodeList);
        if (!setupResultSet.anySuccess()) {
            NodeConnectivityResultSetImpl netConResSet = new NodeConnectivityResultSetImpl();
            netConResSet.uploadResultSet(setupResultSet);
            return netConResSet;
        }
        TaskNodeConnectivity nodeConnTask = new TaskNodeConnectivity(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        nodeConnTask.setTaskType(0);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"Node(s): ");
            for (int i = 0; i < nodeList.length; ++i) {
                Trace.out((String)nodeList[i]);
            }
        }
        try {
            resultSet = nodeConnTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        NodeConnectivityResultSetImpl nodeConResSetImpl = nodeConnTask.getNodeConnectivityResultSetImpl();
        nodeConResSetImpl.uploadResultSet(setupResultSet);
        nodeConResSetImpl.uploadResultSet((ResultSet)resultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(nodeConnTask, resultSet);
        }
        return nodeConResSetImpl;
    }

    public NodeConnectivityResultSet checkNodeConnectivity(String[] nodeList, String interfaceName) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " interfaceName=" + interfaceName));
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"Interface specified).");
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertInterface(interfaceName);
        String[] interfaceList = null;
        if (interfaceName != null) {
            interfaceList = new String[]{interfaceName};
        }
        if (!(setupResultSet = (ResultSet)this.checkFrameworkSetup(nodeList)).anySuccess()) {
            NodeConnectivityResultSetImpl netConResSet = new NodeConnectivityResultSetImpl();
            netConResSet.uploadResultSet(setupResultSet);
            return netConResSet;
        }
        TaskNodeConnectivity nodeConnTask = new TaskNodeConnectivity(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        nodeConnTask.setTaskType(0);
        nodeConnTask.setInterfaceList(interfaceList);
        if (Trace.isLevelEnabled((int)1)) {
            for (int i = 0; i < nodeList.length; ++i) {
                Trace.out((String)("Node(s):" + nodeList[i]));
            }
            Trace.out((String)("Interface:" + interfaceList));
        }
        try {
            resultSet = nodeConnTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        NodeConnectivityResultSetImpl nodeConResSetImpl = nodeConnTask.getNodeConnectivityResultSetImpl();
        nodeConResSetImpl.uploadResultSet(setupResultSet);
        nodeConResSetImpl.uploadResultSet((ResultSet)resultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(nodeConnTask, resultSet);
        }
        return nodeConResSetImpl;
    }

    public SharedStorageResultSet checkSharedStorageAccessibility(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        return this.checkSharedStorageAccessibility(nodeList, OracleFileType.RAC_DATA_FILES);
    }

    public SharedStorageResultSet checkSharedStorageAccessibility(String[] nodeList, OracleFileType fileType) throws VerificationException {
        VerificationResultSet resultSet;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + "fileType=" + (Object)((Object)fileType)));
        }
        ClusterVerification.assertNodes(nodeList);
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(nodeList);
        if (!setupResultSet.anySuccess()) {
            SharedStorageResultSetImpl ssConResSet = new SharedStorageResultSetImpl();
            ssConResSet.uploadResultSet(setupResultSet);
            return ssConResSet;
        }
        TaskSharedStorageAccess ssaTask = new TaskSharedStorageAccess(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        ssaTask.setOracleFileType(fileType);
        try {
            resultSet = ssaTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        SharedStorageResultSetImpl ssResSetImpl = ssaTask.getSharedStorageResultSetImpl();
        ssResSetImpl.uploadResultSet(setupResultSet);
        if (Trace.isTraceEnabled()) {
            this.traceTaskResultSet(ssaTask, resultSet);
            Trace.out((String)("ssResSetImpl(status)==>" + (Object)((Object)ssResSetImpl.getOverallStatus())));
            Trace.out((String)("ssResSetImpl(hasNodeValues)==>" + ssResSetImpl.hasNodeResults()));
        }
        return ssResSetImpl;
    }

    public VerificationResultSet checkSharedStorageAccessibility(String[] nodeList, String path, boolean OCRorVDisk) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " path=" + path + "OCRorVDisk=" + OCRorVDisk));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertPath(path);
        return this.checkSharedStorageAccessibility(nodeList, path, true, OCRorVDisk, OracleFileType.RAC_OCR_VDISK);
    }

    public VerificationResultSet checkSharedStorageAccessibility(String[] nodeList, String path) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " path=" + path));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertPath(path);
        return this.checkSharedStorageAccessibility(nodeList, path, false, false);
    }

    public VerificationResultSet checkSharedStorageAccessibility(String[] nodeList, String path, boolean spDev, boolean OCRorVDisk) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " path=" + path + " spDev=" + spDev + " OCRorVDisk=" + OCRorVDisk));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertPath(path);
        return this.checkSharedStorageAccessibility(nodeList, path, spDev, OCRorVDisk, OracleFileType.RAC_DATA_FILES);
    }

    public VerificationResultSet checkSharedStorageAccessibility(String[] nodeList, String path, OracleFileType fileType) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " path=" + path + " fileType=" + (Object)((Object)fileType)));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertPath(path);
        boolean ocrOrVdisk = fileType.equals((Object)OracleFileType.RAC_OCR_VDISK);
        return this.checkSharedStorageAccessibility(nodeList, path, ocrOrVdisk, ocrOrVdisk, fileType);
    }

    public VerificationResultSet checkSharedStorageAccessibility(String[] nodeList, String path, boolean spDev, boolean OCRorVDisk, OracleFileType fileType) throws VerificationException, InvalidPathException {
        VerificationResultSet resultSet;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " path=" + path + " spDev=" + spDev + " OCRorVDisk=" + OCRorVDisk));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertPath(path);
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(nodeList);
        if (!setupResultSet.anySuccess()) {
            SharedStorageResultSetImpl ssConResSet = new SharedStorageResultSetImpl();
            ssConResSet.uploadResultSet(setupResultSet);
            return ssConResSet;
        }
        TaskSharedStorageAccess ssaTask = new TaskSharedStorageAccess(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        ssaTask.setStorageID(path);
        ssaTask.setOracleFileType(fileType);
        if (spDev) {
            if (OCRorVDisk) {
                ssaTask.setOCRLocationFlag(true);
            } else {
                ssaTask.setVDiskLocationFlag(true);
            }
        }
        try {
            resultSet = ssaTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isTraceEnabled()) {
            this.traceTaskResultSet(ssaTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkPhysicalMemory(long size, StorageUnit unit) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. size=" + size + " unit=" + (Object)((Object)unit)));
        }
        ClusterVerification.assertSize(size);
        ClusterVerification.assertStorageUnit(unit);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkPhysicalMemory(true, nodeList, size, unit);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkPhysicalMemory(String[] nodeList, long size, StorageUnit unit) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " size=" + size + " unit=" + (Object)((Object)unit)));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertSize(size);
        ClusterVerification.assertStorageUnit(unit);
        return this.checkPhysicalMemory(false, nodeList, size, unit);
    }

    private VerificationResultSet checkPhysicalMemory(boolean localNode, String[] nodeList, long size, StorageUnit unit) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        StorageSize reqdPhyMem = new StorageSize(size, unit);
        TaskPhysicalMemory phyMemTask = new TaskPhysicalMemory(reqdPhyMem);
        phyMemTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("required physical memory = " + reqdPhyMem));
        }
        try {
            resultSet = phyMemTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(phyMemTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkAvailableMemory(long size, StorageUnit unit) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. size=" + size + " unit=" + (Object)((Object)unit)));
        }
        ClusterVerification.assertSize(size);
        ClusterVerification.assertStorageUnit(unit);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkAvailableMemory(true, nodeList, size, unit);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkAvailableMemory(String[] nodeList, long size, StorageUnit unit) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " size=" + size + " unit=" + (Object)((Object)unit)));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertSize(size);
        ClusterVerification.assertStorageUnit(unit);
        return this.checkAvailableMemory(false, nodeList, size, unit);
    }

    private VerificationResultSet checkAvailableMemory(boolean localNode, String[] nodeList, long size, StorageUnit unit) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        StorageSize avlMem = new StorageSize(size, unit);
        TaskAvailableMemory availMemTask = new TaskAvailableMemory(avlMem);
        availMemTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("sizeInBytes(" + size + "," + (Object)((Object)unit) + ")=" + VerificationUtil.sizeInBytes(size, unit)));
        }
        try {
            resultSet = availMemTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(availMemTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkRunlevel(int runLvl) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. runLvl=" + runLvl));
        }
        ClusterVerification.assertRunlevel(runLvl);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        ArrayList<Integer> runLvls = new ArrayList<Integer>();
        runLvls.add(runLvl);
        VerificationResultSet resultSet = this.checkRunlevel(true, nodeList, runLvls);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkRunlevel(String[] nodeList, int runLvl) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " runLvl=" + runLvl));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertRunlevel(runLvl);
        ArrayList<Integer> runLvls = new ArrayList<Integer>();
        runLvls.add(runLvl);
        return this.checkRunlevel(false, nodeList, runLvls);
    }

    public VerificationResult checkRunlevel(List<Integer> runLvls) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. runLvls=" + VerificationUtil.strCollection2String(runLvls)));
        }
        ClusterVerification.assertRunlevels(runLvls);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkRunlevel(true, nodeList, runLvls);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkRunlevel(String[] nodeList, List<Integer> runLvls) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " runLvls=" + VerificationUtil.strCollection2String(runLvls)));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertRunlevels(runLvls);
        return this.checkRunlevel(false, nodeList, runLvls);
    }

    private VerificationResultSet checkRunlevel(boolean localNode, String[] nodeList, List<Integer> runLvls) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskRunLevel runLvlTask = new TaskRunLevel(runLvls);
        runLvlTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Expected RunLevel: " + VerificationUtil.strCollection2String(runLvls)));
        }
        try {
            resultSet = runLvlTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(runLvlTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkSwapSize(double size, StorageUnit unit) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. size=" + size + " unit=" + (Object)((Object)unit)));
        }
        ClusterVerification.assertSize(size);
        ClusterVerification.assertStorageUnit(unit);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkSwapSize(true, nodeList, size, unit);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkSwapSize(String[] nodeList, double size, StorageUnit unit) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " size=" + size + " unit=" + (Object)((Object)unit)));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertSize(size);
        ClusterVerification.assertStorageUnit(unit);
        return this.checkSwapSize(false, nodeList, size, unit);
    }

    private VerificationResultSet checkSwapSize(boolean localNode, String[] nodeList, double size, StorageUnit unit) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        StorageSize swapSize = new StorageSize(size, unit);
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("require swap size = " + swapSize));
        }
        TaskSwapSize swapTask = new TaskSwapSize(swapSize);
        swapTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = swapTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(swapTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkProcAlive(String proc) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. proc=" + proc));
        }
        ClusterVerification.assertProc(proc);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkProcAlive(true, nodeList, proc);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkProcAlive(String[] nodeList, String proc) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " proc=" + proc));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertProc(proc);
        return this.checkProcAlive(false, nodeList, proc);
    }

    private VerificationResultSet checkProcAlive(boolean localNode, String[] nodeList, String proc) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskProcessAlive procAliveTask = new TaskProcessAlive(proc);
        procAliveTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Process Alive: " + proc));
        }
        try {
            resultSet = procAliveTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(procAliveTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkPackage(String name, String val) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. name=" + name + " val=" + val));
        }
        ClusterVerification.assertName(name);
        ClusterVerification.assertVal(val);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkPackage(true, nodeList, name, val, null);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkPackage(String[] nodeList, String name, String val) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " name=" + name + " val=" + val));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertName(name);
        ClusterVerification.assertVal(val);
        return this.checkPackage(false, nodeList, name, val, null);
    }

    public VerificationResult checkPackage(String name, String val, String arch) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. name=" + name + " val=" + val + " arch=" + arch));
        }
        ClusterVerification.assertName(name);
        ClusterVerification.assertVal(val);
        ClusterVerification.assertArch(arch);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkPackage(true, nodeList, name, val, arch);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkPackage(String[] nodeList, String name, String val, String arch) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " name=" + name + " val=" + val + " arch=" + arch));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertName(name);
        ClusterVerification.assertVal(val);
        ClusterVerification.assertArch(arch);
        return this.checkPackage(false, nodeList, name, val, arch);
    }

    private VerificationResultSet checkPackage(boolean localNode, String[] nodeList, String name, String val, String arch) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskPackage pkgTask = new TaskPackage(name, val, arch);
        pkgTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = pkgTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(pkgTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkArchitecture(String arch) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. arch=" + arch));
        }
        ClusterVerification.assertArch(arch);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkArchitecture(true, nodeList, Arrays.asList(arch));
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkArchitecture(String[] nodeList, String arch) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " arch=" + arch));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertArch(arch);
        return this.checkArchitecture(false, nodeList, Arrays.asList(arch));
    }

    public VerificationResult checkArchitecture(List<String> archList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. archList=" + VerificationUtil.strCollection2String(archList)));
        }
        ClusterVerification.assertArchs(archList);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkArchitecture(true, nodeList, archList);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkArchitecture(String[] nodeList, List<String> archList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " archList=" + VerificationUtil.strCollection2String(archList)));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertArchs(archList);
        return this.checkArchitecture(false, nodeList, archList);
    }

    private VerificationResultSet checkArchitecture(boolean localNode, String[] nodeList, List<String> archList) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskArchitecture archTask = new TaskArchitecture(archList);
        archTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = archTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(archTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkUserExistence(String user) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. user=" + user));
        }
        ClusterVerification.assertUser(user);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkUserExistence(true, nodeList, user);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkUserExistence(String[] nodeList, String user) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " user=" + user));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertUser(user);
        return this.checkUserExistence(false, nodeList, user);
    }

    private VerificationResultSet checkUserExistence(boolean localNode, String[] nodeList, String user) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskUserExistence userTask = new TaskUserExistence(user);
        userTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = userTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(userTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkGroupExistence(String group) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. group=" + group));
        }
        ClusterVerification.assertGroup(group);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkGroupExistence(true, nodeList, group);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkGroupExistence(String[] nodeList, String group) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " group=" + group));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertGroup(group);
        return this.checkGroupExistence(false, nodeList, group);
    }

    private VerificationResultSet checkGroupExistence(boolean localNode, String[] nodeList, String group) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskGroupExistence groupTask = new TaskGroupExistence(group);
        groupTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = groupTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(groupTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkGroupMembership(String user, String group, boolean primary) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. user=" + user + " group=" + group + " primary=" + primary));
        }
        ClusterVerification.assertUser(user);
        ClusterVerification.assertGroup(group);
        ClusterVerification.assertPrimaryGroup(primary);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkGroupMembership(true, nodeList, user, group, primary);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkGroupMembership(String[] nodeList, String user, String group, boolean primary) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " user=" + user + " group=" + group + " primary=" + primary));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertUser(user);
        ClusterVerification.assertGroup(group);
        ClusterVerification.assertPrimaryGroup(primary);
        return this.checkGroupMembership(false, nodeList, user, group, primary);
    }

    private VerificationResultSet checkGroupMembership(boolean localNode, String[] nodeList, String user, String group, boolean primary) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskGroupMembership grpMemTask = new TaskGroupMembership(user, group, primary);
        grpMemTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = grpMemTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(grpMemTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResultSet checkTZConsistency(String[] nodeList, int tasktype) throws VerificationException {
        VerificationResultSet resultSet;
        ClusterVerification.assertNodes(nodeList);
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(false, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskTimeZoneSetting tz = new TaskTimeZoneSetting(nodeList);
        tz.setTaskType(tasktype);
        try {
            resultSet = tz.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(tz.getResultSet());
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(tz, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkKernelVersion(String ver) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. ver=" + ver));
        }
        ClusterVerification.assertVersion(ver);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkKernelVersion(true, nodeList, ver);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkKernelVersion(String[] nodeList, String ver) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " ver=" + ver));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertVersion(ver);
        return this.checkKernelVersion(false, nodeList, ver);
    }

    private VerificationResultSet checkKernelVersion(boolean localNode, String[] nodeList, String ver) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskKernelVersion verTask = new TaskKernelVersion(ver);
        verTask.setNodeList(nodeList);
        try {
            resultSet = verTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(verTask.getResultSet());
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(verTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkKernelParam(String name, String val) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. name=" + name + " val" + val));
        }
        ClusterVerification.assertName(name);
        ClusterVerification.assertVal(val);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkKernelParam(true, nodeList, name, val);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkKernelParam(String[] nodeList, String name, String val) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " name=" + name + " val=" + val));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertName(name);
        ClusterVerification.assertVal(val);
        return this.checkKernelParam(false, nodeList, name, val);
    }

    private VerificationResultSet checkKernelParam(boolean localNode, String[] nodeList, String name, String val) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskKernelParam kparamTask = new TaskKernelParam(name, val);
        kparamTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = kparamTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(kparamTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkShellLimit(ShellType st, ShellResourceType resourceType, ShellLimitType limitType, long limit) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. st=" + (Object)((Object)st) + " resourceType=" + (Object)((Object)resourceType) + " limitType=" + (Object)((Object)limitType) + " limit=" + limit));
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkShellLimit(true, nodeList, st, resourceType, limitType, limit);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkShellLimit(String[] nodeList, ShellType st, ShellResourceType resourceType, ShellLimitType limitType, long limit) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " st=" + (Object)((Object)st) + " resourceType=" + (Object)((Object)resourceType) + " limitType=" + (Object)((Object)limitType) + " limit=" + limit));
        }
        ClusterVerification.assertNodes(nodeList);
        return this.checkShellLimit(false, nodeList, st, resourceType, limitType, limit);
    }

    private VerificationResultSet checkShellLimit(boolean localNode, String[] nodeList, ShellType st, ShellResourceType resourceType, ShellLimitType limitType, long limit) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskShellLimits task = new TaskShellLimits(st, resourceType, limitType, limit);
        task.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = task.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(task, resultSet);
        }
        return resultSet;
    }

    public void setVariableValue(String varName, String varValue) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. varName=" + varName + " varValue=" + varValue));
        }
        ClusterVerification.assertName(varName);
        ClusterVerification.assertVal(varValue);
        VerificationUtil.setVariableValue(varName, varValue);
    }

    public void clearVariableValue(String varName) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. varName=" + varName));
        }
        ClusterVerification.assertName(varName);
        VerificationUtil.clearVariableValue(varName);
    }

    public void setConditionValue(String condition, boolean value) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. condition=" + condition));
        }
        ClusterVerification.assertName(condition);
        VerificationUtil.setConditionValue(condition, value);
    }

    public void clearConditionValue(String condition) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. condition=" + condition));
        }
        ClusterVerification.assertName(condition);
        VerificationUtil.clearConditionValue(condition);
    }

    public VerificationResult checkCRSIntegrity() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkCRSIntegrity(true, nodeList);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkCRSIntegrity(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        ClusterVerification.assertNodes(nodeList);
        return this.checkCRSIntegrity(false, nodeList);
    }

    private VerificationResultSet checkCRSIntegrity(boolean localNode, String[] nodeList) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskCRSIntegrity taskCRSI = new TaskCRSIntegrity(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = taskCRSI.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskCRSI, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkUserEquiv() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkUserEquiv(true, nodeList, null);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkUserEquiv(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        ClusterVerification.assertNodes(nodeList);
        return this.checkUserEquiv(false, nodeList, null);
    }

    public VerificationResult checkUserEquiv(EnumSet<UserEquivCheckType> checkType) throws VerificationException, UnsupportedOperationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. checkType=" + checkType));
        }
        ClusterVerification.assertCheckType(checkType);
        ClusterVerification.assertUnixPlatform();
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkUserEquiv(true, nodeList, checkType);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkUserEquiv(String[] nodeList, EnumSet<UserEquivCheckType> checkType) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " checkType=" + checkType));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertCheckType(checkType);
        ClusterVerification.assertUnixPlatform();
        return this.checkUserEquiv(false, nodeList, checkType);
    }

    private VerificationResultSet checkUserEquiv(boolean localNode, String[] nodeList, EnumSet<UserEquivCheckType> checkType) throws VerificationException {
        VerificationResultSet resultSet;
        TaskAdminPrivileges taskAP = new TaskAdminPrivileges(nodeList, "user_equiv");
        if (checkType != null) {
            taskAP.setUserEquivCheckTypeSet(checkType);
        }
        try {
            resultSet = taskAP.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskAP, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkAdminPrivCRSInst() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkAdminPrivCRSInst(true, nodeList, null);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkAdminPrivCRSInst(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        ClusterVerification.assertNodes(nodeList);
        return this.checkAdminPrivCRSInst(false, nodeList, null);
    }

    public VerificationResult checkAdminPrivCRSInst(String oraInvGroup) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. oraInvGroup=" + oraInvGroup));
        }
        ClusterVerification.assertGroup(oraInvGroup);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkAdminPrivCRSInst(true, nodeList, oraInvGroup);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkAdminPrivCRSInst(String[] nodeList, String oraInvGroup) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " oraInvGroup=" + oraInvGroup));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertGroup(oraInvGroup);
        return this.checkAdminPrivCRSInst(false, nodeList, oraInvGroup);
    }

    private VerificationResultSet checkAdminPrivCRSInst(boolean localNode, String[] nodeList, String oraInvGroup) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskAdminPrivileges taskAP = new TaskAdminPrivileges(setupResultSet.getSuccessfulNodes().toArray(new String[0]), "crs_inst");
        if (oraInvGroup != null) {
            taskAP.setOraInv(oraInvGroup);
        }
        try {
            resultSet = taskAP.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskAP, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkAdminPrivDBInst() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkAdminPrivDBInst(true, nodeList, null);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkAdminPrivDBInst(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        ClusterVerification.assertNodes(nodeList);
        return this.checkAdminPrivDBInst(false, nodeList, null);
    }

    public VerificationResult checkAdminPrivDBInst(String osdbaGroup) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. osdbaGroup=" + osdbaGroup));
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkAdminPrivDBInst(true, nodeList, osdbaGroup);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkAdminPrivDBInst(String[] nodeList, String osdbaGroup) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        ClusterVerification.assertNodes(nodeList);
        return this.checkAdminPrivDBInst(false, nodeList, osdbaGroup);
    }

    private VerificationResultSet checkAdminPrivDBInst(boolean localNode, String[] nodeList, String osdbaGroup) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskAdminPrivileges taskAP = new TaskAdminPrivileges(setupResultSet.getSuccessfulNodes().toArray(new String[0]), "db_inst");
        if (osdbaGroup != null) {
            taskAP.setOSDBA(osdbaGroup);
        }
        try {
            resultSet = taskAP.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskAP, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkAdminPrivDBConfig() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkAdminPrivDBConfig(true, nodeList, null);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkAdminPrivDBConfig(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        ClusterVerification.assertNodes(nodeList);
        return this.checkAdminPrivDBConfig(false, nodeList, null);
    }

    public VerificationResult checkAdminPrivDBConfig(String oracleHome) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. oracleHome=" + oracleHome));
        }
        ClusterVerification.assertOracleHomeForCmdExec(oracleHome);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkAdminPrivDBConfig(true, nodeList, oracleHome);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkAdminPrivDBConfig(String[] nodeList, String oracleHome) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " oracleHome=" + oracleHome));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertOracleHomeForCmdExec(oracleHome);
        return this.checkAdminPrivDBConfig(false, nodeList, oracleHome);
    }

    private VerificationResultSet checkAdminPrivDBConfig(boolean localNode, String[] nodeList, String oracleHome) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskAdminPrivileges taskAP = new TaskAdminPrivileges(setupResultSet.getSuccessfulNodes().toArray(new String[0]), "db_config");
        if (oracleHome != null) {
            taskAP.setOracleHome(oracleHome);
        }
        try {
            resultSet = taskAP.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskAP, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkCFSIntegrity(String fileSystem) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. fileSystem=" + fileSystem));
        }
        ClusterVerification.assertPath(fileSystem);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkCFSIntegrity(true, nodeList, fileSystem);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkCFSIntegrity(String[] nodeList, String fileSystem) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " fileSystem=" + fileSystem));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertPath(fileSystem);
        return this.checkCFSIntegrity(false, nodeList, fileSystem);
    }

    private VerificationResultSet checkCFSIntegrity(boolean localNode, String[] nodeList, String fileSystem) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskCFSIntegrity taskCFSI = new TaskCFSIntegrity(setupResultSet.getSuccessfulNodes().toArray(new String[0]), fileSystem);
        try {
            resultSet = taskCFSI.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskCFSI, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkClusterManagerIntegrity() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry.");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkClusterMgrIntegrity(true, nodeList);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkClusterMgrIntegrity(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        ClusterVerification.assertNodes(nodeList);
        return this.checkClusterMgrIntegrity(false, nodeList);
    }

    private VerificationResultSet checkClusterMgrIntegrity(boolean localNode, String[] nodeList) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskClusterMgrIntegrity taskClusterMgrI = new TaskClusterMgrIntegrity(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = taskClusterMgrI.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskClusterMgrI, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkNodeApp() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkNodeApp(true, nodeList);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkNodeApp(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        ClusterVerification.assertNodes(nodeList);
        return this.checkNodeApp(false, nodeList);
    }

    private VerificationResultSet checkNodeApp(boolean localNode, String[] nodeList) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskNodeAppCreation taskNodeApp = new TaskNodeAppCreation(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = taskNodeApp.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskNodeApp, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkClusterIntegrity() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkClusterIntegrity(true, nodeList);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkClusterIntegrity(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        ClusterVerification.assertNodes(nodeList);
        return this.checkClusterIntegrity(false, nodeList);
    }

    private VerificationResultSet checkClusterIntegrity(boolean localNode, String[] nodeList) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskClusterIntegrity taskClusterI = new TaskClusterIntegrity(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = taskClusterI.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskClusterI, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkOCRIntegrity() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkOCRIntegrity(true, nodeList);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkOCRIntegrity(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        ClusterVerification.assertNodes(nodeList);
        return this.checkOCRIntegrity(false, nodeList);
    }

    private VerificationResultSet checkOCRIntegrity(boolean localNode, String[] nodeList) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskOCRIntegrity taskOCRI = new TaskOCRIntegrity(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = taskOCRI.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskOCRI, resultSet);
        }
        return resultSet;
    }

    String getLocalNode() throws VerificationException {
        String localNode;
        try {
            localNode = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            throw new VerificationException(uhe.getMessage());
        }
        return localNode;
    }

    private static String getDefaultFrameworkHome() throws VerificationException {
        String crsHome = null;
        try {
            if (VerificationUtil.isCRSInstalledOnLocalNode()) {
                crsHome = VerificationUtil.getCRSHome();
            }
        }
        catch (UnknownHostException e) {
            throw new VerificationException(e);
        }
        if (crsHome != null) {
            return crsHome;
        }
        String haHome = null;
        if (VerificationUtil.isHAInstalled()) {
            haHome = VerificationUtil.getHAHome();
        }
        if (haHome != null) {
            return haHome;
        }
        throw new VerificationException(s_msgBundle.getMessage("7523", false));
    }

    private static String getDefaultWorkDir() throws VerificationException {
        return System.getProperty("java.io.tmpdir");
    }

    static final void assertNodes(String[] nodeList) throws VerificationException {
        if (nodeList == null || nodeList.length == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7515", false));
        }
    }

    static final void assertNode(String node) throws VerificationException {
        if (node == null || node.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7514", false));
        }
    }

    static final void assertUser(String user) throws VerificationException {
        if (user == null || user.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7569", false));
        }
    }

    static final void assertPrimaryGroup(boolean primary) throws VerificationException {
        if (!new SystemFactory().CreateSystem().isUnixSystem() && primary) {
            throw new VerificationException(s_msgBundle.getMessage("4314", false));
        }
    }

    static final void assertGroup(String group) throws VerificationException {
        if (group == null || group.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7570", false));
        }
    }

    static final void assertProc(String proc) throws VerificationException {
        if (proc == null || proc.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7578", false));
        }
    }

    static final void assertName(String name) throws VerificationException {
        if (name == null || name.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7579", false));
        }
    }

    static final void assertVal(String val) throws VerificationException {
        if (val == null || val.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7580", false));
        }
    }

    static final void assertArch(String arch) throws VerificationException {
        if (arch == null || arch.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7581", false));
        }
    }

    static final void assertArchs(List<String> archs) throws VerificationException {
        if (archs == null || archs.size() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7585", false));
        }
        for (String arch : archs) {
            ClusterVerification.assertArch(arch);
        }
    }

    static final void assertOSPatch(String osPatch) throws VerificationException {
        if (osPatch == null || osPatch.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("9808", false));
        }
    }

    static final void assertVersion(String ver) throws VerificationException {
        if (ver == null || ver.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7582", false));
        }
    }

    static final void assertSize(long size) throws VerificationException {
        if (size < 0L) {
            throw new VerificationException(s_msgBundle.getMessage("7576", false));
        }
    }

    static final void assertSize(double size) throws VerificationException {
        if (size < 0.0) {
            throw new VerificationException(s_msgBundle.getMessage("7576", false));
        }
    }

    static final void assertRunlevels(List<Integer> runlevels) throws VerificationException {
        if (runlevels == null || runlevels.size() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7583", false));
        }
        for (int runLvl : runlevels) {
            ClusterVerification.assertRunlevel(runLvl);
        }
    }

    static final void assertRunlevel(int runlevel) throws VerificationException {
        if (runlevel < 0) {
            throw new VerificationException(s_msgBundle.getMessage("7577", false));
        }
    }

    static final void assertOracleHomeForCmdExec(String oracleHome) throws InvalidPathException {
        if (oracleHome == null || oracleHome.length() == 0) {
            throw new InvalidPathException(s_msgBundle.getMessage("7556", false));
        }
        if (!new File(oracleHome).isAbsolute()) {
            throw new InvalidPathException(s_msgBundle.getMessage("7557", false, (Object[])new String[]{oracleHome}));
        }
    }

    static final void assertOracleHome(String oracleHome, boolean checkExistence) throws VerificationException {
        if (oracleHome == null || oracleHome.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7556", false));
        }
        if (!new File(oracleHome).isAbsolute()) {
            throw new VerificationException(s_msgBundle.getMessage("7557", false, (Object[])new String[]{oracleHome}));
        }
        if (checkExistence) {
            ClusterCmd clusterCmd = new ClusterCmd();
            try {
                clusterCmd.pathExists(new String[]{"localnode"}, oracleHome, 1);
            }
            catch (ClusterException ce) {
                throw new VerificationException(s_msgBundle.getMessage("7509", false, (Object[])new String[]{oracleHome}), ce);
            }
            catch (ClusterOperationException ce) {
                throw new VerificationException(ce);
            }
            try {
                if (!clusterCmd.isDirWritable(new String[]{"localnode"}, oracleHome)) {
                    throw new VerificationException(s_msgBundle.getMessage("0020", true, (Object[])new String[]{oracleHome}));
                }
            }
            catch (ClusterException ce) {
                throw new VerificationException(s_msgBundle.getMessage("0020", true, (Object[])new String[]{oracleHome}), ce);
            }
            catch (ClusterOperationException ce) {
                throw new VerificationException(ce);
            }
        }
    }

    static final void assertPath(String path) throws InvalidPathException {
        if (path == null || path.length() == 0) {
            throw new InvalidPathException(s_msgBundle.getMessage("7517", false));
        }
        if (!new File(path).isAbsolute()) {
            throw new InvalidPathException(s_msgBundle.getMessage("7518", false, (Object[])new String[]{path}));
        }
    }

    static final void assertCheckType(EnumSet<UserEquivCheckType> checkType) throws VerificationException {
        if (checkType == null || checkType.size() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7601", false));
        }
    }

    static final void assertUnixPlatform() throws UnsupportedOperationException {
        if (!new SystemFactory().CreateSystem().isUnixSystem()) {
            throw new UnsupportedOperationException(s_msgBundle.getMessage("7602", false));
        }
    }

    static final void assertStorageUnit(StorageUnit unit) throws VerificationException {
        if (unit == null) {
            throw new VerificationException(s_msgBundle.getMessage("7586", false));
        }
    }

    public VerificationResultSet checkFrameworkSetup() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        VerificationUtil.setLocalNodeOperation(true);
        return this.checkFrameworkSetup(true, new String[]{localNode});
    }

    public VerificationResultSet checkFrameworkSetup(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        ClusterVerification.assertNodes(nodeList);
        return this.checkFrameworkSetup(false, nodeList);
    }

    private VerificationResultSet checkFrameworkSetup(boolean localNode, String[] nodeList) throws VerificationException {
        VerificationUtil.setLocalNodeOperation(localNode);
        return this.verifyFrameworkSetup(nodeList);
    }

    public void setFixupRootDir(String fixupRootDir) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. fixupRootDir=" + fixupRootDir));
        }
        VerificationUtil.assertWritableOrCreatableDir(fixupRootDir);
        VerificationUtil.setFixupRootDir(fixupRootDir);
    }

    public void cleanupFixupRootDir() {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        VerificationUtil.markFixupRootDirAsSettled(null);
        VerificationUtil.setFixupGenerated(false);
        String fixupRootDir = VerificationUtil.getFixupRootDir();
        boolean dirCleaned = false;
        String errMsg = s_msgBundle.getMessage("7555", false, (Object[])new String[]{fixupRootDir});
        try {
            dirCleaned = new ClusterCmd().removeDirectory(new String[]{VerificationUtil.getLocalHost()}, fixupRootDir, true);
        }
        catch (UnknownHostException uhe) {
            errMsg = errMsg + VerificationConstants.LSEP + uhe.getMessage();
        }
        catch (ClusterException ce) {
            errMsg = errMsg + VerificationConstants.LSEP + ce.getMessage();
        }
        if (Trace.isLevelEnabled((int)1)) {
            if (!dirCleaned) {
                Trace.out((String)("Fixup root directory could not be cleaned" + VerificationConstants.LSEP + errMsg));
            } else {
                Trace.out((String)("The contents of directory '" + fixupRootDir + "' were successfully deleted"));
            }
        }
    }

    public void setDefaultFixupRequirement(boolean fixupReqd) {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. fixupReqd=" + fixupReqd));
        }
        VerificationUtil.setDefaultFixupRequirement(fixupReqd);
    }

    public FixupGeneratorResult getFixupGeneratorResult() throws NoFixupGeneratorResultException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        return VerificationUtil.getFixupGeneratorResult();
    }

    public FixupResultSet executeFixups(String fixupRootDir, PrivilegedUserInfo usrInfo) throws VerificationException {
        return new FixupResultSetImpl(new String[]{"node1", "node2"});
    }

    public FixupResultSet executeFixups(PrivilegedUserInfo usrInfo) throws VerificationException {
        return new FixupResultSetImpl(new String[]{"node1", "node2"});
    }

    private void rebootNode(String node, PrivilegedUserInfo usrInfo) throws VerificationException {
    }

    private VerificationResultSet verifyFrameworkSetup(String[] nodeList) throws VerificationException {
        ResultSet resultSet = new ResultSet();
        Vector<String> succNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        String[] equivNodes = VerificationUtil.isLocalNodeOperation() ? nodeList : VerificationUtil.getUserEquivalentNodes(nodeList, resultSet);
        if (equivNodes != null) {
            VerificationUtil.checkDestLoc(equivNodes, resultSet, succNodes, failNodes, true);
        }
        return resultSet;
    }

    public boolean checkPlatformArchitecture() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        try {
            return VerificationUtil.checkPlatform();
        }
        catch (Exception e) {
            throw new VerificationException(e);
        }
    }

    public boolean checkPlatformArchitecture(String osname, String osarch) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. osname=" + osname + " osarch=" + osarch));
        }
        ClusterVerification.assertName(osname);
        ClusterVerification.assertArch(osarch);
        try {
            return VerificationUtil.checkPlatform(osname, osarch);
        }
        catch (Exception e) {
            throw new VerificationException(e);
        }
    }

    public boolean checkPlatformOS() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        try {
            return VerificationUtil.checkPlatformOS();
        }
        catch (Exception e) {
            throw new VerificationException(e);
        }
    }

    public boolean checkPlatformOS(String osname) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. osname=" + osname));
        }
        ClusterVerification.assertName(osname);
        try {
            return VerificationUtil.checkPlatformOS(osname);
        }
        catch (Exception e) {
            throw new VerificationException(e);
        }
    }

    public VerificationResult checkOSPatch(String osPatch) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. osPatch=" + osPatch));
        }
        ClusterVerification.assertOSPatch(osPatch);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkOSPatch(true, nodeList, osPatch);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkOSPatch(String[] nodeList, String osPatch) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " osPatch=" + osPatch));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertOSPatch(osPatch);
        return this.checkOSPatch(false, nodeList, osPatch);
    }

    private VerificationResultSet checkOSPatch(boolean localNode, String[] nodeList, String osPatch) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskOSPatch osPatchTask = new TaskOSPatch(osPatch);
        osPatchTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = osPatchTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(osPatchTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkOracleBinary(String oracleHome) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. oracleHome=" + oracleHome));
        }
        ClusterVerification.assertOracleHome(oracleHome, true);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkOracleBinary(true, nodeList, oracleHome);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkOracleBinary(String[] nodeList, String oracleHome) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " oracleHome=" + oracleHome));
        }
        ClusterVerification.assertNodes(nodeList);
        ClusterVerification.assertOracleHome(oracleHome, true);
        return this.checkOracleBinary(false, nodeList, oracleHome);
    }

    private VerificationResultSet checkOracleBinary(boolean localNode, String[] nodeList, String oracleHome) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskBinaryMatching binaryMatchTask = new TaskBinaryMatching(setupResultSet.getSuccessfulNodes().toArray(new String[0]), oracleHome);
        try {
            resultSet = binaryMatchTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(binaryMatchTask, resultSet);
        }
        return resultSet;
    }

    public void setPreReqXmlFile(PreReqType prereqType, String xmlFile) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. prereqType=" + (Object)((Object)prereqType) + " xmlFile=" + xmlFile));
        }
        ClusterVerification.assertPath(xmlFile);
        VerificationUtil.setPreReqXmlFile(prereqType.getVerificationType(), xmlFile);
    }

    public void setPreReqXmlFile(String xmlFile) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. xmlFile=" + xmlFile));
        }
        ClusterVerification.assertPath(xmlFile);
        VerificationUtil.setPreReqXmlFile(xmlFile);
    }

    public boolean isPreReqSupported() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        return VerificationUtil.isPreReqSupported();
    }

    public boolean isPreReqSupported(PreReqType prereqType) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. prereqType=" + (Object)((Object)prereqType)));
        }
        return VerificationUtil.isPreReqSupported(prereqType.getVerificationType());
    }

    static final void assertWorkDir(String workDir) throws VerificationException {
        if (workDir == null || workDir.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7519", false));
        }
        if (!new File(workDir).isAbsolute()) {
            throw new VerificationException(s_msgBundle.getMessage("7520", false, (Object[])new String[]{workDir}));
        }
    }

    static final void assertFrameworkHome(String frameworkHome) throws VerificationException {
        if (frameworkHome == null || frameworkHome.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("7521", false));
        }
        if (!new File(frameworkHome).isAbsolute()) {
            throw new VerificationException(s_msgBundle.getMessage("7522", false, (Object[])new String[]{frameworkHome}));
        }
    }

    static final void assertInterface(String interfaceName) throws VerificationException {
        if (interfaceName == null || interfaceName.length() == 0) {
            throw new VerificationException(s_msgBundle.getMessage("6010", false));
        }
    }

    private void assertParamPreReq(ParamPreReq param) throws VerificationException {
        if (param == null) {
            throw new VerificationException(s_msgBundle.getMessage("7516", false));
        }
    }

    private void traceTaskResultSet(Task task, VerificationResultSet resultSet) {
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("Element Name ===>" + task.getElementName()));
            Trace.out((String)("Description of task ===>" + task.getDescription()));
            Trace.out((String)("status==>" + (Object)((Object)resultSet.getOverallStatus())));
            Trace.out((String)("hasNodeValues==>" + resultSet.hasNodeResults()));
        }
    }

    static {
        s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PathType {
        WORK_DIR,
        FRAMEWORK_HOME;

    }
}

