/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification;

import oracle.cluster.verification.StorageUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageSize
implements Comparable<StorageSize> {
    private double m_size;
    private StorageUnit m_units;

    public StorageSize(double size, StorageUnit units) {
        this.m_size = size;
        if (units == null) {
            units = StorageUnit.BYTE;
        }
        this.m_units = units;
    }

    @Override
    public int compareTo(StorageSize o) {
        if (o == null) {
            return 1;
        }
        StorageUnit greaterOfThe2 = this.getGreaterStorageUnits(this.m_units, o.m_units);
        return new Double(this.sizeIn(greaterOfThe2)).compareTo(new Double(o.sizeIn(greaterOfThe2)));
    }

    private StorageUnit getGreaterStorageUnits(StorageUnit unit1, StorageUnit unit2) {
        return unit1.getConversionFactor() >= unit2.getConversionFactor() ? unit1 : unit2;
    }

    public double sizeIn(StorageUnit units) {
        if (units == null) {
            return this.m_size;
        }
        return this.m_size * ((double)this.m_units.getConversionFactor() / (double)units.getConversionFactor());
    }

    public void add(StorageSize size) {
        if (size == null) {
            return;
        }
        StorageUnit units = this.getGreaterStorageUnits(this.m_units, size.m_units);
        this.m_size = this.sizeIn(units) + size.sizeIn(units);
        this.m_units = units;
    }

    public void subtract(StorageSize size) {
        if (size == null) {
            return;
        }
        StorageUnit units = this.getGreaterStorageUnits(this.m_units, size.m_units);
        this.m_size = this.sizeIn(units) - size.sizeIn(units);
        this.m_units = units;
    }

    public String toString() {
        return this.m_size + " " + (Object)((Object)this.m_units);
    }
}

