/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.constraints;

import java.util.HashMap;
import java.util.Vector;
import oracle.cluster.verification.constraints.CDMConstraintTypes;
import oracle.ops.mgmt.trace.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDMMemoryConstraints {
    private HashMap<String, String> m_phyMemory = null;
    private HashMap<String, String> m_availMemory = null;
    private HashMap<String, String> m_swapMemory = null;
    private Vector<HashMap<String, String>> m_swapMemorySteps = null;

    public void addPhysicalMemory(String value, String units, String severity) {
        Trace.out((String)("value = " + value + ", units = " + units));
        if (this.m_phyMemory == null) {
            this.m_phyMemory = new HashMap();
        }
        this.m_phyMemory.put(CDMConstraintTypes.VALUE, value);
        this.m_phyMemory.put(CDMConstraintTypes.UNIT, units);
        this.m_phyMemory.put(CDMConstraintTypes.SEVERITY, severity);
    }

    public void addAvailableMemory(String value, String units, String severity) {
        Trace.out((String)("value = " + value + ", units = " + units));
        if (this.m_availMemory == null) {
            this.m_availMemory = new HashMap();
        }
        this.m_availMemory.put(CDMConstraintTypes.VALUE, value);
        this.m_availMemory.put(CDMConstraintTypes.UNIT, units);
        this.m_availMemory.put(CDMConstraintTypes.SEVERITY, severity);
    }

    public void addSwapMemory(String value, String units, String severity) {
        Trace.out((String)("value = " + value + ", units = " + units));
        if (this.m_swapMemory == null) {
            this.m_swapMemory = new HashMap();
        }
        this.m_swapMemory.put(CDMConstraintTypes.VALUE, value);
        this.m_swapMemory.put(CDMConstraintTypes.UNIT, units);
        this.m_swapMemory.put(CDMConstraintTypes.SEVERITY, severity);
    }

    public void addSwapSizeStep(String name, String value, String gthan, String atLeast, String lthan, String atMost, String units, String multiple, String severity, String minValue, String minUnit, String maxValue, String maxUnit) {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("name = " + name + ", value = " + value + ", gthan= " + gthan + "atLeast = " + atLeast + ", atMost = " + atMost + "units = " + units + ", multiple = " + multiple + " minValue=" + minValue + " minUnit=" + minUnit + " maxValue=" + maxValue + " maxUnit=" + maxUnit));
        }
        if (this.m_swapMemorySteps == null) {
            this.m_swapMemorySteps = new Vector();
        }
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(CDMConstraintTypes.NAME, name);
        p.put(CDMConstraintTypes.VALUE, value);
        p.put(CDMConstraintTypes.GREATER_THAN, gthan);
        p.put(CDMConstraintTypes.ATLEAST, atLeast);
        p.put(CDMConstraintTypes.LESS_THAN, lthan);
        p.put(CDMConstraintTypes.ATMOST, atMost);
        p.put(CDMConstraintTypes.UNIT, units);
        p.put(CDMConstraintTypes.MULTIPLE, multiple);
        p.put(CDMConstraintTypes.SEVERITY, severity);
        p.put(CDMConstraintTypes.MIN_VALUE, minValue);
        p.put(CDMConstraintTypes.MIN_UNIT, minUnit);
        p.put(CDMConstraintTypes.MAX_VALUE, maxValue);
        p.put(CDMConstraintTypes.MAX_UNIT, maxUnit);
        this.m_swapMemorySteps.add(p);
    }

    public HashMap<String, String> getPhyMemory() {
        return this.m_phyMemory;
    }

    public HashMap<String, String> getAvailMemory() {
        return this.m_availMemory;
    }

    public HashMap<String, String> getSwapMemory() {
        return this.m_swapMemory;
    }

    public Vector<HashMap<String, String>> getSwapMemorySteps() {
        return this.m_swapMemorySteps;
    }
}

