/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.constraints;

import java.util.HashMap;
import java.util.Vector;
import oracle.cluster.verification.constraints.CDMConstraintTypes;
import oracle.ops.mgmt.trace.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDMOracleHome {
    private Vector<HashMap> m_oracleHomes;
    private Vector<HashMap> m_allowedComponents;
    private Vector<HashMap> m_disAllowedComponents;
    private Vector<HashMap> m_existenceMatrix;

    public void addOracleHome(String loc, String name) {
        if (this.m_oracleHomes == null) {
            this.m_oracleHomes = new Vector();
        }
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(CDMConstraintTypes.LOCS, loc);
        p.put(CDMConstraintTypes.NAME, name);
        this.m_oracleHomes.add(p);
    }

    public void addToAllowedComponents(String name, String atLeast, String atMost) {
        Trace.out((String)("name = " + name + ", atLeast = " + atLeast + "atMost = " + atMost));
        if (this.m_allowedComponents == null) {
            this.m_allowedComponents = new Vector();
        }
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(CDMConstraintTypes.NAME, name);
        p.put(CDMConstraintTypes.ATLEAST, atLeast);
        p.put(CDMConstraintTypes.ATMOST, atMost);
        this.m_allowedComponents.add(p);
    }

    public void addToDisallowedComponents(String name, String atLeast, String atMost) {
        Trace.out((String)("name = " + name + ", atLeast = " + atLeast + ", atMost = " + atMost));
        if (this.m_disAllowedComponents == null) {
            this.m_disAllowedComponents = new Vector();
        }
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(CDMConstraintTypes.NAME, name);
        p.put(CDMConstraintTypes.ATLEAST, atLeast);
        p.put(CDMConstraintTypes.ATMOST, atMost);
        this.m_disAllowedComponents.add(p);
    }

    public void addToExistenceMatrix(String name, String desc, String exists, String atLeast, String atMost) {
        Trace.out((String)("name = " + name + ", desc = " + desc + ", exists = " + exists + ", atLeast = " + atLeast + ", atMost = " + atMost));
        if (this.m_existenceMatrix == null) {
            this.m_existenceMatrix = new Vector();
        }
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(CDMConstraintTypes.NAME, name);
        p.put(CDMConstraintTypes.DESC, desc);
        p.put(CDMConstraintTypes.EXISTS, exists);
        p.put(CDMConstraintTypes.ATLEAST, atLeast);
        p.put(CDMConstraintTypes.ATMOST, atMost);
        this.m_existenceMatrix.add(p);
    }

    public Vector<HashMap> getOracleHomes() {
        return this.m_oracleHomes;
    }

    public Vector<HashMap> getAllowedComponents() {
        return this.m_allowedComponents;
    }

    public Vector<HashMap> getDisAllowedComponents() {
        return this.m_disAllowedComponents;
    }

    public Vector<HashMap> getExistenceMatrix() {
        return this.m_existenceMatrix;
    }
}

