/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.constraints;

import java.util.HashMap;
import java.util.Vector;
import oracle.cluster.verification.constraints.CDMConstraintTypes;
import oracle.ops.mgmt.trace.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDMShellLimitChecks {
    private Vector<HashMap<String, String>> m_fdLimits = new Vector();
    private Vector<HashMap<String, String>> m_mpLimits = new Vector();

    public void addFileDescriptorLimit(String shellVar, String shellSel, String limitType, String limit, String severity) {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("shellVar = " + shellVar + ", shellSel = " + shellSel + ", limitType = " + limitType + ", limit = " + limit));
        }
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(CDMConstraintTypes.VAR, shellVar);
        p.put(CDMConstraintTypes.SELECTION, shellSel);
        p.put(CDMConstraintTypes.LIMIT_TYPE, limitType);
        p.put(CDMConstraintTypes.LIMIT, limit);
        p.put(CDMConstraintTypes.SEVERITY, severity);
        this.m_fdLimits.add(p);
    }

    public void addMaxProcessLimits(String shellVar, String shellSel, String limitType, String limit, String severity) {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"shellVar=%s, shellSel=%s, limitType=%s, limit=%s ", (Object[])new Object[]{shellVar, shellSel, limitType, limit});
        }
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(CDMConstraintTypes.VAR, shellVar);
        p.put(CDMConstraintTypes.SELECTION, shellSel);
        p.put(CDMConstraintTypes.LIMIT_TYPE, limitType);
        p.put(CDMConstraintTypes.LIMIT, limit);
        p.put(CDMConstraintTypes.SEVERITY, severity);
        this.m_mpLimits.add(p);
    }

    public Vector<HashMap<String, String>> getFileDescriptorLimits() {
        return this.m_fdLimits;
    }

    public Vector<HashMap<String, String>> getMaxProcessLimits() {
        return this.m_mpLimits;
    }
}

