/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.constraints;

import java.util.HashMap;
import java.util.Vector;
import oracle.cluster.verification.constraints.CDMConstraintTypes;
import oracle.ops.mgmt.trace.Trace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDMUserGroups {
    private Vector<HashMap<String, String>> m_userGroups = new Vector();
    private Vector<HashMap<String, String>> m_userConstraints = new Vector();
    private Vector<HashMap<String, String>> m_groupConstraints = new Vector();
    private Vector<String> m_userList = new Vector();
    private Vector<String> m_groupList = new Vector();
    private Vector<String> m_userGroupList = new Vector();

    public void addUserConstraint(String value, String severity) {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("value = " + value + ", severity = " + severity));
        }
        if (this.m_userList.contains(value)) {
            return;
        }
        this.m_userList.add(value);
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(CDMConstraintTypes.USER_VALUE, value);
        p.put(CDMConstraintTypes.SEVERITY, severity);
        this.m_userConstraints.add(p);
    }

    public void addGroupConstraint(String value, String active, String severity) {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("value = " + value + ", severity = " + severity));
        }
        if (this.m_groupList.contains(value)) {
            return;
        }
        this.m_groupList.add(value);
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(CDMConstraintTypes.GROUP_VALUE, value);
        p.put(CDMConstraintTypes.ACTIVE, active);
        p.put(CDMConstraintTypes.SEVERITY, severity);
        this.m_groupConstraints.add(p);
    }

    public void addUserGroupMembership(String user, String group, String active, String severity) {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("user = " + user + ", groupVal = " + group + ", active = " + active + ", severity = " + severity));
        }
        if (this.m_userGroupList.contains(user + "|" + group)) {
            return;
        }
        this.m_userGroupList.add(user + "|" + group);
        HashMap<String, String> p = new HashMap<String, String>();
        p.put(CDMConstraintTypes.USER_VALUE, user);
        p.put(CDMConstraintTypes.GROUP_VALUE, group);
        p.put(CDMConstraintTypes.ACTIVE, active);
        p.put(CDMConstraintTypes.SEVERITY, severity);
        this.m_userGroups.add(p);
    }

    public Vector<HashMap<String, String>> getUserGroups() {
        return this.m_userGroups;
    }

    public Vector<HashMap<String, String>> getUserConstraints() {
        return this.m_userConstraints;
    }

    public Vector<HashMap<String, String>> getGroupConstraints() {
        return this.m_groupConstraints;
    }
}

