/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.constraints;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.ShellLimitType;
import oracle.cluster.verification.ShellResourceType;
import oracle.cluster.verification.ShellType;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.constraints.CDMCertifiedSystems;
import oracle.cluster.verification.constraints.CDMConstraintTypes;
import oracle.cluster.verification.constraints.CDMHost;
import oracle.cluster.verification.constraints.CDMMemoryConstraints;
import oracle.cluster.verification.constraints.CDMOperatingSystem;
import oracle.cluster.verification.constraints.CDMProcessChecks;
import oracle.cluster.verification.constraints.CDMShellLimitChecks;
import oracle.cluster.verification.constraints.CDMSpaceConstraints;
import oracle.cluster.verification.constraints.CDMSystem;
import oracle.cluster.verification.constraints.CDMUserGroups;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.cluster.verification.constraints.parser.XmlParser;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskArchitecture;
import oracle.ops.verification.framework.engine.task.TaskAvailableMemory;
import oracle.ops.verification.framework.engine.task.TaskCheckEnvVariable;
import oracle.ops.verification.framework.engine.task.TaskContainerFreeSpace;
import oracle.ops.verification.framework.engine.task.TaskContainerKernelParams;
import oracle.ops.verification.framework.engine.task.TaskContainerPackages;
import oracle.ops.verification.framework.engine.task.TaskGroupExistence;
import oracle.ops.verification.framework.engine.task.TaskGroupMembership;
import oracle.ops.verification.framework.engine.task.TaskKernelParam;
import oracle.ops.verification.framework.engine.task.TaskKernelVersion;
import oracle.ops.verification.framework.engine.task.TaskOSPatch;
import oracle.ops.verification.framework.engine.task.TaskPackage;
import oracle.ops.verification.framework.engine.task.TaskPhysicalMemory;
import oracle.ops.verification.framework.engine.task.TaskProcessAlive;
import oracle.ops.verification.framework.engine.task.TaskRunLevel;
import oracle.ops.verification.framework.engine.task.TaskShellLimits;
import oracle.ops.verification.framework.engine.task.TaskSwapSize;
import oracle.ops.verification.framework.engine.task.TaskUserExistence;
import oracle.ops.verification.framework.util.InvalidRangeManipulationException;
import oracle.ops.verification.framework.util.InvalidStepException;
import oracle.ops.verification.framework.util.RangeOfValue;
import oracle.ops.verification.framework.util.RangeOperator;
import oracle.ops.verification.framework.util.RangeType;
import oracle.ops.verification.framework.util.VerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlTaskFactory {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static XmlTaskFactory m_xmlFactory = null;
    private XmlParser m_xmlParser;
    private File m_xmlFile;
    private String[] m_xmlNodeList;

    public static XmlTaskFactory getInstance() {
        if (m_xmlFactory == null) {
            m_xmlFactory = new XmlTaskFactory();
        }
        return m_xmlFactory;
    }

    private XmlTaskFactory() {
    }

    public Task[] getTasks(String filePath, String systemId, String[] nodeList) throws XmlParserException, PreReqNotSupportedException {
        TaskOSPatch[] tosp;
        TaskCheckEnvVariable[] tcEnv;
        TaskContainerPackages tcp;
        TaskContainerKernelParams tckp;
        TaskKernelVersion tkv;
        TaskContainerFreeSpace tcfs;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("XmlTaskFactory.getTasks:  File Path = " + filePath + " , System ID = " + systemId + " Node List: " + VerificationUtil.strArr2List(nodeList)));
        }
        this.m_xmlNodeList = nodeList;
        this.m_xmlFile = new File(filePath);
        this.m_xmlParser = new XmlParser(this.m_xmlFile);
        this.m_xmlParser.parse();
        CDMHost cdmHost = this.m_xmlParser.getCDMData();
        if (cdmHost == null) {
            Trace.out((String)"ERROR: Invalid root element");
            String msg = s_msgBundle.getMessage("1108", false);
            throw new XmlParserException(msg);
        }
        Vector<CDMCertifiedSystems> csList = cdmHost.getCDMCertifiedSystems();
        if (csList.size() != 1) {
            Object[] msgParams = new String[]{Integer.toString(csList.size())};
            String msg = s_msgBundle.getMessage("1099", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        CDMCertifiedSystems cs = csList.elementAt(0);
        Vector<CDMSystem> cdmSystems = cdmHost.getCDMSystems();
        if (cdmSystems.size() != 1) {
            Object[] msgParams = new String[]{Integer.toString(csList.size())};
            String msg = s_msgBundle.getMessage("1100", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        CDMSystem cdmSystem = cdmSystems.elementAt(0);
        Vector<Task> tasksList = new Vector<Task>();
        Vector<CDMMemoryConstraints> cdmMCList = cdmSystem.getCDMMemoryConstraints();
        if (cdmMCList.size() > 1) {
            Object[] msgParams = new String[]{Integer.toString(cdmMCList.size())};
            String msg = s_msgBundle.getMessage("1101", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        if (cdmMCList.size() == 1) {
            TaskSwapSize tss;
            TaskAvailableMemory tam;
            CDMMemoryConstraints cdmMC = cdmMCList.elementAt(0);
            TaskPhysicalMemory tpm = this.createTaskPhysicalMemory(cdmMC);
            if (tpm != null) {
                tasksList.add(tpm);
            }
            if ((tam = this.createTaskAvailableMemory(cdmMC)) != null) {
                tasksList.add(tam);
            }
            if ((tss = this.createTaskSwapSize(cdmMC)) != null) {
                tasksList.add(tss);
            }
        }
        if ((tcfs = this.createTaskContainerFreeSpace(cdmSystem)) != null) {
            tasksList.add(tcfs);
        }
        Vector<CDMUserGroups> cdmUG = cdmSystem.getCDMUserGroups();
        for (int ugIndex = 0; ugIndex < cdmUG.size(); ++ugIndex) {
            List<TaskUserExistence> tueList = this.createTaskUserExistence(cdmUG.elementAt(ugIndex));
            List<Task> tgeList = this.createTaskGroupExistence(cdmUG.elementAt(ugIndex));
            List<Task> tgmList = this.createTaskGroupMembership(cdmUG.elementAt(ugIndex));
            tasksList.addAll(tueList);
            tasksList.addAll(tgeList);
            tasksList.addAll(tgmList);
        }
        TaskRunLevel trl = this.createTaskRunLevel(cdmSystem);
        if (trl != null) {
            tasksList.add(trl);
        }
        Vector<CDMShellLimitChecks> cdmSlc = cdmSystem.getCDMShellLimitChecks();
        for (int slcIndex = 0; slcIndex < cdmSlc.size(); ++slcIndex) {
            TaskShellLimits[] tslList = this.createTaskShellLimits(cdmSlc.elementAt(slcIndex));
            tasksList.addAll(Arrays.asList(tslList));
        }
        Vector<CDMProcessChecks> cdmPC = cdmSystem.getCDMProcessChecks();
        for (int pcIndex = 0; pcIndex < cdmPC.size(); ++pcIndex) {
            TaskProcessAlive[] tpaList = this.createTaskProcessAlive(cdmPC.elementAt(pcIndex));
            tasksList.addAll(Arrays.asList(tpaList));
        }
        CDMOperatingSystem cdmOS = cs.getCDMOS(systemId);
        if (cdmOS == null) {
            String msg = s_msgBundle.getMessage("9811", false);
            Trace.out((String)msg);
            Trace.out((String)VerificationUtil.getOperatingSystemName());
            throw new PreReqNotSupportedException(msg);
        }
        TaskArchitecture ta = this.createTaskArchitecture(cdmOS);
        if (ta != null) {
            tasksList.add(ta);
        }
        if ((tkv = this.createTaskKernelVersion(cdmOS)) != null) {
            tasksList.add(tkv);
        }
        if ((tckp = this.createTaskContainerKernelParams(cdmOS)) != null) {
            tasksList.add(tckp);
        }
        if ((tcp = this.createTaskContainerPackages(cdmOS)) != null) {
            tasksList.add(tcp);
        }
        if ((tcEnv = this.createTaskCheckEnvVariable(cdmOS)) != null) {
            tasksList.addAll(Arrays.asList(tcEnv));
        }
        if ((tosp = this.createTaskOSPatches(cdmOS)) != null) {
            tasksList.addAll(Arrays.asList(tosp));
        }
        return tasksList.toArray(new Task[tasksList.size()]);
    }

    private TaskPhysicalMemory createTaskPhysicalMemory(CDMMemoryConstraints cdmMC) throws XmlParserException {
        HashMap<String, String> pmem = cdmMC.getPhyMemory();
        if (pmem == null) {
            return null;
        }
        String value = pmem.get(CDMConstraintTypes.VALUE);
        String units = pmem.get(CDMConstraintTypes.UNIT);
        SeverityType severity = this.getSeverityAttributeValue(pmem.get(CDMConstraintTypes.SEVERITY));
        StorageUnit su = this.getStorageUnits(units);
        try {
            TaskPhysicalMemory tpm = new TaskPhysicalMemory(new StorageSize(Double.parseDouble(value), su));
            tpm.setSeverity(severity);
            return tpm;
        }
        catch (NumberFormatException nfe) {
            Object[] msgParams = new String[]{value, CDMConstraintTypes.VALUE, CDMConstraintTypes.PHYSICAL_MEMORY};
            String msg = s_msgBundle.getMessage("1095", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg, nfe);
        }
    }

    private TaskAvailableMemory createTaskAvailableMemory(CDMMemoryConstraints cdmMC) throws XmlParserException {
        HashMap<String, String> amem = cdmMC.getAvailMemory();
        if (amem == null) {
            return null;
        }
        String value = amem.get(CDMConstraintTypes.VALUE);
        String units = amem.get(CDMConstraintTypes.UNIT);
        StorageUnit su = this.getStorageUnits(units);
        SeverityType severity = this.getSeverityAttributeValue(amem.get(CDMConstraintTypes.SEVERITY));
        try {
            TaskAvailableMemory tam = new TaskAvailableMemory(new StorageSize(Double.parseDouble(value), su));
            tam.setSeverity(severity);
            return tam;
        }
        catch (NumberFormatException nfe) {
            Object[] msgParams = new String[]{value, CDMConstraintTypes.VALUE, CDMConstraintTypes.AVAILABLE_MEMORY};
            String msg = s_msgBundle.getMessage("1095", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg, nfe);
        }
    }

    private TaskSwapSize createTaskSwapSize(CDMMemoryConstraints cdmMC) throws XmlParserException {
        HashMap<String, String> swapMem = cdmMC.getSwapMemory();
        if (swapMem != null) {
            String value = swapMem.get(CDMConstraintTypes.VALUE);
            String units = swapMem.get(CDMConstraintTypes.UNIT);
            String minValue = swapMem.get(CDMConstraintTypes.MIN_VALUE);
            String minUnits = swapMem.get(CDMConstraintTypes.MIN_UNIT);
            String maxValue = swapMem.get(CDMConstraintTypes.MAX_VALUE);
            String maxUnits = swapMem.get(CDMConstraintTypes.MAX_UNIT);
            SeverityType severity = this.getSeverityAttributeValue(swapMem.get(CDMConstraintTypes.SEVERITY));
            StorageUnit su = this.getStorageUnits(units);
            try {
                TaskSwapSize tss = new TaskSwapSize(new StorageSize(Double.parseDouble(value), su));
                tss.setSeverity(severity);
                if (minValue != null) {
                    tss.setMinSwapSize(new StorageSize(Double.parseDouble(minValue), this.getStorageUnits(minUnits)));
                }
                if (maxValue != null) {
                    tss.setMaxSwapSize(new StorageSize(Double.parseDouble(maxValue), this.getStorageUnits(maxUnits)));
                }
                return tss;
            }
            catch (NumberFormatException nfe) {
                Object[] msgParams = new String[]{value, CDMConstraintTypes.VALUE, CDMConstraintTypes.SWAP_SIZE};
                String msg = s_msgBundle.getMessage("1095", false, msgParams);
                Trace.out((String)msg);
                throw new XmlParserException(msg, nfe);
            }
        }
        Vector<HashMap<String, String>> swapElems = cdmMC.getSwapMemorySteps();
        if (swapElems == null) {
            return null;
        }
        TaskSwapSize tss = null;
        for (int i = 0; i < swapElems.size(); ++i) {
            HashMap<String, String> swapElem = swapElems.elementAt(i);
            if (tss == null) {
                tss = new TaskSwapSize(swapElem.get(CDMConstraintTypes.NAME));
                SeverityType severity = this.getSeverityAttributeValue(swapElem.get(CDMConstraintTypes.SEVERITY));
                tss.setSeverity(severity);
                String minValue = swapElem.get(CDMConstraintTypes.MIN_VALUE);
                String minUnits = swapElem.get(CDMConstraintTypes.MIN_UNIT);
                String maxValue = swapElem.get(CDMConstraintTypes.MAX_VALUE);
                String maxUnits = swapElem.get(CDMConstraintTypes.MAX_UNIT);
                if (minValue != null) {
                    tss.setMinSwapSize(new StorageSize(Double.parseDouble(minValue), this.getStorageUnits(minUnits)));
                }
                if (maxValue != null) {
                    tss.setMaxSwapSize(new StorageSize(Double.parseDouble(maxValue), this.getStorageUnits(maxUnits)));
                }
            }
            this.addTaskSwapSizeStep(swapElem, tss);
        }
        if (tss == null) {
            Object[] msgParams = new String[]{CDMConstraintTypes.SWAP_SIZE};
            String msg = s_msgBundle.getMessage("1110", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        return tss;
    }

    private void addTaskSwapSizeStep(HashMap<String, String> swapElem, TaskSwapSize tss) throws XmlParserException {
        Float multipleF;
        String units = swapElem.get(CDMConstraintTypes.UNIT);
        StorageUnit su = this.getStorageUnits(units);
        RangeOfValue r = new RangeOfValue(RangeType.STORAGE_SIZE);
        StorageSize valueSS = null;
        StorageSize atleastSS = null;
        StorageSize atmostSS = null;
        StorageSize gthanSS = null;
        StorageSize lthanSS = null;
        String value = swapElem.get(CDMConstraintTypes.VALUE);
        String atleast = swapElem.get(CDMConstraintTypes.ATLEAST);
        String atmost = swapElem.get(CDMConstraintTypes.ATMOST);
        String gthan = swapElem.get(CDMConstraintTypes.GREATER_THAN);
        String lthan = swapElem.get(CDMConstraintTypes.LESS_THAN);
        try {
            if (value != null) {
                valueSS = new StorageSize(Double.parseDouble(value), su);
            }
            if (atleast != null) {
                atleastSS = new StorageSize(Double.parseDouble(atleast), su);
            }
            if (atmost != null) {
                atmostSS = new StorageSize(Double.parseDouble(atmost), su);
            }
            if (gthan != null) {
                gthanSS = new StorageSize(Double.parseDouble(gthan), su);
            }
            if (lthan != null) {
                lthanSS = new StorageSize(Double.parseDouble(lthan), su);
            }
        }
        catch (NumberFormatException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
        try {
            this.manipulateRange(r, valueSS, atleastSS, atmostSS, gthanSS, lthanSS, false);
        }
        catch (InvalidRangeManipulationException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
        String multiple = swapElem.get(CDMConstraintTypes.MULTIPLE);
        try {
            multipleF = Float.valueOf(Float.parseFloat(multiple));
        }
        catch (NumberFormatException nfe) {
            Object[] msgParams = new String[]{multiple, CDMConstraintTypes.MULTIPLE, CDMConstraintTypes.STEP};
            String msg = s_msgBundle.getMessage("1097", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg, nfe);
        }
        try {
            tss.addStep(r, su, multipleF.floatValue());
        }
        catch (InvalidStepException ise) {
            throw new XmlParserException(ise.getMessage(), ise);
        }
    }

    private TaskContainerFreeSpace createTaskContainerFreeSpace(CDMSystem cdmSystem) throws XmlParserException {
        Vector<CDMSpaceConstraints> cdmSCList;
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        if ((cdmSCList = cdmSystem.getCDMSpaceConstraints()).size() == 0) {
            return null;
        }
        TaskContainerFreeSpace tcfs = new TaskContainerFreeSpace();
        tcfs.setNodeList(this.m_xmlNodeList);
        for (int i = 0; i < cdmSCList.size(); ++i) {
            CDMSpaceConstraints cdmSC = cdmSCList.elementAt(i);
            this.addFreeSpaceLoc(cdmSC, tcfs);
        }
        tcfs.setSubTasks(tcfs.getTaskFreeSpaceList());
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return tcfs;
    }

    private void addFreeSpaceLoc(CDMSpaceConstraints cdmSC, TaskContainerFreeSpace tcfs) throws XmlParserException {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        Hashtable<String, HashMap> installLocs = cdmSC.getInstallLocations();
        Iterator<HashMap> iter = installLocs.values().iterator();
        for (int i = 0; i < installLocs.size(); ++i) {
            HashMap installLoc = iter.next();
            String sUnits = (String)installLoc.get(CDMConstraintTypes.UNIT);
            String sTemp = (String)installLoc.get(CDMConstraintTypes.TEMP);
            String sSize = (String)installLoc.get(CDMConstraintTypes.SIZE);
            String sVar = (String)installLoc.get(CDMConstraintTypes.VAR);
            String sVal = (String)installLoc.get(CDMConstraintTypes.VALUE);
            SeverityType severity = this.getSeverityAttributeValue((String)installLoc.get(CDMConstraintTypes.SEVERITY));
            StorageUnit su = this.getStorageUnits(sUnits);
            String loc = null;
            if (sVar != null && !sVar.equals("") && sVal != null && !sVal.equals("")) {
                Object[] msgParams = new String[]{CDMConstraintTypes.LOC};
                String msg = s_msgBundle.getMessage("1109", false, msgParams);
                Trace.out((String)msg);
                throw new XmlParserException(msg);
            }
            if (sVar != null) {
                loc = VerificationUtil.getVariableValue(sVar);
                if (loc == null) {
                    if (!Trace.isLevelEnabled((int)1)) continue;
                    Trace.out((String)("Value for variable " + sVar + " returned null, skipping loc tag."));
                    continue;
                }
            } else if (sVal != null) {
                loc = sVal;
            }
            try {
                Double sSizeDbl = new Double(sSize);
                tcfs.addPathDetails(loc, new StorageSize(sSizeDbl, su), Boolean.parseBoolean(sTemp), severity);
                continue;
            }
            catch (NumberFormatException nfe) {
                Object[] msgParams = new String[]{sSize, CDMConstraintTypes.SIZE, CDMConstraintTypes.SPACE};
                String msg = s_msgBundle.getMessage("1097", false, msgParams);
                Trace.out((String)msg);
                throw new XmlParserException(msg, nfe);
            }
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
    }

    private List<TaskUserExistence> createTaskUserExistence(CDMUserGroups cdmUG) throws XmlParserException {
        Vector<HashMap<String, String>> users = cdmUG.getUserConstraints();
        ArrayList<TaskUserExistence> tuelist = new ArrayList<TaskUserExistence>();
        for (int i = 0; i < users.size(); ++i) {
            HashMap<String, String> userMap = users.elementAt(i);
            SeverityType severity = this.getSeverityAttributeValue(userMap.get(CDMConstraintTypes.SEVERITY));
            String user = userMap.get(CDMConstraintTypes.USER_VALUE);
            TaskUserExistence tue = new TaskUserExistence(user);
            tue.setSeverity(severity);
            tuelist.add(tue);
        }
        return tuelist;
    }

    private List<Task> createTaskGroupExistence(CDMUserGroups cdmUG) throws XmlParserException {
        Vector<HashMap<String, String>> groups = cdmUG.getGroupConstraints();
        TaskGroupExistence[] tgeList = new TaskGroupExistence[groups.size()];
        Vector<Task> retTasks = new Vector<Task>();
        for (int i = 0; i < groups.size(); ++i) {
            HashMap<String, String> groupMap = groups.elementAt(i);
            String group = groupMap.get(CDMConstraintTypes.GROUP_VALUE);
            SeverityType severity = this.getSeverityAttributeValue(groupMap.get(CDMConstraintTypes.SEVERITY));
            tgeList[i] = new TaskGroupExistence(group);
            tgeList[i].setSeverity(severity);
            retTasks.add(tgeList[i]);
        }
        return retTasks;
    }

    private List<Task> createTaskGroupMembership(CDMUserGroups cdmUG) throws XmlParserException {
        Vector<HashMap<String, String>> groups = cdmUG.getUserGroups();
        TaskGroupMembership[] tgmList = new TaskGroupMembership[groups.size()];
        Vector<Task> retTasks = new Vector<Task>();
        for (int i = 0; i < groups.size(); ++i) {
            HashMap<String, String> groupMap = groups.elementAt(i);
            String user = groupMap.get(CDMConstraintTypes.USER_VALUE);
            String group = groupMap.get(CDMConstraintTypes.GROUP_VALUE);
            SeverityType severity = this.getSeverityAttributeValue(groupMap.get(CDMConstraintTypes.SEVERITY));
            String active = groupMap.get(CDMConstraintTypes.ACTIVE);
            tgmList[i] = new TaskGroupMembership(user, group, Boolean.parseBoolean(active));
            tgmList[i].setSeverity(severity);
            retTasks.add(tgmList[i]);
        }
        return retTasks;
    }

    private TaskRunLevel createTaskRunLevel(CDMSystem cdmSystem) throws XmlParserException {
        HashMap runLevel = cdmSystem.getRunLevelCheck();
        if (runLevel == null) {
            return null;
        }
        List runLevels = (List)runLevel.get(CDMConstraintTypes.VALUE);
        SeverityType severity = this.getSeverityAttributeValue((String)runLevel.get(CDMConstraintTypes.SEVERITY));
        TaskRunLevel trl = new TaskRunLevel(runLevels);
        trl.setSeverity(severity);
        return trl;
    }

    private TaskShellLimits[] createTaskShellLimits(CDMShellLimitChecks cdmSlc) throws XmlParserException {
        int i;
        Vector<HashMap<String, String>> fdLimits = cdmSlc.getFileDescriptorLimits();
        Vector<HashMap<String, String>> mpLimits = cdmSlc.getMaxProcessLimits();
        TaskShellLimits[] tslList = new TaskShellLimits[fdLimits.size() + mpLimits.size()];
        for (i = 0; i < fdLimits.size(); ++i) {
            tslList[i] = this.createTaskShellLimit(fdLimits.elementAt(i), ShellResourceType.MAX_FILEDESC);
        }
        for (i = 0; i < mpLimits.size(); ++i) {
            tslList[fdLimits.size() + i] = this.createTaskShellLimit(mpLimits.elementAt(i), ShellResourceType.MAX_PROC);
        }
        return tslList;
    }

    private TaskShellLimits createTaskShellLimit(HashMap fdLimit, ShellResourceType srt) throws XmlParserException {
        String limitType = (String)fdLimit.get(CDMConstraintTypes.LIMIT_TYPE);
        String limit = (String)fdLimit.get(CDMConstraintTypes.LIMIT);
        String shellSel = (String)fdLimit.get(CDMConstraintTypes.SELECTION);
        SeverityType severity = this.getSeverityAttributeValue((String)fdLimit.get(CDMConstraintTypes.SEVERITY));
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("limitType" + limitType + ", limit=" + limit + ", shellSel=" + shellSel + ", severity=" + (Object)((Object)severity)));
        }
        ShellType st = this.getShellType(shellSel);
        ShellLimitType slt = "HARD".equals(limitType) ? ShellLimitType.HARD : ShellLimitType.SOFT;
        long num_limit = 0L;
        try {
            num_limit = Long.parseLong(limit);
        }
        catch (NumberFormatException nfe) {
            Object[] msgParams = new String[]{limit, CDMConstraintTypes.VALUE, CDMConstraintTypes.LIMIT};
            String msg = s_msgBundle.getMessage("1095", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg, nfe);
        }
        TaskShellLimits task = new TaskShellLimits(st, srt, slt, num_limit);
        task.setSeverity(severity);
        return task;
    }

    private TaskProcessAlive[] createTaskProcessAlive(CDMProcessChecks cdmProcessChecks) throws XmlParserException {
        Vector<HashMap> processChecks = cdmProcessChecks.getProcessChecks();
        TaskProcessAlive[] tpaList = new TaskProcessAlive[processChecks.size()];
        for (int i = 0; i < processChecks.size(); ++i) {
            HashMap pc = processChecks.elementAt(i);
            String processName = (String)pc.get(CDMConstraintTypes.NAME);
            SeverityType severity = this.getSeverityAttributeValue((String)pc.get(CDMConstraintTypes.SEVERITY));
            tpaList[i] = new TaskProcessAlive(processName);
            tpaList[i].setSeverity(severity);
        }
        return tpaList;
    }

    private TaskArchitecture createTaskArchitecture(CDMOperatingSystem cdmOS) throws XmlParserException {
        HashMap<String, Object> kerAttrs = cdmOS.getArchitectureValues();
        List osArchs = (List)kerAttrs.get(CDMConstraintTypes.VALUE);
        SeverityType severity = this.getSeverityAttributeValue((String)kerAttrs.get(CDMConstraintTypes.SEVERITY));
        if (osArchs == null) {
            return null;
        }
        TaskArchitecture ta = new TaskArchitecture(osArchs);
        ta.setSeverity(severity);
        return ta;
    }

    private TaskCheckEnvVariable[] createTaskCheckEnvVariable(CDMOperatingSystem cdmOS) throws XmlParserException {
        Vector<HashMap<String, String>> envAttrs = cdmOS.getEnvVariables();
        Vector<TaskCheckEnvVariable> tcenvVect = new Vector<TaskCheckEnvVariable>();
        String[] exceptionalVarList = new String[]{"ORA_CRS_HOME"};
        int s_maxLength = 0;
        boolean s_set = false;
        boolean isRestartServiceSet = false;
        boolean isTestEnv = Utils.isDevelopmentEnv();
        for (int i = 0; i < envAttrs.size(); ++i) {
            s_maxLength = 0;
            s_set = false;
            HashMap<String, String> envData = envAttrs.elementAt(i);
            String name = envData.get(CDMConstraintTypes.ENV_VAR_NAME);
            if (Arrays.asList(exceptionalVarList).contains(name.toUpperCase()) && isTestEnv) continue;
            String maxLength = envData.get(CDMConstraintTypes.MAX_LENGTH);
            String set = envData.get(CDMConstraintTypes.SET);
            s_set = set != null && set.length() > 0 ? Boolean.parseBoolean(set) : true;
            if (maxLength != null && maxLength.length() > 0) {
                s_maxLength = Integer.parseInt(maxLength);
            }
            if (s_maxLength != 0 && !s_set) {
                String msg = s_msgBundle.getMessage("1109", false, (Object[])new String[]{CDMConstraintTypes.ENV_VAR});
                Trace.out((String)msg);
                throw new XmlParserException(msg);
            }
            TaskCheckEnvVariable tcenv = new TaskCheckEnvVariable();
            tcenv.setVariableName(name);
            tcenv.setMaxVariableLength(s_maxLength);
            tcenv.checkVariableSet(s_set);
            tcenv.setNodeList(this.m_xmlNodeList);
            if (!isRestartServiceSet) {
                Trace.out((String)"XmlTaskFactory::createTaskCheckEnvVariable setting the switch for restarting remote exec services.");
                isRestartServiceSet = true;
                tcenv.setRestartService(isRestartServiceSet);
            }
            tcenvVect.add(tcenv);
        }
        Object[] tcenvList = new TaskCheckEnvVariable[tcenvVect.size()];
        tcenvVect.copyInto(tcenvList);
        return tcenvList;
    }

    private TaskOSPatch[] createTaskOSPatches(CDMOperatingSystem cdmOS) throws XmlParserException {
        List<HashMap<String, String>> osPatchChecks = cdmOS.getOSPatches();
        TaskOSPatch[] tospList = new TaskOSPatch[osPatchChecks.size()];
        for (int i = 0; i < osPatchChecks.size(); ++i) {
            HashMap<String, String> pc = osPatchChecks.get(i);
            String osPatch = pc.get(CDMConstraintTypes.VALUE);
            SeverityType severity = this.getSeverityAttributeValue(pc.get(CDMConstraintTypes.SEVERITY));
            tospList[i] = new TaskOSPatch(osPatch);
            tospList[i].setSeverity(severity);
        }
        return tospList;
    }

    private TaskKernelVersion createTaskKernelVersion(CDMOperatingSystem cdmOS) throws XmlParserException {
        HashMap kerAttrs = cdmOS.getKernelAttributes();
        String kver = (String)kerAttrs.get(CDMConstraintTypes.KERNEL_VER);
        if (kver == null) {
            return null;
        }
        TaskKernelVersion tkver = new TaskKernelVersion(kver);
        return tkver;
    }

    private TaskContainerKernelParams createTaskContainerKernelParams(CDMOperatingSystem cdmOS) throws XmlParserException {
        HashMap<String, Object> propertiesHM = cdmOS.getKernelProperties();
        if (propertiesHM.size() == 0) {
            return null;
        }
        TaskKernelParam[] tkpList = new TaskKernelParam[propertiesHM.size()];
        Iterator<String> paramNameIter = propertiesHM.keySet().iterator();
        int propertyCount = -1;
        SeverityType severity = null;
        while (paramNameIter.hasNext()) {
            String paramName = paramNameIter.next();
            ++propertyCount;
            Object paramCriteria = propertiesHM.get(paramName);
            if (paramCriteria instanceof HashMap) {
                HashMap properties = (HashMap)paramCriteria;
                String name = (String)properties.get(CDMConstraintTypes.NAME);
                String value = (String)properties.get(CDMConstraintTypes.VALUE);
                String atleast = (String)properties.get(CDMConstraintTypes.ATLEAST);
                String atmost = (String)properties.get(CDMConstraintTypes.ATMOST);
                String gthan = (String)properties.get(CDMConstraintTypes.GREATER_THAN);
                String lthan = (String)properties.get(CDMConstraintTypes.LESS_THAN);
                severity = this.getSeverityAttributeValue((String)properties.get(CDMConstraintTypes.SEVERITY));
                if (value != null) {
                    tkpList[propertyCount] = new TaskKernelParam(name, value);
                } else {
                    RangeOfValue r = new RangeOfValue(RangeType.INTEGER);
                    try {
                        this.manipulateRange(r, value, atleast, atmost, gthan, lthan, false);
                    }
                    catch (InvalidRangeManipulationException e) {
                        throw new XmlParserException(e.getMessage(), e);
                    }
                    tkpList[propertyCount] = new TaskKernelParam(name, r);
                }
                tkpList[propertyCount].setSeverity(severity);
                continue;
            }
            List paramSteps = (List)paramCriteria;
            if (paramSteps == null) {
                return null;
            }
            for (int i = 0; i < paramSteps.size(); ++i) {
                HashMap kernelParamStepHM = (HashMap)paramSteps.get(i);
                if (tkpList[propertyCount] == null) {
                    tkpList[propertyCount] = new TaskKernelParam(paramName);
                    severity = this.getSeverityAttributeValue((String)kernelParamStepHM.get(CDMConstraintTypes.SEVERITY));
                    tkpList[propertyCount].setSeverity(severity);
                }
                this.addTaskKernelPropertyStep(kernelParamStepHM, tkpList[propertyCount]);
            }
            if (tkpList[propertyCount] != null) continue;
            Object[] msgParams = new String[]{CDMConstraintTypes.PROPERTY};
            String msg = s_msgBundle.getMessage("1110", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        TaskContainerKernelParams tckp = new TaskContainerKernelParams(tkpList);
        return tckp;
    }

    private void addTaskKernelPropertyStep(HashMap<String, String> kernelParamStepHM, TaskKernelParam tkp) throws XmlParserException {
        Float multipleF;
        String units = kernelParamStepHM.get(CDMConstraintTypes.UNIT);
        StorageUnit su = this.getStorageUnits(units);
        RangeOfValue r = new RangeOfValue(RangeType.STORAGE_SIZE);
        StorageSize valueSS = null;
        StorageSize atleastSS = null;
        StorageSize atmostSS = null;
        StorageSize gthanSS = null;
        StorageSize lthanSS = null;
        String value = kernelParamStepHM.get(CDMConstraintTypes.VALUE);
        String atleast = kernelParamStepHM.get(CDMConstraintTypes.ATLEAST);
        String atmost = kernelParamStepHM.get(CDMConstraintTypes.ATMOST);
        String gthan = kernelParamStepHM.get(CDMConstraintTypes.GREATER_THAN);
        String lthan = kernelParamStepHM.get(CDMConstraintTypes.LESS_THAN);
        try {
            if (value != null) {
                valueSS = new StorageSize(Double.parseDouble(value), su);
            }
            if (atleast != null) {
                atleastSS = new StorageSize(Double.parseDouble(atleast), su);
            }
            if (atmost != null) {
                atmostSS = new StorageSize(Double.parseDouble(atmost), su);
            }
            if (gthan != null) {
                gthanSS = new StorageSize(Double.parseDouble(gthan), su);
            }
            if (lthan != null) {
                lthanSS = new StorageSize(Double.parseDouble(lthan), su);
            }
        }
        catch (NumberFormatException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
        try {
            this.manipulateRange(r, valueSS, atleastSS, atmostSS, gthanSS, lthanSS, false);
        }
        catch (InvalidRangeManipulationException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
        String multiple = kernelParamStepHM.get(CDMConstraintTypes.MULTIPLE);
        try {
            multipleF = Float.valueOf(Float.parseFloat(multiple));
        }
        catch (NumberFormatException nfe) {
            Object[] msgParams = new String[]{multiple, CDMConstraintTypes.MULTIPLE, CDMConstraintTypes.STEP};
            String msg = s_msgBundle.getMessage("1097", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg, nfe);
        }
        try {
            tkp.addStep(r, su, multipleF.floatValue());
        }
        catch (InvalidStepException ise) {
            throw new XmlParserException(ise.getMessage(), ise);
        }
    }

    private TaskContainerPackages createTaskContainerPackages(CDMOperatingSystem cdmOS) throws XmlParserException {
        List<HashMap<String, Object>> packageList = cdmOS.getPackages();
        if (packageList.size() == 0) {
            return null;
        }
        TaskPackage[] tpList = new TaskPackage[packageList.size()];
        int packageCounter = 0;
        for (HashMap<String, Object> pkgCriteria : packageList) {
            TaskPackage tp = null;
            String pkgName = (String)pkgCriteria.get(CDMConstraintTypes.NAME);
            String pkgArch = (String)pkgCriteria.get(CDMConstraintTypes.ARCHITECTURE);
            SeverityType severity = this.getSeverityAttributeValue((String)pkgCriteria.get(CDMConstraintTypes.SEVERITY));
            Object criteria = pkgCriteria.get(CDMConstraintTypes.VALUE);
            tp = criteria instanceof String ? new TaskPackage(pkgName, criteria.toString(), pkgArch) : new TaskPackage(pkgName, (RangeOfValue)criteria, pkgArch);
            tp.setSeverity(severity);
            tpList[packageCounter++] = tp;
        }
        TaskContainerPackages tcPkgs = new TaskContainerPackages(tpList);
        return tcPkgs;
    }

    private StorageUnit getStorageUnits(String units) throws XmlParserException {
        if (units == null) {
            Object[] msgParams = new String[]{units};
            String msg = s_msgBundle.getMessage("1105", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        if (units.equals("B")) {
            return StorageUnit.BYTE;
        }
        if (units.equals("KB")) {
            return StorageUnit.KBYTE;
        }
        if (units.equals("MB")) {
            return StorageUnit.MBYTE;
        }
        if (units.equals("GB")) {
            return StorageUnit.GBYTE;
        }
        if (units.equals("TB")) {
            return StorageUnit.TBYTE;
        }
        Object[] msgParams = new String[]{units};
        String msg = s_msgBundle.getMessage("1105", false, msgParams);
        Trace.out((String)msg);
        throw new XmlParserException(msg);
    }

    private ShellType getShellType(String shellSel) throws XmlParserException {
        if (shellSel == null) {
            Object[] msgParams = new String[]{shellSel};
            String msg = s_msgBundle.getMessage("1106", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        if (shellSel.equals("SH")) {
            return ShellType.SH;
        }
        if (shellSel.equals("BASH")) {
            return ShellType.BASH;
        }
        if (shellSel.equals("KSH")) {
            return ShellType.KSH;
        }
        if (shellSel.equals("CSH")) {
            return ShellType.CSH;
        }
        if (shellSel.equals("TCSH")) {
            return ShellType.TCSH;
        }
        if (shellSel.equals("ZSH")) {
            return ShellType.ZSH;
        }
        Object[] msgParams = new String[]{shellSel};
        String msg = s_msgBundle.getMessage("1106", false, msgParams);
        Trace.out((String)msg);
        throw new XmlParserException(msg);
    }

    private void manipulateRange(RangeOfValue r, Object value, Object atleast, Object atmost, Object gthan, Object lthan, boolean exclude) throws XmlParserException, InvalidRangeManipulationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("RangeOfValue = " + r + ", value = " + value + ", atleast = " + atleast + ", atmost = " + atmost + ", gthan = " + gthan + ", lthan = " + lthan + ", exclude = " + exclude));
        }
        if (value == null && atleast == null && atmost == null && gthan == null && lthan == null) {
            String msg = s_msgBundle.getMessage("1112", false);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        if (value != null && (atleast != null || atmost != null || gthan != null || lthan != null)) {
            String msg = s_msgBundle.getMessage("1113", false);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        if (value != null) {
            try {
                if (!exclude) {
                    r.include(RangeOperator.EQ, value);
                } else {
                    r.exclude(RangeOperator.EQ, value);
                }
                return;
            }
            catch (InvalidRangeManipulationException e) {
                new XmlParserException(e.getMessage(), e);
            }
        }
        if (atleast != null && gthan != null) {
            Object[] msgParams = new String[]{RangeOperator.GE.toString(), RangeOperator.GT.toString()};
            String msg = s_msgBundle.getMessage("1114", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        if (atmost != null && lthan != null) {
            Object[] msgParams = new String[]{RangeOperator.LE.toString(), RangeOperator.LT.toString()};
            String msg = s_msgBundle.getMessage("1114", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        RangeOperator firstRangeOp = null;
        Object firstRangeValue = null;
        RangeOperator secondRangeOp = null;
        Object secondRangeValue = null;
        if (atleast != null) {
            firstRangeOp = this.getRangeOperator(CDMConstraintTypes.ATLEAST);
            firstRangeValue = atleast;
        } else if (gthan != null) {
            firstRangeOp = this.getRangeOperator(CDMConstraintTypes.GREATER_THAN);
            firstRangeValue = gthan;
        }
        if (atmost != null) {
            if (firstRangeOp != null) {
                secondRangeOp = this.getRangeOperator(CDMConstraintTypes.ATMOST);
                secondRangeValue = atmost;
            } else {
                firstRangeOp = this.getRangeOperator(CDMConstraintTypes.ATMOST);
                firstRangeValue = atmost;
            }
        } else if (lthan != null) {
            if (firstRangeOp != null) {
                secondRangeOp = this.getRangeOperator(CDMConstraintTypes.LESS_THAN);
                secondRangeValue = lthan;
            } else {
                firstRangeOp = this.getRangeOperator(CDMConstraintTypes.LESS_THAN);
                firstRangeValue = lthan;
            }
        }
        if (!exclude) {
            if (secondRangeOp != null) {
                r.include(firstRangeOp, firstRangeValue, secondRangeOp, secondRangeValue);
            } else {
                r.include(firstRangeOp, firstRangeValue);
            }
        } else if (secondRangeOp != null) {
            r.exclude(firstRangeOp, firstRangeValue, secondRangeOp, secondRangeValue);
        } else {
            r.exclude(firstRangeOp, firstRangeValue);
        }
    }

    private void convertRangeValuesToBaseUnit(HashMap<String, String> rangeAttributes, long conversionFactor) {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Enter convertRangeValuesToCanonical. rangeAttributes = " + rangeAttributes + ", conversionFactor = " + conversionFactor));
        }
        String value = rangeAttributes.get(CDMConstraintTypes.VALUE);
        String atleast = rangeAttributes.get(CDMConstraintTypes.ATLEAST);
        String atmost = rangeAttributes.get(CDMConstraintTypes.ATMOST);
        String gthan = rangeAttributes.get(CDMConstraintTypes.GREATER_THAN);
        String lthan = rangeAttributes.get(CDMConstraintTypes.LESS_THAN);
        if (value != null) {
            double convertedValue = Double.parseDouble(value) * (double)conversionFactor;
            rangeAttributes.put(CDMConstraintTypes.VALUE, Double.toString(convertedValue));
        }
        if (atleast != null) {
            double convertedAtleast = Double.parseDouble(atleast) * (double)conversionFactor;
            rangeAttributes.put(CDMConstraintTypes.ATLEAST, Double.toString(convertedAtleast));
        }
        if (atmost != null) {
            double convertedatmost = Double.parseDouble(atmost) * (double)conversionFactor;
            rangeAttributes.put(CDMConstraintTypes.ATMOST, Double.toString(convertedatmost));
        }
        if (gthan != null) {
            double convertedgthan = Double.parseDouble(gthan) * (double)conversionFactor;
            rangeAttributes.put(CDMConstraintTypes.GREATER_THAN, Double.toString(convertedgthan));
        }
        if (lthan != null) {
            double convertedlthan = Double.parseDouble(lthan) * (double)conversionFactor;
            rangeAttributes.put(CDMConstraintTypes.LESS_THAN, Double.toString(convertedlthan));
        }
    }

    private RangeOperator getRangeOperator(String op) throws XmlParserException {
        if (op == null) {
            Object[] msgParams = new String[]{"null"};
            String msg = s_msgBundle.getMessage("1107", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        if (op.equals(CDMConstraintTypes.VALUE)) {
            return RangeOperator.EQ;
        }
        if (op.equals(CDMConstraintTypes.ATLEAST)) {
            return RangeOperator.GE;
        }
        if (op.equals(CDMConstraintTypes.ATMOST)) {
            return RangeOperator.LE;
        }
        if (op.equals(CDMConstraintTypes.GREATER_THAN)) {
            return RangeOperator.GT;
        }
        if (op.equals(CDMConstraintTypes.LESS_THAN)) {
            return RangeOperator.LT;
        }
        Object[] msgParams = new String[]{op};
        String msg = s_msgBundle.getMessage("1107", false, msgParams);
        Trace.out((String)msg);
        throw new XmlParserException(msg);
    }

    private SeverityType getSeverityAttributeValue(String severityStr) throws XmlParserException {
        SeverityType severity = SeverityType.CRITICAL;
        if ("IGNORABLE".equalsIgnoreCase(severityStr)) {
            severity = SeverityType.IGNORABLE;
        }
        return severity;
    }
}

