/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.constraints.parser;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import oracle.cluster.verification.constraints.CDMCertifiedSystems;
import oracle.cluster.verification.constraints.CDMConstraintTypes;
import oracle.cluster.verification.constraints.CDMHost;
import oracle.cluster.verification.constraints.CDMMemoryConstraints;
import oracle.cluster.verification.constraints.CDMOperatingSystem;
import oracle.cluster.verification.constraints.CDMOracleHome;
import oracle.cluster.verification.constraints.CDMProcessChecks;
import oracle.cluster.verification.constraints.CDMReferenceDevices;
import oracle.cluster.verification.constraints.CDMShellLimitChecks;
import oracle.cluster.verification.constraints.CDMSpaceConstraints;
import oracle.cluster.verification.constraints.CDMSystem;
import oracle.cluster.verification.constraints.CDMUserGroups;
import oracle.cluster.verification.constraints.CDMUserInputs;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.cluster.verification.constraints.parser.NodeVisitorCB;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.security.NullSecurityManager;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.param.InvalidCommandlineException;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.util.InvalidRangeManipulationException;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.RangeOfValue;
import oracle.ops.verification.framework.util.RangeOperator;
import oracle.ops.verification.framework.util.RangeType;
import oracle.ops.verification.framework.util.VerificationUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlParser {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private File m_cdmDataFile = null;
    private boolean m_parseXmlFile = false;
    private String m_xmlDoc = null;
    private CDMHost m_cdmHost = null;
    private DocumentBuilderFactory m_xmlFactory = null;
    private DocumentBuilder m_xmlParser = null;
    private Document m_xmlDocument = null;
    private Element m_rootElement = null;

    public XmlParser(File xmlFile) {
        this.m_cdmDataFile = xmlFile;
        this.m_parseXmlFile = true;
    }

    public XmlParser(String xmlDoc) {
        this.m_xmlDoc = xmlDoc;
        this.m_parseXmlFile = false;
    }

    public void parse() throws XmlParserException {
        try {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)"Creating document builder");
            }
            this.m_xmlFactory = DocumentBuilderFactory.newInstance();
            String xsdURI = VerificationUtil.getPreReqXmlSchemaURI(new Version().toString());
            if (xsdURI != null) {
                this.m_xmlFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                this.m_xmlFactory.setNamespaceAware(true);
                this.m_xmlFactory.setValidating(true);
                this.m_xmlFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", xsdURI);
            }
            this.m_xmlParser = this.m_xmlFactory.newDocumentBuilder();
            ErrorHandler handler = new ErrorHandler(){

                public void error(SAXParseException arg0) throws SAXException {
                    throw arg0;
                }

                public void fatalError(SAXParseException arg0) throws SAXException {
                    throw arg0;
                }

                public void warning(SAXParseException arg0) throws SAXException {
                    Trace.out((String)("Igonred waring while parsing: " + arg0));
                }
            };
            this.m_xmlParser.setErrorHandler(handler);
            this.m_xmlDocument = null;
            InputSource is = null;
            if (this.m_parseXmlFile) {
                is = new InputSource(new FileReader(this.m_cdmDataFile));
            } else {
                StringReader sr = new StringReader(this.m_xmlDoc);
                is = new InputSource(sr);
            }
            if (Trace.isTraceEnabled()) {
                Trace.out((String)"Calling parser.parse..");
            }
            this.m_xmlDocument = this.m_xmlParser.parse(is);
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Parser validation set to: " + this.m_xmlParser.isValidating()));
                Trace.out((String)"XML is well-formed");
            }
            this.m_rootElement = this.m_xmlDocument.getDocumentElement();
            String hostElement = this.m_rootElement.getTagName();
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Root element = " + hostElement));
            }
            String hostId = this.m_rootElement.getAttribute(CDMConstraintTypes.PLATID);
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Host Id  = " + hostId));
            }
            if (!hostElement.equalsIgnoreCase(CDMConstraintTypes.HOST)) {
                Trace.out((String)"ERROR: Invalid root element");
                String msg = s_msgBundle.getMessage("1108", false);
                throw new XmlParserException(msg);
            }
            this.m_cdmHost = this.parseHostTag(this.m_rootElement);
            return;
        }
        catch (SAXException se) {
            throw new XmlParserException(se.getMessage(), se);
        }
        catch (IOException ioe) {
            throw new XmlParserException(ioe.getMessage(), ioe);
        }
        catch (FactoryConfigurationError fce) {
            throw new XmlParserException(fce.getMessage(), fce);
        }
        catch (ParserConfigurationException pce) {
            throw new XmlParserException(pce.getMessage(), pce);
        }
        catch (XmlFilePathException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
    }

    public CDMHost getCDMData() {
        return this.m_cdmHost;
    }

    private CDMHost parseHostTag(Element xmlElem) throws XmlParserException {
        CDMHost host = new CDMHost();
        this.parseSystemTags(host, xmlElem);
        this.parseCertifiedSystemsTags(host, xmlElem);
        this.parseReferenceDevicesTags(host, xmlElem);
        this.parseScriptsTags(host, xmlElem);
        this.parseUserInputsTags(host, xmlElem);
        this.parseDirsTags(host, xmlElem);
        this.parseNetworkTags(host, xmlElem);
        this.parseOracleHomeTags(host, xmlElem);
        return host;
    }

    private void parseSystemTags(CDMHost cdmHost, Element xmlElem) throws XmlParserException {
        NodeList systems = xmlElem.getElementsByTagName(CDMConstraintTypes.SYSTEM);
        Element systemElem = null;
        systemElem = this.checkNumOfElements(systems, CDMConstraintTypes.SYSTEM);
        if (systemElem != null) {
            CDMSystem cdmSystem = new CDMSystem();
            this.parseMemoryTags(cdmSystem, systemElem);
            this.parseSpaceTags(cdmSystem, systemElem);
            this.parseUsersGroupsTags(cdmSystem, systemElem);
            this.parseRunLevelTags(cdmSystem, systemElem);
            this.parseShellLimitCheckTags(cdmSystem, systemElem);
            this.parseProcessChecksTags(cdmSystem, systemElem);
            cdmHost.addCDMSystem(cdmSystem);
        }
    }

    private void parseMemoryTags(CDMSystem cdmSystem, Element xmlElem) throws XmlParserException {
        NodeList memoryList = xmlElem.getElementsByTagName(CDMConstraintTypes.MEMORY);
        Element elem = null;
        elem = this.checkNumOfElements(memoryList, CDMConstraintTypes.MEMORY);
        if (elem != null) {
            CDMMemoryConstraints cdmMC = new CDMMemoryConstraints();
            this.parsePhysicalMemoryTags(cdmMC, elem);
            this.parseAvailableMemoryTags(cdmMC, elem);
            this.parseSwapSizeTags(cdmMC, elem);
            cdmSystem.addCDMMemoryConstraints(cdmMC);
        }
    }

    private void parsePhysicalMemoryTags(CDMMemoryConstraints cdmMC, Element xmlElem) throws XmlParserException {
        NodeList pmemElems = xmlElem.getElementsByTagName(CDMConstraintTypes.PHYSICAL_MEMORY);
        Element elem = null;
        elem = this.checkNumOfElements(pmemElems, CDMConstraintTypes.PHYSICAL_MEMORY);
        if (elem != null) {
            String value = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VALUE);
            String units = this.getRequiredAttributeValue(elem, CDMConstraintTypes.UNIT);
            String severity = this.getOptionalAttributeValue(elem, CDMConstraintTypes.SEVERITY);
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Physical memory: value = " + value + " , " + "units = " + units + " , " + "severity = " + severity));
            }
            cdmMC.addPhysicalMemory(value, units, severity);
        }
    }

    private void parseAvailableMemoryTags(CDMMemoryConstraints cdmMC, Element xmlElem) throws XmlParserException {
        NodeList available_memorys = xmlElem.getElementsByTagName(CDMConstraintTypes.AVAILABLE_MEMORY);
        Element elem = null;
        elem = this.checkNumOfElements(available_memorys, CDMConstraintTypes.AVAILABLE_MEMORY);
        if (elem != null) {
            String value = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VALUE);
            String units = this.getRequiredAttributeValue(elem, CDMConstraintTypes.UNIT);
            String severity = this.getOptionalAttributeValue(elem, CDMConstraintTypes.SEVERITY);
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Available memory: value = " + value + " , " + "units = " + units + " , " + "severity = " + severity));
            }
            cdmMC.addAvailableMemory(value, units, severity);
        }
    }

    private void parseSwapSizeTags(CDMMemoryConstraints cdmMC, Element xmlElem) throws XmlParserException {
        NodeList swap_size = xmlElem.getElementsByTagName(CDMConstraintTypes.SWAP_SIZE);
        Element elem = null;
        elem = this.checkNumOfElements(swap_size, CDMConstraintTypes.SWAP_SIZE);
        if (elem != null) {
            String value = this.getOptionalAttributeValue(elem, CDMConstraintTypes.VALUE);
            String severity = this.getOptionalAttributeValue(elem, CDMConstraintTypes.SEVERITY);
            if (value != null) {
                NodeList steps = elem.getElementsByTagName(CDMConstraintTypes.STEP);
                if (steps.getLength() > 0) {
                    Object[] msgParams = new String[]{CDMConstraintTypes.SWAP_SIZE};
                    String msg = s_msgBundle.getMessage("1109", false, msgParams);
                    Trace.out((String)msg);
                    throw new XmlParserException(msg);
                }
                String units = this.getOptionalAttributeValue(elem, CDMConstraintTypes.UNIT);
                cdmMC.addSwapMemory(value, units, severity);
            } else {
                this.parseStepTags(cdmMC, elem, severity);
            }
        }
    }

    private void parseStepTags(CDMMemoryConstraints cdmMC, Element xmlElem, String severity) throws XmlParserException {
        String minValue = null;
        String minUnit = null;
        Element minElem = null;
        minElem = this.checkNumOfElements(xmlElem.getElementsByTagName(CDMConstraintTypes.MIN), CDMConstraintTypes.MIN);
        if (minElem != null) {
            minValue = this.getRequiredAttributeValue(minElem, CDMConstraintTypes.VALUE);
            minUnit = this.getRequiredAttributeValue(minElem, CDMConstraintTypes.UNIT);
        }
        String maxValue = null;
        String maxUnit = null;
        Element maxElem = null;
        maxElem = this.checkNumOfElements(xmlElem.getElementsByTagName(CDMConstraintTypes.MAX), CDMConstraintTypes.MAX);
        if (maxElem != null) {
            maxValue = this.getRequiredAttributeValue(maxElem, CDMConstraintTypes.VALUE);
            maxUnit = this.getRequiredAttributeValue(maxElem, CDMConstraintTypes.UNIT);
        }
        NodeList steps = xmlElem.getElementsByTagName(CDMConstraintTypes.STEP);
        for (int i = 0; i < steps.getLength(); ++i) {
            Element elem = (Element)steps.item(i);
            String name = this.getRequiredAttributeValue(elem, CDMConstraintTypes.NAME);
            String value = this.getOptionalAttributeValue(elem, CDMConstraintTypes.VALUE);
            String gthan = this.getOptionalAttributeValue(elem, CDMConstraintTypes.GREATER_THAN);
            String lthan = this.getOptionalAttributeValue(elem, CDMConstraintTypes.LESS_THAN);
            String atLeast = this.getOptionalAttributeValue(elem, CDMConstraintTypes.ATLEAST);
            String atMost = this.getOptionalAttributeValue(elem, CDMConstraintTypes.ATMOST);
            String units = this.getOptionalAttributeValue(elem, CDMConstraintTypes.UNIT);
            String multpl = this.getOptionalAttributeValue(elem, CDMConstraintTypes.MULTIPLE);
            cdmMC.addSwapSizeStep(name, value, gthan, atLeast, lthan, atMost, units, multpl, severity, minValue, minUnit, maxValue, maxUnit);
        }
    }

    private void parseSpaceTags(CDMSystem cdmSystem, Element xmlElem) throws XmlParserException {
        NodeList spaceTags = xmlElem.getElementsByTagName(CDMConstraintTypes.SPACE);
        Element sTag = null;
        sTag = this.checkNumOfElements(spaceTags, CDMConstraintTypes.SPACE);
        if (sTag != null) {
            CDMSpaceConstraints cdmSC = new CDMSpaceConstraints();
            this.parseLocTags(cdmSC, sTag);
            cdmSystem.addCDMSpaceConstraints(cdmSC);
        }
    }

    private void parseLocTags(CDMSpaceConstraints cdmSC, Element xmlElem) throws XmlParserException {
        NodeList locss = xmlElem.getElementsByTagName(CDMConstraintTypes.LOC);
        for (int i = 0; i < locss.getLength(); ++i) {
            Element elem = (Element)locss.item(i);
            String sVar = this.getOptionalAttributeValue(elem, CDMConstraintTypes.VAR);
            String sVal = this.getOptionalAttributeValue(elem, CDMConstraintTypes.VALUE);
            String sTemp = this.getOptionalAttributeValue(elem, CDMConstraintTypes.TEMP);
            String sSize = this.getRequiredAttributeValue(elem, CDMConstraintTypes.SIZE);
            String sUnits = this.getRequiredAttributeValue(elem, CDMConstraintTypes.UNIT);
            String severity = this.getOptionalAttributeValue(elem, CDMConstraintTypes.SEVERITY);
            cdmSC.addInstallLocation(sVar, sVal, sTemp, sSize, sUnits, severity);
        }
    }

    private void parseUsersGroupsTags(CDMSystem cdmSystem, Element xmlElem) throws XmlParserException {
        NodeList userGroups = xmlElem.getElementsByTagName(CDMConstraintTypes.USERS_GROUPS);
        Element elem = null;
        elem = this.checkNumOfElements(userGroups, CDMConstraintTypes.USERS_GROUPS);
        if (elem != null) {
            CDMUserGroups cdmUG = new CDMUserGroups();
            cdmSystem.addCDMUserGroups(cdmUG);
            this.parseUserTags(cdmUG, elem);
            this.parseGroupTags(cdmUG, elem);
        }
    }

    private void parseUserTags(CDMUserGroups cdmUG, Element xmlElem) throws XmlParserException {
        NodeList users = xmlElem.getElementsByTagName(CDMConstraintTypes.USER);
        for (int i = 0; i < users.getLength(); ++i) {
            Object[] msgParams;
            Element elem = (Element)users.item(i);
            String userVar = this.getOptionalAttributeValue(elem, CDMConstraintTypes.VAR);
            String userValue = this.getOptionalAttributeValue(elem, CDMConstraintTypes.VALUE);
            if (userValue != null && !userValue.equals("") && userVar != null && !userVar.equals("")) {
                msgParams = new String[]{CDMConstraintTypes.USER};
                String msg = s_msgBundle.getMessage("1109", false, msgParams);
                Trace.out((String)msg);
                throw new XmlParserException(msg);
            }
            if ((userValue == null || userValue.equals("")) && (userVar == null || userVar.equals(""))) {
                msgParams = new String[]{CDMConstraintTypes.USER};
                String msg = s_msgBundle.getMessage("1109", false, msgParams);
                Trace.out((String)msg);
                throw new XmlParserException(msg);
            }
            if (userValue == null) {
                userValue = VerificationUtil.getVariableValue(userVar);
            }
            if (userValue == null) {
                if (!Trace.isLevelEnabled((int)1)) continue;
                Trace.out((String)("Value for variable " + userVar + " returned null, skipping user tag."));
                continue;
            }
            String severity = this.getOptionalAttributeValue(elem, CDMConstraintTypes.SEVERITY);
            cdmUG.addUserConstraint(userValue, severity);
            this.parseGroupTagsForMembership(userValue, cdmUG, elem);
        }
    }

    private void parseGroupTags(CDMUserGroups cdmUG, Element xmlElem) throws XmlParserException {
        NodeList groups = xmlElem.getElementsByTagName(CDMConstraintTypes.GROUP);
        for (int i = 0; i < groups.getLength(); ++i) {
            Element elem = (Element)groups.item(i);
            String groupVar = this.getOptionalAttributeValue(elem, CDMConstraintTypes.VAR);
            String groupValue = this.getOptionalAttributeValue(elem, CDMConstraintTypes.VALUE);
            String active = this.getOptionalAttributeValue(elem, CDMConstraintTypes.ACTIVE);
            String severity = this.getOptionalAttributeValue(elem, CDMConstraintTypes.SEVERITY);
            if (groupValue != null && !groupValue.equals("") && groupVar != null && !groupVar.equals("")) {
                Object[] msgParams = new String[]{CDMConstraintTypes.GROUP};
                String msg = s_msgBundle.getMessage("1109", false, msgParams);
                Trace.out((String)msg);
                throw new XmlParserException(msg);
            }
            if ((groupValue == null || groupValue.equals("")) && (groupVar == null || groupVar.equals(""))) {
                Object[] msgParams = new String[]{CDMConstraintTypes.GROUP};
                String msg = s_msgBundle.getMessage("1109", false, msgParams);
                Trace.out((String)msg);
                throw new XmlParserException(msg);
            }
            if (groupValue == null) {
                groupValue = VerificationUtil.getVariableValue(groupVar);
            }
            if (groupValue == null) {
                if (!Trace.isLevelEnabled((int)1)) continue;
                Trace.out((String)("Value for variable " + groupVar + " returned null, skipping group tag."));
                continue;
            }
            cdmUG.addGroupConstraint(groupValue, active, severity);
        }
    }

    private void parseGroupTagsForMembership(String user, CDMUserGroups cdmUG, Element xmlElem) throws XmlParserException {
        NodeList groups = xmlElem.getElementsByTagName(CDMConstraintTypes.GROUP);
        for (int i = 0; i < groups.getLength(); ++i) {
            Element elem = (Element)groups.item(i);
            String groupVar = this.getOptionalAttributeValue(elem, CDMConstraintTypes.VAR);
            String groupValue = this.getOptionalAttributeValue(elem, CDMConstraintTypes.VALUE);
            String active = this.getOptionalAttributeValue(elem, CDMConstraintTypes.ACTIVE);
            String severity = this.getOptionalAttributeValue(elem, CDMConstraintTypes.SEVERITY);
            if (groupValue != null && !groupValue.equals("") && groupVar != null && !groupVar.equals("")) {
                Object[] msgParams = new String[]{CDMConstraintTypes.GROUP};
                String msg = s_msgBundle.getMessage("1109", false, msgParams);
                Trace.out((String)msg);
                throw new XmlParserException(msg);
            }
            if ((groupValue == null || groupValue.equals("")) && (groupVar == null || groupVar.equals(""))) {
                Object[] msgParams = new String[]{CDMConstraintTypes.GROUP};
                String msg = s_msgBundle.getMessage("1109", false, msgParams);
                Trace.out((String)msg);
                throw new XmlParserException(msg);
            }
            if (groupValue == null) {
                groupValue = VerificationUtil.getVariableValue(groupVar);
            }
            if (groupValue == null) {
                if (!Trace.isLevelEnabled((int)1)) continue;
                Trace.out((String)("Value for variable " + groupVar + " returned null, skipping group tag."));
                continue;
            }
            if ("INSTALL_GROUP".equals(groupVar) && (VerificationUtil.evaluateCondition("CRS") || VerificationUtil.evaluateCondition("HA"))) {
                Trace.out((String)"Setting check for INSTALL_GROUP to be primary in CRS/HA env");
                active = Boolean.toString(true);
            }
            cdmUG.addUserGroupMembership(user, groupValue, active, severity);
        }
    }

    private void parseRunLevelTags(CDMSystem cdmSystem, Element xmlElem) throws XmlParserException {
        NodeList runlevels = xmlElem.getElementsByTagName(CDMConstraintTypes.RUNLEVEL);
        Element elem = null;
        elem = this.checkNumOfElements(runlevels, CDMConstraintTypes.RUNLEVEL);
        if (elem != null) {
            ArrayList<Integer> runLevels;
            String severity = this.getOptionalAttributeValue(elem, CDMConstraintTypes.SEVERITY);
            NodeList runlevelValues = xmlElem.getElementsByTagName(CDMConstraintTypes.VALUE);
            if (runlevelValues.getLength() == 0) {
                runLevels = new ArrayList<Integer>();
                String currentLevel = this.getOptionalAttributeValue(elem, CDMConstraintTypes.CURRENT);
                try {
                    runLevels.add(Integer.parseInt(currentLevel));
                }
                catch (NumberFormatException nfe) {
                    Object[] msgParams = new String[]{currentLevel, CDMConstraintTypes.CURRENT, CDMConstraintTypes.RUNLEVEL};
                    String msg = s_msgBundle.getMessage("1096", false, msgParams);
                    Trace.out((String)msg);
                    throw new XmlParserException(msg, nfe);
                }
            } else {
                String currentLevel = this.getOptionalAttributeValue(elem, CDMConstraintTypes.CURRENT);
                if (currentLevel != null && currentLevel.length() > 0) {
                    Trace.out((String)("Both current=" + currentLevel + " and LIST are defined."));
                    Object[] msgParams = new String[]{CDMConstraintTypes.RUNLEVEL};
                    String msg = s_msgBundle.getMessage("1092", false, msgParams);
                    Trace.out((String)msg);
                    throw new XmlParserException(msg);
                }
                runLevels = new ArrayList(runlevelValues.getLength());
                for (int l = 0; l < runlevelValues.getLength(); ++l) {
                    Element runlevelValueEle = (Element)runlevelValues.item(l);
                    String runLevelStr = runlevelValueEle.getFirstChild().getNodeValue();
                    try {
                        runLevels.add(Integer.parseInt(runLevelStr));
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        Object[] msgParams = new String[]{runLevelStr, CDMConstraintTypes.VALUE, CDMConstraintTypes.RUNLEVEL};
                        String msg = s_msgBundle.getMessage("1096", false, msgParams);
                        Trace.out((String)msg);
                        throw new XmlParserException(msg, nfe);
                    }
                }
            }
            cdmSystem.addRunLevelCheck(runLevels, severity);
        }
    }

    private void parseShellLimitCheckTags(CDMSystem cdmSystem, Element xmlElem) throws XmlParserException {
        NodeList slcList = xmlElem.getElementsByTagName(CDMConstraintTypes.SHELL_LIMIT_CHECKS);
        Element slcElem = null;
        slcElem = this.checkNumOfElements(slcList, CDMConstraintTypes.SHELL_LIMIT_CHECKS);
        if (slcElem != null) {
            CDMShellLimitChecks cdmSlc = new CDMShellLimitChecks();
            NodeList chList = slcElem.getElementsByTagName(CDMConstraintTypes.CHOICE);
            for (int k = 0; k < chList.getLength(); ++k) {
                Element chElem = (Element)chList.item(k);
                String choiceVar = this.getRequiredAttributeValue(chElem, CDMConstraintTypes.VAR);
                String choiceVarValue = VerificationUtil.getVariableValue(choiceVar);
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("Choice Var = " + choiceVar + " Choice Var Value = " + choiceVarValue));
                }
                NodeList selList = chElem.getElementsByTagName(CDMConstraintTypes.SELECTION);
                for (int l = 0; l < selList.getLength(); ++l) {
                    Element selElem = (Element)selList.item(l);
                    String selectionValue = this.getRequiredAttributeValue(selElem, CDMConstraintTypes.VALUE);
                    if (!selectionValue.equalsIgnoreCase(choiceVarValue)) continue;
                    if (Trace.isTraceEnabled()) {
                        Trace.out((String)("Found match for choice variable=" + choiceVar + ". Selection = " + selectionValue));
                    }
                    this.parseFileDescriptorTag(cdmSlc, choiceVar, selElem);
                    this.parseMaxProcTag(cdmSlc, choiceVar, selElem);
                }
            }
            cdmSystem.addCDMShellLimitChecks(cdmSlc);
        }
    }

    private void parseFileDescriptorTag(CDMShellLimitChecks cdmSlc, String shellVar, Element xmlElem) throws XmlParserException {
        NodeList fdList = xmlElem.getElementsByTagName(CDMConstraintTypes.FILE_DESCRIPTORS);
        Element elem = null;
        elem = this.checkNumOfElements(fdList, CDMConstraintTypes.FILE_DESCRIPTORS);
        if (elem != null) {
            String shellSel = this.getRequiredAttributeValue(xmlElem, CDMConstraintTypes.VALUE);
            String limit = null;
            String severity = null;
            Element hlElem = null;
            hlElem = this.checkNumOfElements(elem.getElementsByTagName(CDMConstraintTypes.HARDLIMIT), CDMConstraintTypes.HARDLIMIT);
            if (hlElem != null) {
                limit = this.getRequiredAttributeValue(hlElem, CDMConstraintTypes.VALUE);
                severity = this.getOptionalAttributeValue(hlElem, CDMConstraintTypes.SEVERITY);
                cdmSlc.addFileDescriptorLimit(shellVar, shellSel, "HARD", limit, severity);
            }
            Element slElem = null;
            slElem = this.checkNumOfElements(elem.getElementsByTagName(CDMConstraintTypes.SOFTLIMIT), CDMConstraintTypes.SOFTLIMIT);
            if (slElem != null) {
                limit = this.getRequiredAttributeValue(slElem, CDMConstraintTypes.VALUE);
                severity = this.getOptionalAttributeValue(slElem, CDMConstraintTypes.SEVERITY);
                cdmSlc.addFileDescriptorLimit(shellVar, shellSel, "SOFT", limit, severity);
            }
        }
    }

    private void parseMaxProcTag(CDMShellLimitChecks cdmSlc, String shellVar, Element xmlElem) throws XmlParserException {
        NodeList mpElemList = xmlElem.getElementsByTagName(CDMConstraintTypes.MAXPROC);
        Element elem = null;
        elem = this.checkNumOfElements(mpElemList, CDMConstraintTypes.MAXPROC);
        if (elem != null) {
            String shellSel = this.getRequiredAttributeValue(xmlElem, CDMConstraintTypes.VALUE);
            String limit = null;
            String severity = null;
            Element hlElem = null;
            hlElem = this.checkNumOfElements(elem.getElementsByTagName(CDMConstraintTypes.HARDLIMIT), CDMConstraintTypes.HARDLIMIT);
            if (hlElem != null) {
                limit = this.getRequiredAttributeValue(hlElem, CDMConstraintTypes.VALUE);
                severity = this.getOptionalAttributeValue(hlElem, CDMConstraintTypes.SEVERITY);
                cdmSlc.addMaxProcessLimits(shellVar, shellSel, "HARD", limit, severity);
            }
            Element slElem = null;
            slElem = this.checkNumOfElements(elem.getElementsByTagName(CDMConstraintTypes.SOFTLIMIT), CDMConstraintTypes.SOFTLIMIT);
            if (slElem != null) {
                limit = this.getRequiredAttributeValue(slElem, CDMConstraintTypes.VALUE);
                severity = this.getOptionalAttributeValue(slElem, CDMConstraintTypes.SEVERITY);
                cdmSlc.addMaxProcessLimits(shellVar, shellSel, "SOFT", limit, severity);
            }
        }
    }

    private void parseProcessChecksTags(final CDMSystem cdmSystem, Element xmlElem) throws XmlParserException {
        NodeList pcList = xmlElem.getElementsByTagName(CDMConstraintTypes.PROCESS_CHECKS);
        Element elem = null;
        elem = this.checkNumOfElements(pcList, CDMConstraintTypes.PROCESS_CHECKS);
        if (elem != null) {
            this.parseChildrenConditionally(new NodeVisitorCB(){

                public void handle(Element elem, String conditionVar, String choiceVar, String selection) throws XmlParserException {
                    if (elem.getNodeName().equals(CDMConstraintTypes.PROCESS)) {
                        String processName = XmlParser.this.getRequiredAttributeValue(elem, CDMConstraintTypes.NAME);
                        String processExists = XmlParser.this.getOptionalAttributeValue(elem, CDMConstraintTypes.EXISTS);
                        String severity = XmlParser.this.getOptionalAttributeValue(elem, CDMConstraintTypes.SEVERITY);
                        CDMProcessChecks cdmProcCheck = new CDMProcessChecks();
                        cdmProcCheck.addProcessCheck(processName, processExists, severity);
                        cdmSystem.addCDMProcessChecks(cdmProcCheck);
                    }
                }
            }, elem, null, null, null);
        }
    }

    private void parseCertifiedSystemsTags(CDMHost cdmHost, Element xmlElem) throws XmlParserException {
        NodeList csList = xmlElem.getElementsByTagName(CDMConstraintTypes.CERTIFIED_SYSTEMS);
        Element elem = null;
        elem = this.checkNumOfElements(csList, CDMConstraintTypes.CERTIFIED_SYSTEMS);
        if (elem != null) {
            CDMCertifiedSystems cdmCs = new CDMCertifiedSystems();
            this.parseOperatingSystemTags(cdmCs, elem);
            cdmHost.addCDMCertifiedSystem(cdmCs);
        }
    }

    private void parseOperatingSystemTags(CDMCertifiedSystems cdmCs, Element xmlElem) throws XmlParserException {
        NodeList osList = xmlElem.getElementsByTagName(CDMConstraintTypes.OPERATING_SYSTEM);
        for (int i = 0; i < osList.getLength(); ++i) {
            Element elem = (Element)osList.item(i);
            CDMOperatingSystem cdmOS = new CDMOperatingSystem();
            String osRel = this.getRequiredAttributeValue(elem, CDMConstraintTypes.RELEASE);
            String ver = this.parseVersionTags(elem);
            String kname = this.parseNameTags(elem);
            String kvend = this.parseVendorTags(elem);
            String kver = this.parseKernelVerTags(elem);
            cdmOS.setAttributes(osRel, ver, kname, kvend, kver);
            this.parseArchitectureTags(cdmOS, elem);
            this.parseOSPatchCheckTags(cdmOS, elem);
            this.parseKernelTags(cdmOS, elem);
            this.parsePackagesTags(cdmOS, elem);
            this.parseSystemFilesTags(cdmOS, elem);
            this.parseEnvVarListTags(cdmOS, elem);
            cdmCs.addCDMOS(osRel, cdmOS);
        }
    }

    private String parseVersionTags(Element xmlElem) throws XmlParserException {
        NodeList versionList = xmlElem.getElementsByTagName(CDMConstraintTypes.VERSION);
        String ver = null;
        Element elem = null;
        elem = this.checkNumOfElements(versionList, CDMConstraintTypes.VERSION);
        if (elem != null) {
            ver = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VALUE);
        }
        return ver;
    }

    private void parseArchitectureTags(CDMOperatingSystem cdmOS, Element xmlElem) throws XmlParserException {
        NodeList archList = xmlElem.getElementsByTagName(CDMConstraintTypes.ARCHITECTURE);
        String archStr = null;
        Element elem = null;
        elem = this.checkNumOfElements(archList, CDMConstraintTypes.ARCHITECTURE);
        if (elem != null) {
            ArrayList<String> runLevels;
            String severity = this.getOptionalAttributeValue(elem, CDMConstraintTypes.SEVERITY);
            NodeList archValues = xmlElem.getElementsByTagName(CDMConstraintTypes.VALUE);
            if (archValues.getLength() == 0) {
                runLevels = new ArrayList<String>();
                archStr = this.getOptionalAttributeValue(elem, CDMConstraintTypes.VALUE);
                runLevels.add(archStr);
            } else {
                archStr = this.getOptionalAttributeValue(elem, CDMConstraintTypes.VALUE);
                if (archStr != null && archStr.length() > 0) {
                    Trace.out((String)("Both current=" + archStr + " and LIST are defined."));
                    Object[] msgParams = new String[]{CDMConstraintTypes.ARCHITECTURE};
                    String msg = s_msgBundle.getMessage("1092", false, msgParams);
                    Trace.out((String)msg);
                    throw new XmlParserException(msg);
                }
                runLevels = new ArrayList(archValues.getLength());
                for (int l = 0; l < archValues.getLength(); ++l) {
                    Element runlevelValueEle = (Element)archValues.item(l);
                    archStr = runlevelValueEle.getFirstChild().getNodeValue();
                    runLevels.add(archStr);
                }
            }
            cdmOS.addArchitectureValues(runLevels, severity);
        }
    }

    private void parseOSPatchCheckTags(final CDMOperatingSystem cdmOS, Element xmlElem) throws XmlParserException {
        NodeList osPatchList = xmlElem.getElementsByTagName(CDMConstraintTypes.OSPATCH_CHECKS);
        Element OSChecksElem = null;
        OSChecksElem = this.checkNumOfElements(osPatchList, CDMConstraintTypes.OSPATCH_CHECKS);
        if (OSChecksElem != null) {
            this.parseChildrenConditionally(new NodeVisitorCB(){

                public void handle(Element elem, String conditionVar, String choiceVar, String selection) throws XmlParserException {
                    if (elem.getNodeName().equals(CDMConstraintTypes.OSPATCH)) {
                        XmlParser.this.parseOSPatchTags(cdmOS, elem, conditionVar, choiceVar, selection);
                    }
                }
            }, OSChecksElem, null, null, null);
        }
    }

    private void parseOSPatchTags(CDMOperatingSystem cdmOS, Element elem, String condition, String choice, String selValue) throws XmlParserException {
        String sVal = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VALUE);
        String severity = this.getOptionalAttributeValue(elem, CDMConstraintTypes.SEVERITY);
        if (sVal == null) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("Value for variable " + CDMConstraintTypes.OSPATCH + " returned null, skipping patch tag."));
            }
            return;
        }
        cdmOS.addOSPatch(sVal, severity);
    }

    private String parseNameTags(Element xmlElem) throws XmlParserException {
        NodeList nameList = xmlElem.getElementsByTagName(CDMConstraintTypes.NAME);
        String nameStr = null;
        Element elem = null;
        elem = this.checkNumOfElements(nameList, CDMConstraintTypes.NAME);
        if (elem != null) {
            nameStr = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VALUE);
        }
        return nameStr;
    }

    private String parseVendorTags(Element xmlElem) throws XmlParserException {
        NodeList vendorList = xmlElem.getElementsByTagName(CDMConstraintTypes.VENDOR);
        String vendorStr = null;
        Element elem = null;
        elem = this.checkNumOfElements(vendorList, CDMConstraintTypes.VENDOR);
        if (elem != null) {
            vendorStr = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VALUE);
        }
        return vendorStr;
    }

    private String parseKernelVerTags(Element xmlElem) throws XmlParserException {
        NodeList kernelVerList = xmlElem.getElementsByTagName(CDMConstraintTypes.KERNEL_VER);
        String kver = null;
        Element elem = null;
        elem = this.checkNumOfElements(kernelVerList, CDMConstraintTypes.KERNEL);
        if (elem != null) {
            kver = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VALUE);
        }
        return kver;
    }

    private void parseEnvVarListTags(CDMOperatingSystem cdmOS, Element xmlElem) throws XmlParserException {
        NodeList envList = xmlElem.getElementsByTagName(CDMConstraintTypes.ENV_VAR_LIST);
        Element envVarElem = null;
        envVarElem = this.checkNumOfElements(envList, CDMConstraintTypes.ENV_VAR_LIST);
        if (envVarElem != null) {
            NodeList envVar = envVarElem.getElementsByTagName(CDMConstraintTypes.ENV_VAR);
            for (int i = 0; i < envVar.getLength(); ++i) {
                Element elem = (Element)envVar.item(i);
                String name = this.getRequiredAttributeValue(elem, CDMConstraintTypes.ENV_VAR_NAME);
                String maxLength = this.getOptionalAttributeValue(elem, CDMConstraintTypes.MAX_LENGTH);
                String set = this.getOptionalAttributeValue(elem, CDMConstraintTypes.SET);
                if (!(maxLength != null && maxLength.trim().length() != 0 || set != null && set.trim().length() != 0)) {
                    String msg = s_msgBundle.getMessage("1109", false, (Object[])new String[]{elem.getTagName()});
                    Trace.out((String)msg);
                    throw new XmlParserException(msg);
                }
                if (name == null || name.length() <= 0) {
                    Object[] msgParams = new String[]{elem.getTagName(), CDMConstraintTypes.ENV_VAR_NAME};
                    String msg = s_msgBundle.getMessage("1103", false, msgParams);
                    Trace.out((String)msg);
                    throw new XmlParserException(msg);
                }
                cdmOS.addEnvVariable(name, maxLength, set);
            }
        }
    }

    private void parseKernelTags(final CDMOperatingSystem cdmOS, Element xmlElem) throws XmlParserException {
        NodeList kernelList = xmlElem.getElementsByTagName(CDMConstraintTypes.KERNEL);
        Element elem = null;
        elem = this.checkNumOfElements(kernelList, CDMConstraintTypes.KERNEL);
        if (elem != null) {
            this.parseChildrenConditionally(new NodeVisitorCB(){

                public void handle(Element elem, String conditionVar, String choiceVar, String selection) throws XmlParserException {
                    if (elem.getNodeName().equals(CDMConstraintTypes.PROPERTY)) {
                        String name = XmlParser.this.getRequiredAttributeValue(elem, CDMConstraintTypes.NAME);
                        String severity = XmlParser.this.getOptionalAttributeValue(elem, CDMConstraintTypes.SEVERITY);
                        if (elem.getElementsByTagName(CDMConstraintTypes.STEP).getLength() > 0) {
                            XmlParser.this.parseKernelParamStepTags(cdmOS, elem, name, severity);
                        } else {
                            String name2 = elem.getAttribute(CDMConstraintTypes.NAME2);
                            String value = XmlParser.this.getOptionalAttributeValue(elem, CDMConstraintTypes.VALUE);
                            String atleast = XmlParser.this.getOptionalAttributeValue(elem, CDMConstraintTypes.ATLEAST);
                            String atmost = XmlParser.this.getOptionalAttributeValue(elem, CDMConstraintTypes.ATMOST);
                            String gthan = XmlParser.this.getOptionalAttributeValue(elem, CDMConstraintTypes.GREATER_THAN);
                            String lthan = XmlParser.this.getOptionalAttributeValue(elem, CDMConstraintTypes.LESS_THAN);
                            if (value == null && atleast == null && atmost == null && gthan == null && lthan == null) {
                                String msg = s_msgBundle.getMessage("1112", false);
                                Trace.out((String)msg);
                                throw new XmlParserException(msg);
                            }
                            cdmOS.addKernelProperty(name, name2, value, atleast, atmost, gthan, lthan, severity);
                        }
                    }
                }
            }, elem, null, null, null);
        }
    }

    private void parseKernelParamStepTags(CDMOperatingSystem cdmOS, Element xmlElem, String paramName, String severity) throws XmlParserException {
        NodeList steps = xmlElem.getElementsByTagName(CDMConstraintTypes.STEP);
        for (int i = 0; i < steps.getLength(); ++i) {
            Element elem = (Element)steps.item(i);
            String name = this.getRequiredAttributeValue(elem, CDMConstraintTypes.NAME);
            String value = this.getOptionalAttributeValue(elem, CDMConstraintTypes.VALUE);
            String gthan = this.getOptionalAttributeValue(elem, CDMConstraintTypes.GREATER_THAN);
            String lthan = this.getOptionalAttributeValue(elem, CDMConstraintTypes.LESS_THAN);
            String atLeast = this.getOptionalAttributeValue(elem, CDMConstraintTypes.ATLEAST);
            String atMost = this.getOptionalAttributeValue(elem, CDMConstraintTypes.ATMOST);
            String units = this.getOptionalAttributeValue(elem, CDMConstraintTypes.UNIT);
            String multpl = this.getOptionalAttributeValue(elem, CDMConstraintTypes.MULTIPLE);
            cdmOS.addKernelPropertySizeStep(paramName, name, value, gthan, atLeast, lthan, atMost, units, multpl, severity);
        }
    }

    private void parsePropertyTags(Element xmlElem) {
        NodeList propertyList = xmlElem.getElementsByTagName(CDMConstraintTypes.PROPERTY);
        for (int i = 0; i < propertyList.getLength(); ++i) {
            Element elem = (Element)propertyList.item(i);
        }
    }

    private void parsePackagesTags(final CDMOperatingSystem cdmOS, Element xmlElem) throws XmlParserException {
        NodeList packageList = xmlElem.getElementsByTagName(CDMConstraintTypes.PACKAGES);
        Element pelem = null;
        pelem = this.checkNumOfElements(packageList, CDMConstraintTypes.PACKAGES);
        if (pelem != null) {
            this.parseChildrenConditionally(new NodeVisitorCB(){

                public void handle(Element elem, String conditionVar, String choiceVar, String selection) throws XmlParserException {
                    if (elem.getNodeName().equals(CDMConstraintTypes.PACKAGE)) {
                        XmlParser.this.parsePackageTags(cdmOS, elem, conditionVar, choiceVar, selection);
                    }
                }
            }, pelem, null, null, null);
        }
    }

    private void parsePackageTags(CDMOperatingSystem cdmOS, Element elem, String condition, String choice, String selValue) throws XmlParserException {
        String pkgName = this.getOptionalAttributeValue(elem, CDMConstraintTypes.NAME);
        String pkgVar = this.getOptionalAttributeValue(elem, CDMConstraintTypes.VAR);
        if (pkgName != null && pkgVar != null) {
            Trace.out((String)("Both pkgName=" + pkgName + " and pkgVar=" + pkgVar + " are defined."));
            Object[] msgParams = new String[]{CDMConstraintTypes.PACKAGE};
            String msg = s_msgBundle.getMessage("1109", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        if (pkgName == null && pkgVar == null) {
            Trace.out((String)"Neither pkgName nor pkgVar are defined.");
            Object[] msgParams = new String[]{CDMConstraintTypes.PACKAGE};
            String msg = s_msgBundle.getMessage("1109", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        String absolutePkgName = pkgName;
        if (absolutePkgName == null && (absolutePkgName = VerificationUtil.getVariableValue(pkgVar)) == null) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("Value for variable " + pkgVar + " returned null, skipping package tag."));
            }
            return;
        }
        String pkgValue = this.getOptionalAttributeValue(elem, CDMConstraintTypes.VALUE);
        String severity = this.getOptionalAttributeValue(elem, CDMConstraintTypes.SEVERITY);
        String architecture = this.getOptionalAttributeValue(elem, CDMConstraintTypes.ARCHITECTURE);
        NodeList rangeNodes = elem.getElementsByTagName(CDMConstraintTypes.RANGE);
        if (pkgValue != null) {
            if (rangeNodes.getLength() > 0) {
                Object[] msgParams = new String[]{CDMConstraintTypes.PACKAGE};
                String msg = s_msgBundle.getMessage("1109", false, msgParams);
                Trace.out((String)msg);
                throw new XmlParserException(msg);
            }
            cdmOS.addPackageValueCriteria(absolutePkgName, pkgValue, severity, architecture);
        } else if (rangeNodes.getLength() > 0) {
            try {
                RangeOfValue rangeOfVal = new RangeOfValue(RangeType.VERSION);
                this.parseRangeTags(cdmOS, absolutePkgName, elem, rangeOfVal);
                cdmOS.addPackageRangeCriteria(pkgName, rangeOfVal, severity, architecture);
            }
            catch (InvalidRangeManipulationException e) {
                Trace.out((Exception)e);
                throw new XmlParserException(e.getMessage());
            }
        } else {
            String msg = s_msgBundle.getMessage("1112", false);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
    }

    private void parseRangeTags(CDMOperatingSystem cdmOS, String pkgName, Element xmlElem, RangeOfValue rangeOfVal) throws XmlParserException, InvalidRangeManipulationException {
        NodeList rangeList = xmlElem.getElementsByTagName(CDMConstraintTypes.RANGE);
        for (int i = 0; i < rangeList.getLength(); ++i) {
            Element rangeElem = (Element)rangeList.item(i);
            String atleast = this.getOptionalAttributeValue(rangeElem, CDMConstraintTypes.ATLEAST);
            String atmost = this.getOptionalAttributeValue(rangeElem, CDMConstraintTypes.ATMOST);
            String gthan = this.getOptionalAttributeValue(rangeElem, CDMConstraintTypes.GREATER_THAN);
            String lthan = this.getOptionalAttributeValue(rangeElem, CDMConstraintTypes.LESS_THAN);
            if (atleast == null && atmost == null && gthan == null && lthan == null) {
                String msg = s_msgBundle.getMessage("1112", false);
                Trace.out((String)msg);
                throw new XmlParserException(msg);
            }
            this.manipulateRange(rangeOfVal, null, atleast, atmost, gthan, lthan, false);
            this.parseExcludeTags(cdmOS, pkgName, rangeElem, rangeOfVal);
        }
    }

    private void parseExcludeTags(CDMOperatingSystem cdmOS, String pkgName, Element xmlElem, RangeOfValue rangeOfVal) throws XmlParserException, InvalidRangeManipulationException {
        NodeList excludeList = xmlElem.getElementsByTagName(CDMConstraintTypes.EXCLUDE);
        for (int i = 0; i < excludeList.getLength(); ++i) {
            Element elem = (Element)excludeList.item(i);
            String value = this.getOptionalAttributeValue(elem, CDMConstraintTypes.VALUE);
            String atleast = this.getOptionalAttributeValue(elem, CDMConstraintTypes.ATLEAST);
            String atmost = this.getOptionalAttributeValue(elem, CDMConstraintTypes.ATMOST);
            String gthan = this.getOptionalAttributeValue(elem, CDMConstraintTypes.GREATER_THAN);
            String lthan = this.getOptionalAttributeValue(elem, CDMConstraintTypes.LESS_THAN);
            if (value == null && atleast == null && atmost == null && gthan == null && lthan == null) {
                String msg = s_msgBundle.getMessage("1112", false);
                Trace.out((String)msg);
                throw new XmlParserException(msg);
            }
            this.manipulateRange(rangeOfVal, value, atleast, atmost, gthan, lthan, true);
        }
    }

    private void manipulateRange(RangeOfValue r, Object value, Object atleast, Object atmost, Object gthan, Object lthan, boolean exclude) throws XmlParserException, InvalidRangeManipulationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("RangeOfValue = " + r + ", value = " + value + ", atleast = " + atleast + ", atmost = " + atmost + ", gthan = " + gthan + ", lthan = " + lthan + ", exclude = " + exclude));
        }
        if (value == null && atleast == null && atmost == null && gthan == null && lthan == null) {
            String msg = s_msgBundle.getMessage("1112", false);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        if (value != null && (atleast != null || atmost != null || gthan != null || lthan != null)) {
            String msg = s_msgBundle.getMessage("1113", false);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        if (value != null) {
            try {
                if (!exclude) {
                    r.include(RangeOperator.EQ, value);
                } else {
                    r.exclude(RangeOperator.EQ, value);
                }
                return;
            }
            catch (InvalidRangeManipulationException e) {
                new XmlParserException(e.getMessage(), e);
            }
        }
        if (atleast != null && gthan != null) {
            Object[] msgParams = new String[]{RangeOperator.GE.toString(), RangeOperator.GT.toString()};
            String msg = s_msgBundle.getMessage("1114", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        if (atmost != null && lthan != null) {
            Object[] msgParams = new String[]{RangeOperator.LE.toString(), RangeOperator.LT.toString()};
            String msg = s_msgBundle.getMessage("1114", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        RangeOperator firstRangeOp = null;
        Object firstRangeValue = null;
        RangeOperator secondRangeOp = null;
        Object secondRangeValue = null;
        if (atleast != null) {
            firstRangeOp = this.getRangeOperator(CDMConstraintTypes.ATLEAST);
            firstRangeValue = atleast;
        } else if (gthan != null) {
            firstRangeOp = this.getRangeOperator(CDMConstraintTypes.GREATER_THAN);
            firstRangeValue = gthan;
        }
        if (atmost != null) {
            if (firstRangeOp != null) {
                secondRangeOp = this.getRangeOperator(CDMConstraintTypes.ATMOST);
                secondRangeValue = atmost;
            } else {
                firstRangeOp = this.getRangeOperator(CDMConstraintTypes.ATMOST);
                firstRangeValue = atmost;
            }
        } else if (lthan != null) {
            if (firstRangeOp != null) {
                secondRangeOp = this.getRangeOperator(CDMConstraintTypes.LESS_THAN);
                secondRangeValue = lthan;
            } else {
                firstRangeOp = this.getRangeOperator(CDMConstraintTypes.LESS_THAN);
                firstRangeValue = lthan;
            }
        }
        if (!exclude) {
            if (secondRangeOp != null) {
                r.include(firstRangeOp, firstRangeValue, secondRangeOp, secondRangeValue);
            } else {
                r.include(firstRangeOp, firstRangeValue);
            }
        } else if (secondRangeOp != null) {
            r.exclude(firstRangeOp, firstRangeValue, secondRangeOp, secondRangeValue);
        } else {
            r.exclude(firstRangeOp, firstRangeValue);
        }
    }

    private RangeOperator getRangeOperator(String op) throws XmlParserException {
        if (op == null) {
            Object[] msgParams = new String[]{"null"};
            String msg = s_msgBundle.getMessage("1107", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        if (op.equals(CDMConstraintTypes.VALUE)) {
            return RangeOperator.EQ;
        }
        if (op.equals(CDMConstraintTypes.ATLEAST)) {
            return RangeOperator.GE;
        }
        if (op.equals(CDMConstraintTypes.ATMOST)) {
            return RangeOperator.LE;
        }
        if (op.equals(CDMConstraintTypes.GREATER_THAN)) {
            return RangeOperator.GT;
        }
        if (op.equals(CDMConstraintTypes.LESS_THAN)) {
            return RangeOperator.LT;
        }
        Object[] msgParams = new String[]{op};
        String msg = s_msgBundle.getMessage("1107", false, msgParams);
        Trace.out((String)msg);
        throw new XmlParserException(msg);
    }

    private void parseSystemFilesTags(CDMOperatingSystem cdmOS, Element xmlElem) throws XmlParserException {
        NodeList sfList = xmlElem.getElementsByTagName(CDMConstraintTypes.SYSTEM_FILES);
        Element elem = null;
        elem = this.checkNumOfElements(sfList, CDMConstraintTypes.SYSTEM_FILES);
        if (elem != null) {
            this.parseDhcpTags(cdmOS, elem);
        }
    }

    private void parseDhcpTags(CDMOperatingSystem cdmOS, Element xmlElem) throws XmlParserException {
        NodeList dhcpList = xmlElem.getElementsByTagName(CDMConstraintTypes.DHCP);
        Element elem = null;
        elem = this.checkNumOfElements(dhcpList, CDMConstraintTypes.DHCP);
        if (elem != null) {
            String fname = this.getRequiredAttributeValue(elem, CDMConstraintTypes.FILENAME);
            cdmOS.addSystemFile(CDMOperatingSystem.DHCP, fname);
        }
    }

    private void parseReferenceDevicesTags(CDMHost cdmHost, Element xmlElem) throws XmlParserException {
        NodeList rdList = xmlElem.getElementsByTagName(CDMConstraintTypes.REFERENCE_DEVICES);
        Element elem = null;
        elem = this.checkNumOfElements(rdList, CDMConstraintTypes.REFERENCE_DEVICES);
        if (elem != null) {
            CDMReferenceDevices cdmRD = new CDMReferenceDevices();
            this.parseDeviceTags(cdmRD, elem);
            this.parseMountParamsTags(cdmRD, elem);
            this.parseRedundantLocsTags(cdmRD, elem);
            cdmHost.addCDMReferenceDevices(cdmRD);
        }
    }

    private void parseDeviceTags(CDMReferenceDevices cdmRD, Element xmlElem) throws XmlParserException {
        NodeList deviceList = xmlElem.getElementsByTagName(CDMConstraintTypes.DEVICE);
        Element elem = null;
        elem = this.checkNumOfElements(deviceList, CDMConstraintTypes.DEVICE);
        if (elem != null) {
            String deviceVar = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VAR);
            cdmRD.addDevice(deviceVar);
        }
    }

    private void parseMountParamsTags(CDMReferenceDevices cdmRD, Element xmlElem) throws XmlParserException {
        NodeList mpList = xmlElem.getElementsByTagName(CDMConstraintTypes.MOUNT_PARAMS);
        for (int i = 0; i < mpList.getLength(); ++i) {
            Element elem = (Element)mpList.item(i);
            String name = this.getRequiredAttributeValue(elem, CDMConstraintTypes.NAME);
            String value = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VALUE);
            cdmRD.addMountParameters(name, value);
        }
    }

    private void parseRedundantLocsTags(CDMReferenceDevices cdmRD, Element xmlElem) throws XmlParserException {
        NodeList rlList = xmlElem.getElementsByTagName(CDMConstraintTypes.REDUNDANT_LOCS);
        for (int i = 0; i < rlList.getLength(); ++i) {
            Element elem = (Element)rlList.item(i);
            String rlVar = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VAR);
            cdmRD.addRedundantLocs(rlVar);
        }
    }

    private void parseScriptsTags(CDMHost cdmHost, Element xmlElem) throws XmlParserException {
        NodeList scriptsList = xmlElem.getElementsByTagName(CDMConstraintTypes.SCRIPTS);
        Element elem = null;
        elem = this.checkNumOfElements(scriptsList, CDMConstraintTypes.SCRIPTS);
        if (elem != null) {
            this.parseScriptTags(cdmHost, elem);
        }
    }

    private void parseScriptTags(CDMHost cdmHost, Element xmlElem) throws XmlParserException {
        NodeList scriptList = xmlElem.getElementsByTagName(CDMConstraintTypes.SCRIPT);
        for (int i = 0; i < scriptList.getLength(); ++i) {
            Element elem = (Element)scriptList.item(i);
            String sc = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VAR);
            cdmHost.addScriptConstraint(sc);
        }
    }

    private void parseUserInputsTags(CDMHost cdmHost, Element xmlElem) throws XmlParserException {
        NodeList uiList = xmlElem.getElementsByTagName(CDMConstraintTypes.USER_INPUTS);
        Element elem = null;
        elem = this.checkNumOfElements(uiList, CDMConstraintTypes.USER_INPUTS);
        if (elem != null) {
            CDMUserInputs cdmUI = new CDMUserInputs();
            String cname = this.parseClusternameTags(elem);
            String sidvar = this.parseSidTags(elem);
            String iuvar = this.parseInstallUserTags(elem);
            cdmUI.setAttributes(cname, sidvar, iuvar);
            NodeList locslist = elem.getElementsByTagName(CDMConstraintTypes.LOCS);
            Element locselem = null;
            locselem = this.checkNumOfElements(locslist, CDMConstraintTypes.LOCS);
            if (locselem != null) {
                this.parseUserInputLocTags(cdmUI, locselem);
                NodeList condlist = locselem.getElementsByTagName(CDMConstraintTypes.CONDITION);
                for (int j = 0; j < condlist.getLength(); ++j) {
                    Element celem = (Element)condlist.item(j);
                    this.parseUserInputLocTags(cdmUI, celem);
                }
            }
            cdmHost.addCDMUserInput(cdmUI);
        }
    }

    private void parseUserInputLocTags(CDMUserInputs cdmUI, Element xmlElem) {
        NodeList loclist = xmlElem.getElementsByTagName(CDMConstraintTypes.LOC);
        String condVar = this.getOptionalAttributeValue(xmlElem, CDMConstraintTypes.CONDITION);
        for (int i = 0; i < loclist.getLength(); ++i) {
            Element loc = (Element)loclist.item(i);
            String locVar = loc.getAttribute(CDMConstraintTypes.VAR);
            if (!VerificationUtil.evaluateCondition(condVar)) continue;
            cdmUI.addLocation(condVar, locVar);
        }
    }

    private String parseClusternameTags(Element xmlElem) throws XmlParserException {
        NodeList cnList = xmlElem.getElementsByTagName(CDMConstraintTypes.CLUSTERNAME);
        String cname = null;
        Element elem = null;
        elem = this.checkNumOfElements(cnList, CDMConstraintTypes.CLUSTERNAME);
        if (elem != null) {
            cname = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VAR);
        }
        return cname;
    }

    private String parseSidTags(Element xmlElem) throws XmlParserException {
        NodeList sidList = xmlElem.getElementsByTagName(CDMConstraintTypes.SID);
        String sidVar = null;
        Element elem = null;
        elem = this.checkNumOfElements(sidList, CDMConstraintTypes.SID);
        if (elem != null) {
            sidVar = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VAR);
        }
        return sidVar;
    }

    private String parseInstallUserTags(Element xmlElem) throws XmlParserException {
        NodeList iuList = xmlElem.getElementsByTagName(CDMConstraintTypes.INSTALL_USER);
        String iuVar = null;
        Element elem = null;
        elem = this.checkNumOfElements(iuList, CDMConstraintTypes.INSTALL_USER);
        if (elem != null) {
            iuVar = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VAR);
        }
        return iuVar;
    }

    private void parseDirsTags(CDMHost cdmHost, Element xmlElem) throws XmlParserException {
        NodeList dirsList = xmlElem.getElementsByTagName(CDMConstraintTypes.DIRS);
        Element elem = null;
        elem = this.checkNumOfElements(dirsList, CDMConstraintTypes.DIRS);
        if (elem != null) {
            this.parseDirTags(cdmHost, elem);
        }
    }

    private void parseDirTags(CDMHost cdmHost, Element xmlElem) throws XmlParserException {
        NodeList dirList = xmlElem.getElementsByTagName(CDMConstraintTypes.DIR);
        Element elem = null;
        elem = this.checkNumOfElements(dirList, CDMConstraintTypes.DIR);
        if (elem != null) {
            String dirVar = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VAR);
            String dirWriteable = this.getRequiredAttributeValue(elem, CDMConstraintTypes.WRITABLE);
            cdmHost.addDirectory(dirVar, dirWriteable);
        }
    }

    private void parseNetworkTags(CDMHost cdmHost, Element xmlElem) throws XmlParserException {
        NodeList network = xmlElem.getElementsByTagName(CDMConstraintTypes.NETWORK);
        Element elem = null;
        elem = this.checkNumOfElements(network, CDMConstraintTypes.NETWORK);
        if (elem != null) {
            this.parseNodelistTags(cdmHost, elem);
            this.parseInterconnectsTags(cdmHost, elem);
        }
    }

    private void parseNodelistTags(CDMHost cdmHost, Element xmlElem) throws XmlParserException {
        NodeList nlList = xmlElem.getElementsByTagName(CDMConstraintTypes.NODELIST);
        Element elem = null;
        elem = this.checkNumOfElements(nlList, CDMConstraintTypes.NODELIST);
        if (elem != null) {
            this.parseNodeTags(cdmHost, elem);
        }
    }

    private void parseNodeTags(CDMHost cdmHost, Element xmlElem) throws XmlParserException {
        NodeList nList = xmlElem.getElementsByTagName(CDMConstraintTypes.NODE);
        for (int i = 0; i < nList.getLength(); ++i) {
            Element elem = (Element)nList.item(i);
            String name = this.getRequiredAttributeValue(elem, CDMConstraintTypes.NAME);
            String type = this.getRequiredAttributeValue(elem, CDMConstraintTypes.TYPE);
            String var = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VAR);
            String ip_var = this.getRequiredAttributeValue(elem, CDMConstraintTypes.IP_VAR);
            cdmHost.addNetworkNode(name, type, var, ip_var);
        }
    }

    private void parseInterconnectsTags(CDMHost cdmHost, Element xmlElem) throws XmlParserException {
        NodeList interconnectsList = xmlElem.getElementsByTagName(CDMConstraintTypes.INTERCONNECTS);
        Element elem = null;
        elem = this.checkNumOfElements(interconnectsList, CDMConstraintTypes.INTERCONNECTS);
        if (elem != null) {
            String var = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VAR);
            cdmHost.addInterconnect(var);
        }
    }

    private void parseOracleHomeTags(CDMHost cdmHost, Element xmlElem) throws XmlParserException {
        NodeList ohList = xmlElem.getElementsByTagName(CDMConstraintTypes.ORACLE_HOME);
        Element elem = null;
        elem = this.checkNumOfElements(ohList, CDMConstraintTypes.ORACLE_HOME);
        if (elem != null) {
            CDMOracleHome cdmOH = new CDMOracleHome();
            this.parseHomesTags(cdmOH, elem);
            this.parseExistenceMatrixTags(cdmOH, elem);
            cdmHost.addCDMOracleHome(cdmOH);
        }
    }

    private void parseHomesTags(CDMOracleHome cdmOH, Element xmlElem) throws XmlParserException {
        NodeList homesList = xmlElem.getElementsByTagName(CDMConstraintTypes.HOMES);
        Element elem = null;
        elem = this.checkNumOfElements(homesList, CDMConstraintTypes.HOMES);
        if (elem != null) {
            this.parseHomeTags(cdmOH, elem);
        }
    }

    private void parseHomeTags(CDMOracleHome cdmOH, Element xmlElem) throws XmlParserException {
        NodeList homeList = xmlElem.getElementsByTagName(CDMConstraintTypes.HOME);
        for (int i = 0; i < homeList.getLength(); ++i) {
            Element elem = (Element)homeList.item(i);
            String homeLoc = this.parseHomeLocTags(elem);
            String homeName = this.parseHomeNameTags(elem);
            cdmOH.addOracleHome(homeLoc, homeName);
            this.parseCompatibilityMatrixTags(cdmOH, elem);
        }
    }

    private String parseHomeLocTags(Element xmlElem) throws XmlParserException {
        NodeList hlList = xmlElem.getElementsByTagName(CDMConstraintTypes.HOME_LOC);
        String hlLoc = null;
        Element elem = null;
        elem = this.checkNumOfElements(hlList, CDMConstraintTypes.HOME_LOC);
        if (elem != null) {
            hlLoc = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VAR);
        }
        return hlLoc;
    }

    private String parseHomeNameTags(Element xmlElem) throws XmlParserException {
        NodeList hnList = xmlElem.getElementsByTagName(CDMConstraintTypes.HOME_NAME);
        String hnName = null;
        Element elem = null;
        elem = this.checkNumOfElements(hnList, CDMConstraintTypes.HOME_NAME);
        if (elem != null) {
            hnName = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VAR);
        }
        return hnName;
    }

    private void parseCompatibilityMatrixTags(CDMOracleHome cdmOH, Element xmlElem) throws XmlParserException {
        NodeList cmList = xmlElem.getElementsByTagName(CDMConstraintTypes.COMPATIBILITY_MATRIX);
        Element elem = null;
        elem = this.checkNumOfElements(cmList, CDMConstraintTypes.COMPATIBILITY_MATRIX);
        if (elem != null) {
            this.parseAllowTags(cdmOH, elem);
            this.parseDisallowTags(cdmOH, elem);
        }
    }

    private void parseExistenceMatrixTags(CDMOracleHome cdmOH, Element xmlElem) throws XmlParserException {
        NodeList emList = xmlElem.getElementsByTagName(CDMConstraintTypes.EXISTENCE_MATRIX);
        Element elem = null;
        elem = this.checkNumOfElements(emList, CDMConstraintTypes.EXISTENCE_MATRIX);
        if (elem != null) {
            this.parseCompTags(cdmOH, CDMConstraintTypes.EXISTENCE_MATRIX, elem);
        }
    }

    private void parseAllowTags(CDMOracleHome cdmOH, Element xmlElem) throws XmlParserException {
        NodeList allowList = xmlElem.getElementsByTagName(CDMConstraintTypes.ALLOW);
        Element elem = null;
        elem = this.checkNumOfElements(allowList, CDMConstraintTypes.ALLOW);
        if (elem != null) {
            this.parseCompTags(cdmOH, CDMConstraintTypes.ALLOW, elem);
        }
    }

    private void parseDisallowTags(CDMOracleHome cdmOH, Element xmlElem) throws XmlParserException {
        NodeList disallowList = xmlElem.getElementsByTagName(CDMConstraintTypes.DISALLOW);
        Element elem = null;
        elem = this.checkNumOfElements(disallowList, CDMConstraintTypes.DISALLOW);
        if (elem != null) {
            this.parseCompTags(cdmOH, CDMConstraintTypes.DISALLOW, elem);
        }
    }

    private void parseCompTags(CDMOracleHome cdmOH, String type, Element xmlElem) throws XmlParserException {
        NodeList compList = xmlElem.getElementsByTagName(CDMConstraintTypes.COMP);
        for (int i = 0; i < compList.getLength(); ++i) {
            Element elem = (Element)compList.item(i);
            String name = this.getRequiredAttributeValue(elem, CDMConstraintTypes.NAME);
            String atleast = this.getRequiredAttributeValue(elem, CDMConstraintTypes.ATLEAST);
            String atmost = this.getOptionalAttributeValue(elem, CDMConstraintTypes.ATMOST);
            if (type.equals(CDMConstraintTypes.ALLOW)) {
                cdmOH.addToAllowedComponents(name, atleast, atmost);
                continue;
            }
            if (type.equals(CDMConstraintTypes.DISALLOW)) {
                cdmOH.addToDisallowedComponents(name, atleast, atmost);
                continue;
            }
            if (!type.equals(CDMConstraintTypes.EXISTENCE_MATRIX)) continue;
            String desc = this.getOptionalAttributeValue(elem, CDMConstraintTypes.DESC);
            String exists = this.getOptionalAttributeValue(elem, CDMConstraintTypes.EXISTS);
            cdmOH.addToExistenceMatrix(name, desc, exists, atleast, atmost);
        }
    }

    private String getRequiredAttributeValue(Element elem, String key) throws XmlParserException {
        if (!elem.hasAttribute(key)) {
            Object[] msgParams = new String[]{elem.getTagName(), key};
            String msg = s_msgBundle.getMessage("1103", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        String value = elem.getAttribute(key);
        return value;
    }

    private String getOptionalAttributeValue(Element elem, String key) {
        String attributeValue = null;
        if (elem.hasAttribute(key)) {
            attributeValue = elem.getAttribute(key);
        }
        return attributeValue;
    }

    private Element checkNumOfElements(NodeList elems, String elemName) throws XmlParserException {
        if (elems == null || elems.getLength() == 0) {
            return null;
        }
        if (elems.getLength() != 1) {
            Object[] msgParams = new String[]{elemName};
            String msg = s_msgBundle.getMessage("1102", false, msgParams);
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        return (Element)elems.item(0);
    }

    private void parseChildrenConditionally(NodeVisitorCB visitorCallback, Element xmlElem, String conditionVar, String choiceVar, String selection) throws XmlParserException {
        NodeList nodeList = xmlElem.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node childNode = nodeList.item(i);
            if (childNode.getNodeType() != 1) continue;
            Element elem = (Element)nodeList.item(i);
            if (elem.getNodeName().equals(CDMConstraintTypes.CONDITION)) {
                String mConditionVar = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VAR);
                if (!VerificationUtil.evaluateCondition(mConditionVar)) continue;
                if (Trace.isTraceEnabled()) {
                    Trace.out((String)("Condition evaluated to true. condition var = " + elem.getAttribute(CDMConstraintTypes.VAR)));
                }
                this.parseChildrenConditionally(visitorCallback, elem, conditionVar, null, null);
                continue;
            }
            if (elem.getNodeName().equals(CDMConstraintTypes.CHOICE)) {
                String mChoiceVar = this.getRequiredAttributeValue(elem, CDMConstraintTypes.VAR);
                String mChoiceVal = VerificationUtil.getVariableValue(mChoiceVar);
                NodeList selList = elem.getElementsByTagName(CDMConstraintTypes.SELECTION);
                for (int l = 0; l < selList.getLength(); ++l) {
                    Element selElem = (Element)selList.item(l);
                    String mSelectionValue = selElem.getAttribute(CDMConstraintTypes.VALUE);
                    if (!mSelectionValue.equals(mChoiceVal)) continue;
                    if (Trace.isTraceEnabled()) {
                        Trace.out((String)("Found match for choice variable = " + choiceVar + ". Selection = " + mSelectionValue));
                    }
                    this.parseChildrenConditionally(visitorCallback, selElem, null, mChoiceVar, mSelectionValue);
                }
                continue;
            }
            visitorCallback.handle(elem, conditionVar, choiceVar, selection);
        }
    }

    public static void main(String[] args) {
        String tracePackages = new String("oracle.cluster.verification.constraints,oracle.cluster.verification.constraints.parser");
        if (System.getSecurityManager() == null) {
            System.setSecurityManager((SecurityManager)new NullSecurityManager());
        }
        System.setProperty("TRACING.ENABLED", "true");
        System.setProperty("TRACING.LEVEL", "5");
        System.setProperty("TRACING.PACKAGE", tracePackages);
        String logDir = VerificationUtil.getTraceLoc();
        if (logDir == null) {
            logDir = VerificationUtil.getCVHome();
        }
        if (logDir == null) {
            logDir = "./";
        }
        Trace.out((String)("logDir = " + logDir));
        Trace.out((String)("log file = " + logDir + "trace.log"));
        Trace.configure((boolean)true, (boolean)true, (boolean)true, (boolean)true, (String)(logDir + "trace.log"), (boolean)true);
        ParamManager paramMgr = null;
        try {
            paramMgr = ParamManager.getInstance(ParamManager.OperationMode.MODE_API, args);
        }
        catch (InvalidCommandlineException e) {
            e.printStackTrace();
        }
        String[] nodelist = null;
        try {
            nodelist = VerificationUtil.getNodelist();
        }
        catch (NodelistNotFoundException e) {
            e.printStackTrace();
        }
        String classpath = System.getProperty("CLASSPATH");
        Trace.out((String)("System property CLASSPATH: " + classpath));
        String cp = System.getenv("CLASSPATH");
        Trace.out((String)("Env CLASSPATH: " + cp));
        try {
            XmlParser parser = new XmlParser(new File(VerificationUtil.getPreReqXmlPath(VerificationType.PREREQ_CRS_INST)));
            try {
                parser.parse();
            }
            catch (XmlParserException e) {
                e.printStackTrace();
            }
        }
        catch (XmlFilePathException e) {
            e.printStackTrace();
        }
    }
}

