/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.client;

import java.util.Arrays;
import oracle.ops.mgmt.security.NullSecurityManager;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CVUHelper {
    public CVUHelper() {
        if (System.getSecurityManager() == null) {
            System.setSecurityManager((SecurityManager)new NullSecurityManager());
            Trace.out((String)"Security manager is set");
        }
    }

    private void displayUsage() {
        System.err.println("USAGE:");
        System.err.println("cvuhelper clusterware-version-required");
    }

    private boolean validateArguments(String[] args) {
        if (args.length != 1) {
            this.displayUsage();
            return false;
        }
        String[] argsArr = args[0].split("\\.");
        Trace.out((String)("length = " + argsArr.length + "args=" + args[0]));
        if (argsArr.length < 3) {
            this.displayUsage();
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        String crsHome;
        VerificationUtil.setupTracingCVUHelper(true);
        Trace.out((String)"CVUHelper main()");
        CVUHelper cvuHelper = new CVUHelper();
        if (!VerificationUtil.checkPlatform()) {
            String suppos = VerificationUtil.getSupportedOS();
            String supparch = VerificationUtil.getSupportedArch();
            Trace.out((String)("Invalid platform. This distribution is valid only for OS " + suppos + " running on hardware architecture " + supparch));
            System.exit(1);
        }
        if (!cvuHelper.validateArguments(args)) {
            Trace.out((String)("Invalid command line" + Arrays.asList(args).toString()));
            System.exit(1);
        }
        if ((crsHome = VerificationUtil.getCRSHome()) == null) {
            Trace.out((String)"Bailing out because CRS home couldn't be obtained");
            System.exit(1);
        }
        Trace.out((String)("crsHome=" + crsHome));
        String activeVersion = VerificationUtil.getCRSActiveVersion();
        if (activeVersion == null) {
            Trace.out((String)"Failed to retrieve active version for CRS");
            System.exit(1);
        }
        if (activeVersion.startsWith(args[0])) {
            System.out.println(crsHome);
            Trace.out((String)"==== cvuhelper exiting normally.");
            System.exit(0);
        } else {
            Trace.out((String)("Active Version = " + activeVersion + " doesn't match required Version = " + args[0]));
            System.exit(1);
        }
    }
}

