/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckAvailMemoryCommand
extends VerificationCommand {
    private static String[] s_args = new String[]{"-getavailmemory"};
    StorageSize m_memReqd;

    public CheckAvailMemoryCommand(String nodeName, long memReqd) {
        this(nodeName, new StorageSize(memReqd, StorageUnit.BYTE));
    }

    public CheckAvailMemoryCommand(String nodeName, StorageSize memReqd) {
        super(nodeName, s_args, null);
        this.m_memReqd = memReqd;
    }

    public boolean execute() {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("CheckAvailMemoryCommand::Inside execute() " + Thread.currentThread().getName()));
        }
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for CheckAvailMemoryCommand...";
            if (Trace.isTraceEnabled()) {
                Trace.out((String)trcTxt);
            }
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("CheckAvailMemory failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        analyzer.verifyAvailMemory(reoutput, this.m_memReqd, result);
        return true;
    }
}

