/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckGroupCommand
extends VerificationCommand {
    private static String m_arg1 = "-chkgroup";
    private String m_group;

    public CheckGroupCommand(String nodeName, String grpname) {
        super(nodeName, null, null);
        this.m_group = grpname;
        String[] args = new String[]{m_arg1, this.m_group};
        super.setArgs(args);
    }

    public boolean execute() {
        Trace.out((String)("CheckGroupCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for CheckGroupCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("checking group existence failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        analyzer.verifyGroupExistence(reoutput, this.m_group, result);
        return true;
    }
}

