/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckIsLocalOnlyCommand
extends VerificationCommand {
    public CheckIsLocalOnlyCommand(String nodeName) {
        super(nodeName);
    }

    public boolean execute() {
        Result result = this.getResult();
        boolean retval = false;
        Trace.out((String)("CheckIsLocalOnlyCommand:: Inside execute() [Thread:" + Thread.currentThread().getName() + "]"));
        result.addTraceInfo("CheckIsLocalOnlyCommand::Inside execute() " + Thread.currentThread().getName());
        try {
            retval = this.nativeSystem.isLocalOnly(VerificationUtil.isLocalNodeOperation() ? "localnode" : this.m_node, new Version());
        }
        catch (Exception e) {
            result.addTraceInfo("CheckIsLocalOnlyCommand::execute() Exception calling native system");
            Trace.out((String)"CheckIsLocalOnlyCommand::execute() Exception calling native system");
            result.setStatus(2);
            return false;
        }
        Trace.out((String)("The 'local_only' is set to '" + retval + "'on node " + this.m_node));
        result.addTraceInfo("The 'local_only' is set to '" + retval + "'on node " + this.m_node);
        result.addResultInfo(new Boolean(retval));
        result.setStatus(1);
        return true;
    }
}

