/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckMemoryCommand
extends VerificationCommand {
    boolean m_forSwapCalc = false;
    private static String s_arg1 = "-getmemory";
    private static String s_arg2 = "-forswap";
    StorageSize m_memReqd;

    public CheckMemoryCommand(String nodeName, long memReqd, boolean forSwapCalc) {
        this(nodeName, new StorageSize(memReqd, StorageUnit.BYTE), forSwapCalc);
    }

    public CheckMemoryCommand(String nodeName, StorageSize memReqd, boolean forSwapCalc) {
        super(nodeName, null, null);
        String[] args = null;
        args = forSwapCalc ? new String[]{s_arg1, s_arg2} : new String[]{s_arg1};
        super.setArgs(args);
        this.m_memReqd = memReqd;
        this.m_forSwapCalc = forSwapCalc;
    }

    public boolean execute() {
        Trace.out((String)("CheckMemoryCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for CheckMemoryCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("CheckMemory failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        analyzer.verifyMemory(reoutput, this.m_memReqd, result, this.m_forSwapCalc);
        return true;
    }
}

