/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.config.PackageConstraint;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckPackageCommand
extends VerificationCommand {
    private static String m_arg1 = "-chkpackage";
    private PackageConstraint m_pkgCon;

    public CheckPackageCommand(String nodeName, PackageConstraint pkgCon) {
        super(nodeName, null, null);
        this.m_pkgCon = pkgCon;
        String[] args = new String[]{m_arg1, pkgCon.getKeyData()};
        super.setArgs(args);
    }

    public boolean execute() {
        Trace.out((String)("CheckPackageCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for CheckPackageCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("CheckPackage failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        analyzer.verifyPackage(reoutput, this.m_pkgCon, result);
        return true;
    }
}

