/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckProcessAliveCommand
extends VerificationCommand {
    private static String[] s_args = new String[]{"-chkalive"};
    String m_procName;

    public CheckProcessAliveCommand(String nodeName, String procName) {
        super(nodeName, s_args, null);
        this.m_procName = procName;
        String[] newargs = new String[]{s_args[0], this.m_procName};
        super.setArgs(newargs);
    }

    public boolean execute() {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("CheckProcessAliveCommand::Inside execute() " + Thread.currentThread().getName()));
        }
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for CheckProcessAliveCommand...";
            if (Trace.isTraceEnabled()) {
                Trace.out((String)trcTxt);
            }
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("CheckProcessAlive failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        analyzer.verifyProcessAlive(reoutput, this.m_procName, result);
        return true;
    }
}

