/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckRunlevelCommand
extends VerificationCommand {
    private static String[] s_args = new String[]{"-getrunlevel"};
    int m_runLevelReqd;

    public CheckRunlevelCommand(String nodeName, int runLevelReqd) {
        super(nodeName, s_args, null);
        this.m_runLevelReqd = runLevelReqd;
    }

    public boolean execute() {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("CheckRunlevelCommand::Inside execute() " + Thread.currentThread().getName()));
        }
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for CheckRunlevelCommand...";
            if (Trace.isTraceEnabled()) {
                Trace.out((String)trcTxt);
            }
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("CheckRunlevelCommand failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        analyzer.verifyRunlevel(reoutput, this.m_runLevelReqd, result);
        return true;
    }
}

