/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckTCPCommCommand
extends VerificationCommand {
    private static String[] exec_cmd = new String[]{"-chkTCPclient"};
    String[] newargs = new String[6];
    String m_serverName;
    String m_serverIP;
    String m_serverPort;
    String m_clientName;
    String m_clientIP;

    public CheckTCPCommCommand(String serverName, String serverIP, String serverPort, String clientName, String clientIP) {
        super(clientName, exec_cmd, null);
        this.m_serverName = serverName;
        this.m_serverIP = serverIP;
        this.m_serverPort = serverPort;
        this.m_clientName = clientName;
        this.m_clientIP = clientIP;
        this.newargs[0] = exec_cmd[0];
        this.newargs[1] = serverName;
        this.newargs[2] = serverIP;
        this.newargs[3] = serverPort;
        this.newargs[4] = clientName;
        this.newargs[5] = clientIP;
        super.setArgs(this.newargs);
    }

    public String getServerName() {
        return this.m_serverName;
    }

    public String getServerIP() {
        return this.m_serverIP;
    }

    public String getPort() {
        return this.m_serverPort;
    }

    public String getClientName() {
        return this.m_clientName;
    }

    public String getClientIP() {
        return this.m_clientIP;
    }

    public boolean execute() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)("ENTRY thread: " + Thread.currentThread().getName()));
        }
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for CheckTCPCommCommand...";
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)trcTxt);
            }
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("CheckTCPComm failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        analyzer.verifyTCPComm(reoutput, result);
        return true;
    }
}

