/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckUserMaskCommand
extends VerificationCommand {
    private static String[] s_args = new String[]{"-getusermask", "2>&1"};
    String m_umask;
    String m_curnode;
    String m_loginShell;

    public CheckUserMaskCommand(String nodename, String umask) {
        super(nodename, s_args, null);
        this.m_curnode = nodename;
        this.m_umask = umask;
    }

    public boolean execute() {
        String retval = null;
        Trace.out((String)("CheckUserMask::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = " super.execute() failed for CheckUserMaskCommand...";
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("CheckUserMaskCommand failed");
            result.setStatus(2);
            return false;
        }
        String resultString = VerificationUtil.strArr2List(this.getCommandResult().getResultString(), System.getProperty("line.separator"));
        String valContent = VerificationUtil.fetchVerificationValue(resultString);
        retval = this.filterUmask(VerificationUtil.string2strArr(valContent, System.getProperty("line.separator")));
        if (null == retval || "" == retval) {
            String trcTxt = " execute() failed for CheckUserMaskCommand...";
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("CheckUserMaskCommand failed");
            result.setStatus(2);
            return false;
        }
        if (Integer.valueOf(retval).equals(Integer.valueOf(this.m_umask))) {
            result.addTraceInfo("User mask matched with Expected Value: " + this.m_umask);
            result.addTraceInfo("User mask check passed");
            result.addResultInfo(retval);
            result.setStatus(1);
            return true;
        }
        result.addTraceInfo("User mask retrieved was  : " + retval);
        result.addTraceInfo("User mask check failed. Unexpected umask");
        result.addErrorInfo("User mask check failed");
        result.addResultInfo(retval);
        result.setStatus(3);
        return false;
    }

    private String filterUmask(String[] Output) {
        String retstr = "";
        int len = Output.length;
        if (len > 0) {
            int theIndex = 0;
            for (int j = 0; j < len; ++j) {
                if (!Output[j].contains("END")) continue;
                theIndex = j - 1;
            }
            Pattern p = Pattern.compile("^[0-7]{1,4}$");
            Matcher m = p.matcher(Output[theIndex]);
            if (m.matches()) {
                retstr = Output[theIndex];
            }
        }
        return retstr;
    }
}

