/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckUsrInGrpCommand
extends VerificationCommand {
    private static String m_arg1 = "-getgroups";
    private String m_group;
    private String m_user;
    private int m_chkprim;

    public CheckUsrInGrpCommand(String nodeName, String username, String grpname, int chkprim) {
        super(nodeName, null, null);
        this.m_group = grpname;
        this.m_user = username;
        this.m_chkprim = chkprim;
        String[] args = new String[]{m_arg1, this.m_user};
        super.setArgs(args);
    }

    public boolean execute() {
        Trace.out((String)("CheckUsrInGrpCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for CheckUsrInGrpCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("checking group existence failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        analyzer.verifyUsrInGroup(reoutput, this.m_user, this.m_group, this.m_chkprim, result);
        return true;
    }
}

