/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.GenericUtil;
import oracle.ops.verification.util.ParsingException;

public class GetFileInfoCommand
extends VerificationCommand {
    protected static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static String m_arg1 = "-getfileinfo";
    private static final String TAG_FILE = "FILE";
    private String m_configFile;

    public GetFileInfoCommand(String nodeName, String fname) {
        super(nodeName, null, null);
        this.m_configFile = fname;
        String[] args = new String[]{m_arg1, this.m_configFile};
        super.setArgs(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute() {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        Trace.out((String)("GetFileVerCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for GetFileVerCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("checking file version failed");
            result.setStatus(2);
            return false;
        }
        if (result.getStatus() == 1) {
            String[] resultString = this.getCommandResult().getResultString();
            String output = VerificationUtil.fetchVerificationValue(VerificationUtil.strArr2String(resultString));
            Hashtable<String, FileInfo> fileList = new Hashtable<String, FileInfo>();
            String outputFileName = output.trim();
            String shortFileName = outputFileName.substring(outputFileName.lastIndexOf(File.separator) + 1);
            String destinationFileName = VerificationUtil.getDestLoc() + this.m_node + "." + shortFileName;
            nativeSys.copyFile(this.m_node, outputFileName, "localnode", destinationFileName);
            File destinationFile = new File(destinationFileName);
            if (!destinationFile.exists()) {
                result.setStatus(2);
                ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("5002", false, (Object[])new String[]{this.m_node}));
                result.addErrorDescription(errorDesc);
                return true;
            }
            StringBuffer outputBuffer = new StringBuffer();
            try {
                String line;
                BufferedReader destinationFileBR = new BufferedReader(new FileReader(destinationFile));
                while ((line = destinationFileBR.readLine()) != null) {
                    outputBuffer.append(line);
                }
                destinationFileBR.close();
                output = outputBuffer.toString();
            }
            catch (FileNotFoundException e) {
                result.setStatus(2);
                ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("5002", false, (Object[])new String[]{this.m_node}));
                result.addErrorDescription(errorDesc);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                result.setStatus(2);
                ErrorDescription errorDesc = new ErrorDescription(s_msgBundle.getMessage("5002", false, (Object[])new String[]{this.m_node}));
                result.addErrorDescription(errorDesc);
                boolean bl = true;
                return bl;
            }
            finally {
                nativeSys.removeFile(this.m_node, outputFileName);
                nativeSys.removeFile("localnode", destinationFileName);
            }
            Vector infStrs = null;
            try {
                output = output.replaceAll("\n", "");
                infStrs = GenericUtil.getAllStrByTags(output, TAG_FILE);
                for (Object fmtdObj : infStrs) {
                    String fmtdStr = (String)fmtdObj;
                    FileInfo fileInfo = new FileInfo();
                    fileInfo.setStatus(GenericUtil.getValueByKey(fmtdStr, "STATUS"));
                    fileInfo.setErrorString(GenericUtil.getValueByKey(fmtdStr, "ERROR"));
                    fileInfo.setFileName(GenericUtil.getValueByKey(fmtdStr, "NAME"));
                    fileInfo.setFileOwner(GenericUtil.getValueByKey(fmtdStr, "USER"));
                    fileInfo.setFileGroup(GenericUtil.getValueByKey(fmtdStr, "GROUP"));
                    fileInfo.setFilePermissions(GenericUtil.getValueByKey(fmtdStr, "PERMISSIONS"));
                    fileList.put(fileInfo.getFileName(), fileInfo);
                }
            }
            catch (ParsingException p) {
                Trace.out((Exception)p);
                result.setStatus(2);
                result.addTraceInfo("Parsing of the output failed");
                result.addErrorInfo("GetFileInfoCommand failed");
            }
            result.addResultInfo(fileList);
        } else {
            result.setStatus(2);
        }
        return true;
    }
}

