/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GetFileVerCommand
extends VerificationCommand {
    private static String m_arg1 = "-getfilever";
    private String m_file;
    private String m_fileVer;

    public GetFileVerCommand(String nodeName, String fname, String fver) {
        super(nodeName, null, null);
        this.m_file = fname;
        this.m_fileVer = fver;
        String[] args = new String[]{m_arg1, this.m_file};
        super.setArgs(args);
    }

    public boolean execute() {
        Trace.out((String)("GetFileVerCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for GetFileVerCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("checking file version failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        analyzer.verifyFileVersion(reoutput, this.m_file, this.m_fileVer, result);
        return true;
    }
}

