/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GetKernelParamCommand
extends VerificationCommand {
    private static String m_arg1 = "-getkernelparam";
    private String m_param;

    public GetKernelParamCommand(String nodeName, String param) {
        super(nodeName, null, null);
        this.m_param = param;
        String[] args = new String[]{m_arg1, this.m_param};
        super.setArgs(args);
    }

    public boolean execute() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for kernel param " + this.m_param;
            if (Trace.isTraceEnabled()) {
                Trace.out((String)trcTxt);
            }
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("getting kernel param failed");
            result.setStatus(2);
            return false;
        }
        if (this.commandResult.getStatus() && this.commandResult.getResultString() != null) {
            String[] resultString = this.getCommandResult().getResultString();
            String reoutput = VerificationUtil.strArr2String(resultString);
            String paramValueString = VerificationUtil.fetchVerificationValue(reoutput);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("The value for kernel param: " + this.m_param + " on node:" + this.m_node + " is " + paramValueString));
            }
            result.addTraceInfo("The value for kernel param: " + this.m_param + " on node:" + this.m_node + " is " + paramValueString);
            result.addResultInfo(paramValueString);
            result.setStatus(1);
            return true;
        }
        Trace.out((String)("ERROR:GetKernelParamCommand:: " + this.commandResult.getResultString()));
        result.addErrorInfo("ERROR:GetKernelParamCommand:: " + this.commandResult.getResultString());
        result.addTraceInfo("ERROR:GetKernelParamCommand:: " + this.commandResult.getResultString());
        result.setStatus(2);
        return false;
    }
}

