/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GetKernelVerCommand
extends VerificationCommand {
    private static String[] s_args = new String[]{"-getosrelease"};

    public GetKernelVerCommand(String nodeName) {
        super(nodeName, s_args, null);
    }

    public boolean execute() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)("GetKernelVerCommand::Inside execute() " + Thread.currentThread().getName()));
        }
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for GetKernelVerCommand...";
            if (Trace.isLevelEnabled((int)15)) {
                Trace.out((String)trcTxt);
            }
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("GetKernelVer failed");
            result.setStatus(2);
            return false;
        }
        if (this.commandResult.getStatus() && this.commandResult.getResultString() != null) {
            String[] resultString = this.getCommandResult().getResultString();
            String reoutput = VerificationUtil.strArr2String(resultString);
            String paramValueString = VerificationUtil.fetchVerificationValue(reoutput);
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("The value for kernel version:  on node:" + this.m_node + " is " + paramValueString));
            }
            result.addTraceInfo("The value for kernel version:  on node:" + this.m_node + " is " + paramValueString);
            result.addResultInfo(paramValueString);
            result.setStatus(1);
            if (Trace.isLevelEnabled((int)2)) {
                Trace.out((String)"GetKernelVerCommand: Exit with success");
            }
            return true;
        }
        if (Trace.isLevelEnabled((int)15)) {
            Trace.out((String)("ERROR:GetKernelVerCommand:: " + this.commandResult.getResultString()));
        }
        result.addErrorInfo("ERROR:GetKernelVerCommand:: " + this.commandResult.getResultString());
        result.addTraceInfo("ERROR:GetKernelVerCommand:: " + this.commandResult.getResultString());
        result.setStatus(2);
        return false;
    }
}

