/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.command.registry.RegistryKeyData;
import oracle.ops.mgmt.command.registry.RegistryNativeResult;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;

public class GetRegKeyCommand
extends VerificationCommand {
    String m_regkey;
    String m_regsubkey;

    public GetRegKeyCommand(String nodeName, String regkey) {
        super(nodeName);
        String[] keys = this.splitRegKey(regkey);
        if (keys == null) {
            this.m_regsubkey = null;
            this.m_regkey = null;
        } else {
            this.m_regkey = keys[0];
            this.m_regsubkey = keys[1];
        }
        Trace.out((String)("Reg key: " + this.m_regkey + ", subkey: " + this.m_regsubkey));
    }

    public boolean execute() {
        Result result = this.getResult();
        Trace.out((String)("GetRegKeyCommand:: Inside execute() [Thread:" + Thread.currentThread().getName() + "]"));
        result.addTraceInfo("GetRegKeyCommand::Inside execute() " + Thread.currentThread().getName());
        RegistryKeyData regData = new RegistryKeyData(this.m_regkey, this.m_regsubkey);
        regData.setDataType(10);
        RegistryNativeResult regResult = new RegistryNativeResult();
        this.nativeSystem.regGetData(this.m_node, this.m_regkey, this.m_regsubkey, regData, (NativeResult)regResult);
        if (!regResult.getStatus()) {
            Trace.out((String)"GetRegKeyCommand::execute() Command failed!");
            result.addTraceInfo("GetRegKeyCommand::execute() Command failed!");
            result.addErrorInfo("GetRegKeyCommand::execute() Command failed!");
            result.setStatus(2);
            return false;
        }
        String keyVal = regData.getStringData();
        Trace.out((String)("Registry data for key: " + this.m_regkey + ":" + this.m_regsubkey + " is: " + keyVal));
        result.addTraceInfo("Registry data for Key: " + this.m_regkey + ", value: " + this.m_regsubkey + " is: " + keyVal);
        result.addResultInfo(keyVal);
        result.setStatus(1);
        return true;
    }

    private String[] splitRegKey(String regkey) {
        String subkey;
        if (regkey == null || regkey.trim().length() <= 0) {
            return null;
        }
        int index = regkey.lastIndexOf("\\");
        if (-1 == index || regkey.length() == index) {
            Trace.out((String)("==== Unable to retrieve subkey from reg key: " + regkey));
            return null;
        }
        String[] keys = new String[2];
        keys[0] = regkey.substring(0, index);
        Trace.out((String)("==== Key: " + keys[0]));
        keys[1] = subkey = regkey.substring(index + 1);
        Trace.out((String)("==== Subkey: " + keys[1]));
        return keys;
    }
}

