/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.storage.CommandHandler;
import oracle.ops.verification.framework.storage.CommandHandlerFactory;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GetSpaceCommand
extends VerificationCommand {
    private String m_location;
    private int m_type;
    private VerificationCommand remCmd = null;
    private static CommandHandler s_commandHandler;
    private String m_realpath;
    private String m_signature;

    public GetSpaceCommand(String nodeName, String location, String realpath, int stType) {
        super(nodeName);
        this.m_location = location;
        this.m_type = stType;
        this.m_realpath = realpath;
        s_commandHandler = CommandHandlerFactory.createCommandHandler();
    }

    public GetSpaceCommand(String nodeName, String signature, int stType) {
        super(nodeName);
        this.m_type = stType;
        this.m_signature = signature;
        s_commandHandler = CommandHandlerFactory.createCommandHandler();
    }

    public boolean execute() {
        Result result = super.getResult();
        Trace.out((String)("GetSpaceCommand:: Inside execute() [Thread:" + Thread.currentThread().getName() + "]"));
        try {
            this.remCmd = this.m_signature != null ? (VerificationCommand)s_commandHandler.genInfoCmd(this.m_node, this.m_type, this.m_signature) : (VerificationCommand)s_commandHandler.genInfoCmd(this.m_node, this.m_type, this.m_location, this.m_realpath, result);
        }
        catch (StorageException e) {
            Trace.out((Exception)e);
            String trcTxt = "StorageException generating info cmd for location " + this.m_location + " of type " + this.m_type;
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("Generating Info command for storage failed");
            result.setStatus(2);
            return false;
        }
        boolean bResult = this.remCmd.execute();
        if (!bResult) {
            String trcTxt = " Getting exectask storage info failed for GetSpaceCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("Getting exectask storage info failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.remCmd.getCommandResult().getResultString();
        String exectaskFmtdStr = VerificationUtil.strArr2List(resultString, "\n");
        if (0 != this.remCmd.getVfyCode() || !VerificationUtil.fetchExecResult(exectaskFmtdStr)) {
            String trcTxt = "Exectask result shows failure for -getstinfo...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            Trace.out((String)"getting exectask storage info failed");
            result.addErrorInfo("getting exectask storage info failed");
            result.setStatus(2);
            return false;
        }
        StorageInfo st = null;
        try {
            st = s_commandHandler.parseInfoResult(this.remCmd, this.m_type, this.m_location);
        }
        catch (StorageException e) {
            Trace.out((Exception)e);
            String trcTxt = "StorageException parsing info cmd output for location " + this.m_location + " of type " + this.m_type;
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("Parsing Info command output for storage failed");
            result.setStatus(2);
            return false;
        }
        if (st != null) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("The free space at " + this.m_location + " on node " + this.m_node + " is : " + st.getFree()));
            }
            result.addTraceInfo("The free space at " + this.m_location + " on node " + this.m_node + " is : " + st.getFree());
            result.addResultInfo((long)st.getFree().sizeIn(StorageUnit.BYTE));
            result.addResultInfo(st);
            result.setStatus(1);
            return true;
        }
        Trace.out((String)("ERROR:GetSpaceCommand:: " + this.commandResult.getResultString()));
        result.addErrorInfo("ERROR:GetSpaceCommand:: " + this.commandResult.getResultString());
        result.addTraceInfo("ERROR:GetSpaceCommand:: " + this.commandResult.getResultString());
        result.setStatus(2);
        return false;
    }
}

