/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzer;
import oracle.ops.verification.framework.nativesystem.ExecutionAnalyzerFactory;
import oracle.ops.verification.framework.util.VerificationUtil;

public class RunTCPServerCommand
extends VerificationCommand {
    private static String[] exec_cmd = new String[]{"-runTCPserver"};
    String m_serverName;
    String m_serverIP;
    String[] newargs = new String[3];

    public RunTCPServerCommand(String serverName, String serverIP) {
        super(serverName, exec_cmd, null);
        this.m_serverName = serverName;
        this.m_serverIP = serverIP;
        this.newargs[0] = exec_cmd[0];
        this.newargs[1] = this.m_serverName;
        this.newargs[2] = this.m_serverIP;
        super.setArgs(this.newargs);
    }

    public boolean execute() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)("ENTRY thread: " + Thread.currentThread().getName()));
        }
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for RunTCPServerCommand...";
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)trcTxt);
            }
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("RunTCPServer failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("Command output:" + reoutput));
        }
        ExecutionAnalyzer analyzer = ExecutionAnalyzerFactory.getExecutionAnalyzer();
        analyzer.verifyTCPServer(reoutput, result);
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)("EXIT" + Thread.currentThread().getName()));
        }
        return true;
    }
}

