/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import java.io.File;
import oracle.ops.mgmt.command.util.RemoteExecCommand;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class VerificationCommand
extends RemoteExecCommand
implements VerificationConstants {
    protected Result m_result;
    protected Object m_key;
    private String m_output;
    private String m_cmdExecuted;
    private int m_vfyCode;
    private static String s_subDir = VerificationUtil.getCVUSubDir();
    private String m_error;

    public VerificationCommand(String node) {
        super("", null, null, node, VerificationUtil.isLocalNodeOperation(), null, "", "");
        super.setSubDirAndGroup(s_subDir, VerificationUtil.getCurrentGroup());
        this.m_key = node;
        this.m_result = new Result(node);
    }

    public VerificationCommand(String node, String[] args, String[] env) {
        super(VerificationUtil.getDestLoc() + s_subDir + File.separator + VerificationUtil.getCmd4RemExec(), args, env, node, VerificationUtil.isLocalNodeOperation(), VerificationUtil.getCmdFiles4RemExec(), VerificationUtil.getSrcLoc(), VerificationUtil.getDestLoc());
        super.setSubDirAndGroup(s_subDir, VerificationUtil.getCurrentGroup());
        this.m_key = node;
        this.m_result = new Result(node);
    }

    public VerificationCommand(String node, String[] args, String[] env, Result result) {
        super(VerificationUtil.getDestLoc() + s_subDir + File.separator + VerificationUtil.getCmd4RemExec(), args, env, node, VerificationUtil.isLocalNodeOperation(), VerificationUtil.getCmdFiles4RemExec(), VerificationUtil.getSrcLoc(), VerificationUtil.getDestLoc());
        super.setSubDirAndGroup(s_subDir, VerificationUtil.getCurrentGroup());
        this.m_key = node;
        this.m_result = result != null ? result : new Result(node);
    }

    public VerificationCommand(String cmd, String[] args, String[] env, String node, String[] cmdFiles, String srcLoc, String destLoc) {
        super(cmd, args, env, node, VerificationUtil.isLocalNodeOperation(), cmdFiles, srcLoc, destLoc);
        super.setSubDirAndGroup(s_subDir, VerificationUtil.getCurrentGroup());
        this.m_key = node;
        this.m_result = new Result(node);
    }

    public boolean execute() {
        boolean commandSucc = true;
        boolean execSucc = true;
        String fmtdResult = "";
        String vfyCodeStr = null;
        Trace.out((String)":: Inside execute() [Thread:");
        this.m_result.addTraceInfo("::Inside execute() ");
        commandSucc = super.execute();
        if (commandSucc) {
            String[] resultStrings = this.commandResult.getResultString();
            if (resultStrings == null || resultStrings.length == 0) {
                commandSucc = false;
            } else {
                fmtdResult = VerificationUtil.strArr2List(resultStrings, System.getProperty("line.separator"));
                this.m_output = VerificationUtil.fetchVerificationValue(fmtdResult);
                Trace.out((String)("Formatted exectask output is:\n " + fmtdResult));
                this.m_error = VerificationUtil.fetchError(fmtdResult);
                vfyCodeStr = VerificationUtil.fetchVerificationResult(fmtdResult);
                if (vfyCodeStr == null) {
                    this.m_vfyCode = 1;
                    Trace.out((String)"VRES value was NULL, VfyCode is set to 1. ");
                } else {
                    this.m_vfyCode = Integer.parseInt(vfyCodeStr);
                    Trace.out((String)("VfyCode is: " + this.m_vfyCode));
                }
                this.m_cmdExecuted = VerificationUtil.fetchCommandValue(fmtdResult);
            }
        }
        if (commandSucc && VerificationUtil.fetchExecResult(fmtdResult)) {
            execSucc = true;
            this.m_result.setStatus(1);
        } else {
            execSucc = false;
            Trace.out((String)("ERROR:" + this.commandResult.getResultString()));
            this.m_result.setStatus(2);
        }
        return execSucc;
    }

    public Result getResult() {
        return this.m_result;
    }

    public String getNodeName() {
        return this.m_node;
    }

    public void setKey(Object key) {
        this.m_key = key;
    }

    public Object getKey() {
        return this.m_key;
    }

    public String getOutput() {
        return this.m_output;
    }

    public String getError() {
        return this.m_error;
    }

    public int getVfyCode() {
        return this.m_vfyCode;
    }

    public String getExecCommand() {
        return this.m_cmdExecuted;
    }
}

