/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.config;

import java.util.Hashtable;
import java.util.Vector;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.InvalidConstraintDataException;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.util.VerificationUtil;

public abstract class Constraint {
    public static final String KEY_TYPE = "Type";
    public static final String KEY_QUALIFIER = "Qualifier";
    public static final String KEY_FBACTION = "FallbackAction";
    public static final String KEY_KEYDATA = "KeyData";
    public static final String KEY_REFDATA = "RefData";
    public static final String TYPE_UNKNOWN = "UNKNOWN";
    public static final String TYPE_SPACE = "SPACE";
    public static final String TYPE_OS = "OS";
    public static final String TYPE_OSVER = "OSVER";
    public static final String TYPE_OSPATCH = "OSPATCH";
    public static final String TYPE_KRNVER = "KRNVER";
    public static final String TYPE_KRNPARAM = "KRNPARAM";
    public static final String TYPE_SYSPARAM = "SYSPARAM";
    public static final String TYPE_PACKAGE = "PACKAGE";
    public static final String TYPE_LIB = "LIB";
    public static final String TYPE_FILE = "FILE";
    public static final String TYPE_PATH = "PATH";
    public static final String TYPE_CLASSPATH = "CLASSPATH";
    public static final String TYPE_EXE = "EXE";
    public static final String TYPE_REGENTRY = "REGENTRY";
    public static final String TYPE_ALIVE = "ALIVE";
    public static final String TYPE_USER = "USER";
    public static final String TYPE_GROUP = "GROUP";
    public static final String TYPE_USERGRP = "USERGRP";
    public static final String TYPE_OWNERSHIP = "OWNERSHIP";
    public static final String TYPE_PORT = "PORT";
    public static final String TYPE_JAVAVER = "JAVAVER";
    public static final String TYPE_RAWSIZE = "RAWSIZE";
    public static final String TYPE_SWAP = "SWAP";
    public static final String TYPE_FREEMEM = "FREEMEM";
    public static final String TYPE_TOTALMEM = "TOTALMEM";
    public static final String TYPE_NUMPROCESSOR = "NUMPROCESSOR";
    public static final String TYPE_OCRVER = "OCRVER";
    public static final String TYPE_ARCHITECTURE = "ARCHITECTURE";
    public static final String Q_LT = "LT";
    public static final String Q_LTE = "LTE";
    public static final String Q_GT = "GT";
    public static final String Q_GTE = "GTE";
    public static final String Q_EXIST = "EXIST";
    public static final String Q_NOTEXIST = "NOTEXIST";
    public static final String Q_EQUAL = "EQUAL";
    public static final String Q_NOTEQUAL = "NOTEQUAL";
    public static final String Q_ALIVE = "ALIVE";
    public static final String Q_NOTALIVE = "NOTALIVE";
    public static final String Q_DISCOVER = "DISCOVER";
    public static final String Q_COMPARE = "COMPARE";
    public static final String Q_QUERY = "QUERY";
    public static final String Q_INRANGE = "INRANGE";
    public static final String A_SKIP = "SKIP";
    public static final String A_STOP = "STOP";
    public static final String A_WARN = "WARN";
    public static final String A_INFO = "INFO";
    public static final String CHAR_DIRECTIVE = "#";
    public static final String DRT_MAX = "#CV_MAX)";
    public static final String DRT_MIN = "#CV_MIN)";
    public static final String DRT_EX = "#CV_EX)";
    public static final String DRT_EXF = "#CV_EXF)";
    public static final String DRT_EXT = "#CV_EXT)";
    protected String m_type = "UNKNOWN";
    protected String m_qualifier;
    protected String m_fbAction;
    protected String m_keyData;
    protected Vector m_vRefData;
    protected static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    protected boolean m_valid = false;

    protected Constraint(String type) {
        this.m_type = type;
    }

    protected Constraint(String type, String qualifier, String fbaction) {
        this.m_type = type;
        this.m_qualifier = qualifier;
        this.m_fbAction = fbaction;
    }

    public String getType() {
        return this.m_type;
    }

    public void setKeyData(String keyData) {
        this.m_keyData = keyData;
    }

    public String getKeyData() {
        return this.m_keyData;
    }

    public void setRefData(Vector refData) {
        this.m_vRefData = refData;
    }

    public Vector getRefData() {
        return this.m_vRefData;
    }

    public String getFirstRefData() {
        return (String)this.m_vRefData.firstElement();
    }

    public boolean isValid() {
        return this.m_valid;
    }

    public void setValid(boolean valid) {
        this.m_valid = valid;
    }

    public String getQualifier() {
        return this.m_qualifier;
    }

    public void setQualifier(String qualifier) {
        this.m_qualifier = qualifier;
    }

    public String getFallbackAction() {
        return this.m_fbAction;
    }

    public void setFallbackAction(String action) {
        this.m_fbAction = action;
    }

    protected void validate(Hashtable ht) throws InvalidConstraintDataException {
        if (!ht.containsKey(KEY_TYPE)) {
            throw new InvalidConstraintDataException("Invalid data set for " + this.getClass().getName() + ". Constraint type required.");
        }
        if (!ht.containsKey(KEY_QUALIFIER)) {
            throw new InvalidConstraintDataException("Invalid data set for " + this.getClass().getName() + ". Constraint qualifier required.");
        }
        if (!ht.containsKey(KEY_FBACTION)) {
            throw new InvalidConstraintDataException("Invalid data set for " + this.getClass().getName() + ". Constraint fallback-action required.");
        }
        if (ht.containsKey(KEY_KEYDATA)) {
            this.m_keyData = (String)ht.get(KEY_KEYDATA);
        }
        if (ht.containsKey(KEY_REFDATA)) {
            this.m_vRefData = (Vector)ht.get(KEY_REFDATA);
        }
    }

    protected void validateDirective(String refData) throws InvalidConstraintDataException {
        if (!refData.startsWith(CHAR_DIRECTIVE)) {
            throw new InvalidConstraintDataException("Invalid data set for " + this.getClass().getName() + ". Constraint directive required for this qualifier.");
        }
        if (refData.startsWith(DRT_EXF) && -1 == refData.indexOf(DRT_EXT)) {
            throw new InvalidConstraintDataException("Invalid data set for " + this.getClass().getName() + ". Closing directive '" + DRT_EXT + "' missing.");
        }
        if (!(refData.startsWith(DRT_MAX) || refData.startsWith(DRT_MIN) || refData.startsWith(DRT_EX) || refData.startsWith(DRT_EXF))) {
            throw new InvalidConstraintDataException("Invalid data set for " + this.getClass().getName() + ". Invalid directive found for " + refData);
        }
        Trace.out((String)("==== Directive is valid for '" + refData + "'"));
    }

    public abstract boolean applyConstraint(String[] var1, ResultSet var2) throws InvalidConstraintDataException;

    public abstract void report(ResultSet var1);

    public String toString() {
        StringBuffer sb = new StringBuffer("Constraint type: '" + this.getClass().getName() + "'");
        sb.append(" KeyData[" + this.m_keyData + "] ");
        sb.append(" RefData[" + VerificationUtil.strVect2List(this.m_vRefData) + "] ");
        return sb.toString();
    }

    protected void print(String str) {
        System.out.print(str);
    }

    protected void println(String str) {
        System.out.println(str);
    }
}

