/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.config;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.Constraint;
import oracle.ops.verification.framework.config.InvalidConstraintDataException;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;

public class KernelParamConstraint
extends Constraint {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1060", false);
    private int m_exactNum = 5;
    private String m_quali;
    private String m_fbaction;
    private String m_param;
    private long m_reqVal = 0L;

    public KernelParamConstraint(String quali, String fbaction, String param, long val) {
        super("KRNPARAM");
        this.m_quali = quali;
        this.m_fbaction = fbaction;
        this.m_param = param;
        this.m_reqVal = val;
    }

    public KernelParamConstraint(Hashtable ht) throws InvalidConstraintDataException {
        super("KRNPARAM");
        this.validate(ht);
        this.m_quali = (String)ht.get("Qualifier");
        this.m_fbaction = (String)ht.get("FallbackAction");
        this.m_param = (String)ht.get("KeyData");
        Vector rdVec = (Vector)ht.get("RefData");
        this.m_reqVal = Long.parseLong((String)rdVec.firstElement());
    }

    public void report(ResultSet rsltSet) {
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_param}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.CONFIGURED, ReportUtil.REQUIRED, ReportUtil.COMMENT);
        Hashtable t = rsltSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                ReportUtil.writeRecord(node, (String)result.getResultInfoSet().elementAt(1), Long.toString(this.m_reqVal), ReportUtil.PASSED);
                continue;
            }
            if (result.getStatus() == 3) {
                ReportUtil.writeRecord(node, (String)result.getResultInfoSet().elementAt(1), Long.toString(this.m_reqVal), ReportUtil.FAILED);
                continue;
            }
            ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, Long.toString(this.m_reqVal), ReportUtil.FAILED);
        }
        if (rsltSet.getStatus() == 1) {
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_param}));
        } else {
            ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_param}));
            ReportUtil.printErrorNodes(rsltSet);
        }
    }

    public boolean applyConstraint(String[] nodeList, ResultSet rset) {
        GlobalExecution globalExec = new GlobalExecution();
        return globalExec.checkKerParam(nodeList, this.m_param, this.m_reqVal, rset);
    }

    public void validate(Hashtable ht) throws InvalidConstraintDataException {
        if (ht.size() != this.m_exactNum) {
            String errtxt = "Invalid data set for " + this.getClass().getName() + ". EXPECTED: " + this.m_exactNum + ", FOUND: " + ht.size();
            Trace.out((String)errtxt);
            throw new InvalidConstraintDataException(errtxt);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("KernelParamConstraint[");
        sb.append("Qualifier: " + this.m_quali);
        sb.append(", FallbackAction: " + this.m_fbaction);
        sb.append(", Param: " + this.m_param);
        sb.append(", Value: " + this.m_reqVal + "]");
        return sb.toString();
    }
}

