/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.config;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.Constraint;
import oracle.ops.verification.framework.config.InvalidConstraintDataException;
import oracle.ops.verification.framework.config.PeerCompatible;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;

public class OsPatchConstraint
extends Constraint
implements PeerCompatible {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1053", false);
    private String m_refStatus = ReportUtil.UNKNOWN;
    private String m_reqOsPatch;
    private String m_osPatchDisplayTag;

    public OsPatchConstraint(String quali, String fbaction, String val) {
        super("OSPATCH", quali, fbaction);
        this.m_reqOsPatch = val;
        this.setValid(false);
    }

    public OsPatchConstraint(Hashtable ht) throws InvalidConstraintDataException {
        super("OSPATCH");
        this.validate(ht);
        this.m_qualifier = (String)ht.get("Qualifier");
        this.m_fbAction = (String)ht.get("FallbackAction");
        this.m_reqOsPatch = (String)ht.get("KeyData");
        this.setValid(true);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append("[Qualifier: " + this.m_qualifier);
        sb.append(", FallbackAction: " + this.m_fbAction);
        sb.append(", Required OsPatch: " + this.formatOSPatchDisplayString(this.m_reqOsPatch) + "]");
        return sb.toString();
    }

    public void validate(Hashtable ht) throws InvalidConstraintDataException {
        super.validate(ht);
        if (!((String)ht.get("Type")).equals("OSPATCH")) {
            throw new InvalidConstraintDataException("Constraint type does not match. Type specified: " + (String)ht.get("Type"));
        }
        int dsetlen = 0;
        String quali = (String)ht.get("Qualifier");
        if (!ht.containsKey("KeyData")) {
            throw new InvalidConstraintDataException("Missing KeyData");
        }
        if (quali.equals("GTE") || quali.equals("COMPARE")) {
            dsetlen = 4;
            if (ht.size() != dsetlen) {
                String errtxt = "Invalid data set for " + this.getClass().getName() + ". EXPECTED: " + dsetlen + " items, FOUND: " + ht.size() + " items.";
                throw new InvalidConstraintDataException(errtxt);
            }
        } else {
            throw new InvalidConstraintDataException("Qualifier '" + quali + "' is not supported for " + this.getClass().getName());
        }
    }

    public boolean applyConstraint(String[] nodeList, ResultSet rset) throws InvalidConstraintDataException {
        if (!this.isValid()) {
            throw new InvalidConstraintDataException("Can not apply invalid constraint");
        }
        GlobalExecution globalExec = new GlobalExecution();
        return globalExec.checkOSPatch(nodeList, this.m_reqOsPatch, rset);
    }

    public boolean checkCompatibility(String[] nodeList, String refNode, ResultSet resultSet) throws InvalidConstraintDataException {
        Trace.out((String)("Checking compatibility:" + this));
        if (!this.isValid()) {
            throw new InvalidConstraintDataException("Invalid constraint. Compatibility check can not proceed");
        }
        GlobalExecution globalExec = new GlobalExecution();
        boolean cmdStatus = globalExec.checkOSPatch(nodeList, this.m_reqOsPatch, resultSet);
        if (refNode == null || refNode.trim().length() == 0) {
            return cmdStatus;
        }
        Hashtable ht = resultSet.getResultTable();
        if (!ht.containsKey(refNode)) {
            Trace.out((String)"==== ERROR: refnode data missing");
            resultSet.addResult(nodeList, 2);
            resultSet.setStatus();
            return false;
        }
        Result refResult = (Result)ht.get(refNode);
        if (refResult.getStatus() == 2) {
            Trace.out((String)"==== ERROR: execution error at refnode");
            resultSet.addResult(nodeList, 2);
            resultSet.setStatus();
            return false;
        }
        if (refResult.getResultInfoSet().size() > 0) {
            this.m_refStatus = (String)refResult.getResultInfoSet().elementAt(0);
        }
        Trace.out((String)("==== Reference data: " + this.m_refStatus));
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            boolean compStatus;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (node.equals(refNode)) {
                result.setStatus(1);
                continue;
            }
            if (result.getStatus() == 2) continue;
            String sPatchAppl = ReportUtil.UNKNOWN;
            if (result.getResultInfoSet().size() > 0) {
                sPatchAppl = (String)result.getResultInfoSet().elementAt(0);
                sPatchAppl = this.formatOSPatchDisplayString(sPatchAppl);
            }
            Trace.out((String)("==== Refdata:" + this.m_refStatus + "Nodedata: " + sPatchAppl));
            boolean bl = compStatus = this.m_refStatus.equals(sPatchAppl);
            if (compStatus) {
                result.setStatus(1);
                Trace.out((String)"==== Result status reset to op_successful");
                continue;
            }
            result.setStatus(3);
            Trace.out((String)"==== Result status reset to vf_failed");
        }
        resultSet.setStatus();
        return cmdStatus;
    }

    public void report(ResultSet rsltSet) {
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{CONSTRAINT_NAME, this.formatOSPatchDisplayString(this.m_reqOsPatch)}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.APPLIED, ReportUtil.REQUIRED, ReportUtil.COMMENT);
        Hashtable t = rsltSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            String sPatchAppl = ReportUtil.MISSING;
            if (result.getResultInfoSet().size() > 0) {
                sPatchAppl = (String)result.getResultInfoSet().elementAt(0);
                sPatchAppl = this.formatOSPatchDisplayString(sPatchAppl);
            }
            if (result.getStatus() == 1) {
                ReportUtil.writeRecord(node, sPatchAppl, this.formatOSPatchDisplayString(this.m_reqOsPatch), ReportUtil.PASSED);
                continue;
            }
            if (result.getStatus() == 3) {
                ReportUtil.writeRecord(node, sPatchAppl, this.formatOSPatchDisplayString(this.m_reqOsPatch), ReportUtil.FAILED);
                continue;
            }
            ReportUtil.writeRecord(node, ReportUtil.UNKNOWN, this.formatOSPatchDisplayString(this.m_reqOsPatch), ReportUtil.FAILED);
        }
        if (rsltSet.getStatus() == 1) {
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{CONSTRAINT_NAME, this.formatOSPatchDisplayString(this.m_reqOsPatch)}));
        } else {
            ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{CONSTRAINT_NAME, this.formatOSPatchDisplayString(this.m_reqOsPatch)}));
            ReportUtil.printErrorNodes(rsltSet);
        }
    }

    public void reportCompatibility(ResultSet resultSet) {
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("1006", false, (Object[])new String[]{CONSTRAINT_NAME, this.formatOSPatchDisplayString(this.m_reqOsPatch)}));
        ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.APPLIED);
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            String sPatchAppl = ReportUtil.UNKNOWN;
            if (result.getResultInfoSet().size() > 0) {
                sPatchAppl = (String)result.getResultInfoSet().elementAt(0);
                sPatchAppl = this.formatOSPatchDisplayString(sPatchAppl);
            }
            String instStatus = result.getStatus() == 1 ? sPatchAppl : (result.getStatus() == 3 ? sPatchAppl : ReportUtil.UNKNOWN);
            ReportUtil.surewriteRecord(node, instStatus);
        }
        if (t.size() > 1) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1008", false, (Object[])new String[]{CONSTRAINT_NAME, this.formatOSPatchDisplayString(this.m_reqOsPatch)}));
        }
    }

    public void reportCompatibility(String refNode, ResultSet resultSet) {
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("1010", false, (Object[])new String[]{CONSTRAINT_NAME, this.formatOSPatchDisplayString(this.m_reqOsPatch), refNode}));
        ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.APPLIED, ReportUtil.REF_STATUS, ReportUtil.COMMENT);
        Hashtable ht = resultSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String comment;
            String cnStatus;
            String node = (String)e.nextElement();
            if (node.equals(refNode)) continue;
            Result result = (Result)ht.get(node);
            String sPatchAppl = ReportUtil.UNKNOWN;
            if (result.getResultInfoSet().size() > 0) {
                sPatchAppl = (String)result.getResultInfoSet().elementAt(0);
                sPatchAppl = this.formatOSPatchDisplayString(sPatchAppl);
            }
            if (result.getStatus() == 1) {
                cnStatus = sPatchAppl;
                comment = ReportUtil.MATCHED;
            } else if (result.getStatus() == 3) {
                cnStatus = sPatchAppl;
                comment = ReportUtil.MISMATCHED;
            } else {
                cnStatus = ReportUtil.UNKNOWN;
                comment = ReportUtil.MISMATCHED;
            }
            ReportUtil.surewriteRecord(node, cnStatus, this.m_refStatus, comment);
        }
        if (resultSet.getStatus() == 1) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
        }
    }

    private String formatOSPatchDisplayString(String patch) {
        if (this.m_osPatchDisplayTag == null) {
            NativeSystem nativeSystem = new SystemFactory().CreateSystem();
            this.m_osPatchDisplayTag = nativeSystem.isUnixSystem() ? s_msgBundle.getMessage("9694", false) : s_msgBundle.getMessage("9693", false);
        }
        return this.m_osPatchDisplayTag + " " + patch;
    }
}

