/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.config.Constraint;
import oracle.ops.verification.framework.config.InvalidConstraintDataException;
import oracle.ops.verification.framework.config.PeerCompatible;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.TaskPackage;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oip.oipc.oipcf.OipcfFixUpResult;
import oracle.sysman.prov.fixup.PackageFixes;

public class PackageConstraint
extends Constraint
implements PeerCompatible {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1055", false);
    private String m_reqPackage;
    private String m_pkgName;
    private String m_refStatus = ReportUtil.UNKNOWN;
    private boolean m_isFixupReqd;
    private TaskPackage m_task;

    public PackageConstraint(String quali, String fbaction, String val) {
        super("PACKAGE", quali, fbaction);
        this.m_reqPackage = val;
        this.setValid(false);
    }

    public PackageConstraint(Hashtable ht) throws InvalidConstraintDataException {
        super("PACKAGE");
        this.validate(ht);
        this.m_qualifier = (String)ht.get("Qualifier");
        this.m_fbAction = (String)ht.get("FallbackAction");
        this.m_reqPackage = this.m_qualifier.equals("GTE") ? this.getFirstRefData() : (String)ht.get("KeyData");
        this.setValid(true);
    }

    public void setFixupReqd(boolean isFixupReqd) {
        this.m_isFixupReqd = isFixupReqd;
    }

    public void setTask(TaskPackage task) {
        this.m_task = task;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append("[Qualifier: " + this.m_qualifier);
        sb.append(", FallbackAction: " + this.m_fbAction);
        sb.append(", Package reqd: " + this.m_reqPackage + "]");
        return sb.toString();
    }

    public void validate(Hashtable ht) throws InvalidConstraintDataException {
        int dsetlen;
        super.validate(ht);
        if (!((String)ht.get("Type")).equals("PACKAGE")) {
            throw new InvalidConstraintDataException("Constraint type does not match");
        }
        String quali = (String)ht.get("Qualifier");
        if (!(quali.equals("EXIST") || quali.equals("COMPARE") || quali.equals("GTE") || quali.equals("INRANGE"))) {
            throw new InvalidConstraintDataException("Qualifier '" + quali + "' is not supported for " + this.getClass().getName());
        }
        if (!ht.containsKey("KeyData")) {
            throw new InvalidConstraintDataException("Missing KeyData");
        }
        this.m_pkgName = (String)ht.get("KeyData");
        if (quali.equals("INRANGE")) {
            if (!ht.containsKey("KeyData")) {
                throw new InvalidConstraintDataException("Missing RefData");
            }
            Vector rfVec = (Vector)ht.get("RefData");
            String[] directives = rfVec.toArray(new String[rfVec.size()]);
            for (int i = 0; i < directives.length; ++i) {
                this.validateDirective(directives[i]);
            }
        }
        int n = dsetlen = quali.equals("INRANGE") || quali.equals("GTE") ? 5 : 4;
        if (ht.size() != dsetlen) {
            String errtxt = "Invalid data set for " + this.getClass().getName() + ". EXPECTED: " + dsetlen + ", FOUND: " + ht.size();
            throw new InvalidConstraintDataException(errtxt);
        }
    }

    public boolean applyConstraint(String[] nodeList, ResultSet rset) throws InvalidConstraintDataException {
        if (!this.isValid()) {
            throw new InvalidConstraintDataException("Can not apply invalid constraint");
        }
        GlobalExecution globalExec = new GlobalExecution();
        return globalExec.checkPackage(nodeList, this, rset);
    }

    public boolean checkCompatibility(String[] nodeList, String refNode, ResultSet resultSet) throws InvalidConstraintDataException {
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("Checking compatibility:" + this));
        }
        if (!this.isValid()) {
            throw new InvalidConstraintDataException("Invalid constraint. Compatibility check can not proceed");
        }
        GlobalExecution globalExec = new GlobalExecution();
        boolean cmdStatus = globalExec.checkPackage(nodeList, this, resultSet);
        if (refNode == null || refNode.trim().length() == 0) {
            return cmdStatus;
        }
        Hashtable ht = resultSet.getResultTable();
        if (!ht.containsKey(refNode)) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"==== ERROR: refnode data missing");
            }
            resultSet.addResult(nodeList, 2);
            resultSet.setStatus();
            return false;
        }
        Result refResult = (Result)ht.get(refNode);
        if (refResult.getStatus() == 2) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"==== ERROR: execution error at refnode");
            }
            resultSet.addResult(nodeList, 2);
            resultSet.setStatus();
            return false;
        }
        if (refResult.getResultInfoSet().size() > 0) {
            this.m_refStatus = (String)refResult.getResultInfoSet().elementAt(0);
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("==== Reference data: " + this.m_refStatus));
        }
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            boolean compStatus;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (node.equals(refNode)) {
                result.setStatus(1);
                continue;
            }
            if (result.getStatus() == 2) continue;
            String sPkgFound = ReportUtil.UNKNOWN;
            if (result.getResultInfoSet().size() > 0) {
                sPkgFound = (String)result.getResultInfoSet().elementAt(0);
            }
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("==== Refdata:" + this.m_refStatus + "Nodedata: " + sPkgFound));
            }
            boolean bl = compStatus = this.m_refStatus.equals(sPkgFound);
            if (compStatus) {
                result.setStatus(1);
                if (!Trace.isLevelEnabled((int)1)) continue;
                Trace.out((String)"==== Result status reset to op_successful");
                continue;
            }
            result.setStatus(3);
            if (!Trace.isLevelEnabled((int)1)) continue;
            Trace.out((String)"==== Result status reset to vf_failed");
        }
        resultSet.setStatus();
        return cmdStatus;
    }

    public void report(ResultSet rsltSet) {
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_reqPackage}));
        ReportUtil.writeColHeaders_2eq(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.COMMENT);
        Hashtable ht = rsltSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String comment;
            String pkgStatus;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 1) {
                pkgStatus = (String)result.getResultInfoSet().elementAt(0);
                rsltSet.getResult(node).setHasResultValues(true);
                rsltSet.getResult(node).setExpectedValue(this.m_reqPackage);
                rsltSet.getResult(node).setActualValue(pkgStatus);
                comment = ReportUtil.PASSED;
            } else if (result.getStatus() == 3) {
                ArrayList<String> fileList;
                String actionMsg;
                String causeMsg;
                String errMsg;
                Vector vec = result.getResultInfoSet();
                if (vec.isEmpty()) {
                    pkgStatus = ReportUtil.MISSING;
                    errMsg = s_msgBundle.getMessage("7532", true, (Object[])new String[]{this.m_pkgName, node});
                    causeMsg = s_msgBundle.getCause("7532", false);
                    actionMsg = s_msgBundle.getAction("7532", false);
                    errDesc = new ErrorDescription(errMsg, causeMsg, actionMsg);
                    rsltSet.getResult(node).addErrorDescription(errDesc);
                    rsltSet.getResult(node).setHasResultValues(true);
                    rsltSet.getResult(node).setExpectedValue(this.m_reqPackage);
                    rsltSet.getResult(node).setActualValue(pkgStatus);
                } else {
                    pkgStatus = (String)result.getResultInfoSet().elementAt(0);
                    errMsg = s_msgBundle.getMessage("7533", true, (Object[])new String[]{this.m_pkgName, node, this.m_reqPackage, pkgStatus});
                    causeMsg = s_msgBundle.getCause("7533", false);
                    actionMsg = s_msgBundle.getAction("7533", false);
                    errDesc = new ErrorDescription(errMsg, causeMsg, actionMsg);
                    rsltSet.getResult(node).addErrorDescription(errDesc);
                    rsltSet.getResult(node).setHasResultValues(true);
                    rsltSet.getResult(node).setExpectedValue(this.m_reqPackage);
                    rsltSet.getResult(node).setActualValue(pkgStatus);
                }
                comment = ReportUtil.FAILED;
                if (this.m_isFixupReqd && this.m_pkgName.matches("cvuqdisk") && (fileList = this.m_task.getFixupFiles(node, rsltSet)) != null) {
                    Map<String, String> groupEnv = Collections.synchronizedMap(new HashMap());
                    groupEnv.put("CVUQDISK_GRP", VerificationUtil.getCurrentGroup());
                    OipcfFixUpResult fixupRslt = PackageFixes.enableOraclePackages((String)fileList.get(1), (String)fileList.get(0), groupEnv, (String)VerificationUtil.getCVUSubDirPath(), (String[])new String[]{VerificationUtil.getCvuqdiskRPMname()});
                    if (fixupRslt.getFixUpResult() != OipcfFixUpResult.PASSED) {
                        String errMsg2 = s_msgBundle.getMessage("7727", false, (Object[])new String[]{this.m_reqPackage, node});
                        OiixException oiEx = fixupRslt.getFixUpException();
                        if (oiEx != null) {
                            errMsg2 = errMsg2 + VerificationConstants.LSEP + oiEx.getErrorMessage();
                        }
                        if (Trace.isLevelEnabled((int)1)) {
                            Trace.out((String)errMsg2);
                        }
                        rsltSet.addErrorDescription(node, new ErrorDescription(errMsg2));
                        this.m_task.addFixupGenError(node, errMsg2);
                    } else {
                        if (Trace.isLevelEnabled((int)1)) {
                            Trace.out((String)("Fixup was successfully generated for installing package '" + this.m_reqPackage + "' on node '" + node + "'"));
                        }
                        rsltSet.getResult(node).setFixupAvailable(true);
                    }
                }
            } else {
                pkgStatus = ReportUtil.UNKNOWN;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7534", false, (Object[])new String[]{this.m_pkgName, node}));
                rsltSet.getResult(node).addErrorDescription(errDesc);
                comment = ReportUtil.UNKNOWN;
            }
            ReportUtil.writeRecord_2eq(node, pkgStatus, comment);
        }
        if (rsltSet.getStatus() == 1) {
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_reqPackage}));
        } else {
            this.m_task.reportFixupGenErrors();
            ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_reqPackage}));
            ReportUtil.printErrorNodes(rsltSet);
        }
    }

    public void reportCompatibility(ResultSet resultSet) {
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("1006", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_reqPackage}));
        ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS);
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            String instStatus = result.getStatus() == 1 ? (String)result.getResultInfoSet().elementAt(0) : (result.getStatus() == 3 ? ReportUtil.MISSING : ReportUtil.UNKNOWN);
            ReportUtil.surewriteRecord(node, instStatus);
        }
        if (t.size() > 1) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1008", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_reqPackage}));
        }
    }

    public void reportCompatibility(String refNode, ResultSet resultSet) {
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("1010", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_reqPackage, refNode}));
        ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.STATUS, ReportUtil.REF_STATUS, ReportUtil.COMMENT);
        Hashtable ht = resultSet.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String comment;
            String cnStatus;
            String node = (String)e.nextElement();
            if (node.equals(refNode)) continue;
            Result result = (Result)ht.get(node);
            String sPkgFound = ReportUtil.UNKNOWN;
            if (result.getResultInfoSet().size() > 0) {
                sPkgFound = (String)result.getResultInfoSet().elementAt(0);
            }
            if (result.getStatus() == 1) {
                cnStatus = sPkgFound;
                comment = ReportUtil.MATCHED;
            } else if (result.getStatus() == 3) {
                cnStatus = sPkgFound;
                comment = ReportUtil.MISMATCHED;
            } else {
                cnStatus = ReportUtil.UNKNOWN;
                comment = ReportUtil.MISMATCHED;
            }
            ReportUtil.surewriteRecord(node, cnStatus, this.m_refStatus, comment);
        }
        if (resultSet.getStatus() == 1) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
        }
    }
}

