/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.config;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.Constraint;
import oracle.ops.verification.framework.config.InvalidConstraintDataException;
import oracle.ops.verification.framework.config.PeerCompatible;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;

public class RegKeyConstraint
extends Constraint
implements PeerCompatible {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1061", false);
    private String m_regKey;
    private String m_reqVal;

    public RegKeyConstraint(String quali, String fbaction, String regkey, String val) {
        super("REGENTRY", quali, fbaction);
        this.m_regKey = regkey;
        this.m_reqVal = val;
        this.setValid(false);
    }

    public RegKeyConstraint(Hashtable ht) throws InvalidConstraintDataException {
        super("REGENTRY");
        this.validate(ht);
        this.m_qualifier = (String)ht.get("Qualifier");
        this.m_fbAction = (String)ht.get("FallbackAction");
        this.m_regKey = (String)ht.get("KeyData");
        if (this.m_qualifier.equals("EQUAL")) {
            Vector rdVec = (Vector)ht.get("RefData");
            this.m_reqVal = (String)rdVec.firstElement();
        }
        this.setValid(true);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append("[Qualifier: " + this.m_qualifier);
        sb.append(", FallbackAction: " + this.m_fbAction);
        sb.append(", RegKey: " + this.m_regKey);
        sb.append(", Required Value: " + this.m_reqVal + "]");
        return sb.toString();
    }

    public void validate(Hashtable ht) throws InvalidConstraintDataException {
        super.validate(ht);
        if (!((String)ht.get("Type")).equals("REGENTRY")) {
            throw new InvalidConstraintDataException("Constraint type does not match. Type specified: " + (String)ht.get("Type"));
        }
        int dsetlen = 0;
        String quali = (String)ht.get("Qualifier");
        if (!ht.containsKey("KeyData")) {
            throw new InvalidConstraintDataException("Missing KeyData");
        }
        if (quali.equals("EQUAL")) {
            if (!ht.containsKey("RefData")) {
                throw new InvalidConstraintDataException("Missing RefData");
            }
            dsetlen = 5;
            if (ht.size() != dsetlen) {
                String errtxt = "Invalid data set for " + this.getClass().getName() + ". EXPECTED: " + dsetlen + " items, FOUND: " + ht.size() + " items.";
                throw new InvalidConstraintDataException(errtxt);
            }
        } else if (quali.equals("EXIST") || quali.equals("COMPARE")) {
            dsetlen = 4;
            if (ht.size() != dsetlen) {
                String errtxt = "Invalid data set for " + this.getClass().getName() + ". EXPECTED: " + dsetlen + " items, FOUND: " + ht.size() + " items.";
                throw new InvalidConstraintDataException(errtxt);
            }
        } else {
            throw new InvalidConstraintDataException("Qualifier '" + quali + "' is not supported for " + this.getClass().getName());
        }
    }

    public boolean applyConstraint(String[] nodeList, ResultSet rset) throws InvalidConstraintDataException {
        if (!this.isValid()) {
            throw new InvalidConstraintDataException("Can not apply invalid constraint");
        }
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.getRegKeyData(nodeList, this.m_regKey, rset);
        boolean grandStatus = true;
        Hashtable ht = rset.getResultTable();
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            boolean conStatus;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (result.getStatus() == 2) {
                grandStatus = false;
                continue;
            }
            String data = (String)result.getResultInfoSet().firstElement();
            Trace.out((String)("==== Node: " + node + ", registry data: " + data));
            if (this.m_qualifier.equals("EXIST")) {
                conStatus = data != null && data.trim().length() > 0;
            } else if (this.m_qualifier.equals("EQUAL")) {
                conStatus = this.m_reqVal.equals(data);
            } else {
                throw new InvalidConstraintDataException("Unexpected qualifier while applying constraint.");
            }
            if (conStatus) {
                result.setStatus(1);
                Trace.out((String)"==== Result status reset to op_successful");
                continue;
            }
            result.setStatus(3);
            Trace.out((String)"==== Result status reset to vf_failed");
            grandStatus = false;
        }
        rset.setStatus();
        return grandStatus;
    }

    public boolean checkCompatibility(String[] nodeList, String refNode, ResultSet resultSet) throws InvalidConstraintDataException {
        Trace.out((String)"Checking compatibility");
        if (!this.isValid()) {
            throw new InvalidConstraintDataException("Invalid constraint. Compatibility check can not proceed");
        }
        GlobalExecution globalExec = new GlobalExecution();
        boolean cmdStatus = globalExec.getRegKeyData(nodeList, this.m_regKey, resultSet);
        if (refNode == null || refNode.trim().length() == 0) {
            return cmdStatus;
        }
        Hashtable ht = resultSet.getResultTable();
        if (!ht.containsKey(refNode)) {
            Trace.out((String)"==== ERROR: refnode data missing");
            return false;
        }
        Result refResult = (Result)ht.get(refNode);
        if (refResult.getStatus() == 2) {
            Trace.out((String)"==== ERROR: execution error at refnode");
            resultSet.addResult(nodeList, 2);
            return false;
        }
        try {
            this.m_reqVal = (String)refResult.getResultInfoSet().firstElement();
        }
        catch (NoSuchElementException nse) {
            Trace.out((String)nse.getMessage());
        }
        Trace.out((String)("==== Reference data: " + this.m_reqVal));
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            boolean compStatus;
            Result result;
            String node = (String)e.nextElement();
            if (node.equals(refNode) || (result = (Result)ht.get(node)).getStatus() == 2) continue;
            String data = (String)refResult.getResultInfoSet().firstElement();
            Trace.out((String)("==== Refdata:" + this.m_reqVal + "Nodedata: " + data));
            boolean bl = compStatus = data.equals(this.m_reqVal);
            if (compStatus) {
                result.setStatus(1);
                Trace.out((String)"==== Result status reset to op_successful");
                continue;
            }
            result.setStatus(3);
            Trace.out((String)"==== Result status reset to vf_failed");
        }
        return cmdStatus;
    }

    public void report(ResultSet resultSet) {
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1012", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_regKey}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.CONFIGURED, ReportUtil.REQUIRED, ReportUtil.COMMENT);
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String avlData;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            try {
                avlData = (String)result.getResultInfoSet().firstElement();
            }
            catch (NoSuchElementException nse) {
                Trace.out((String)nse.getMessage());
                avlData = ReportUtil.UNKNOWN;
            }
            String comment = result.getStatus() == 1 ? (avlData.equals(this.m_reqVal) ? ReportUtil.PASSED : ReportUtil.FAILED) : ReportUtil.FAILED;
            ReportUtil.writeRecord(node, avlData, this.m_reqVal, comment);
        }
        if (resultSet.getStatus() == 1) {
            ReportUtil.printResult(s_msgBundle.getMessage("1002", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_regKey}));
        } else {
            ReportUtil.printResult(s_msgBundle.getMessage("1004", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_regKey}));
            ReportUtil.printErrorNodes(resultSet);
        }
    }

    public void reportCompatibility(ResultSet resultSet) {
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("1006", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_regKey}));
        ReportUtil.surewriteEqualColHeaders(ReportUtil.NODENAME, ReportUtil.CONFIGURED);
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String avlData;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            try {
                avlData = (String)result.getResultInfoSet().firstElement();
            }
            catch (NoSuchElementException nse) {
                Trace.out((String)nse.getMessage());
                avlData = ReportUtil.UNKNOWN;
            }
            ReportUtil.surewriteEqualRecord(node, avlData);
        }
        if (t.size() > 1) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1008", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_regKey}));
        }
    }

    public void reportCompatibility(String refNode, ResultSet resultSet) {
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("1010", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_regKey, refNode}));
        ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.CONFIGURED, ReportUtil.REF_STATUS, ReportUtil.COMMENT);
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String comment;
            String avlData;
            String node = (String)e.nextElement();
            if (node.equals(refNode)) continue;
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                avlData = (String)result.getResultInfoSet().firstElement();
                comment = ReportUtil.MATCHED;
            } else if (result.getStatus() == 3) {
                avlData = (String)result.getResultInfoSet().firstElement();
                comment = ReportUtil.MISMATCHED;
            } else {
                avlData = ReportUtil.UNKNOWN;
                comment = ReportUtil.MISMATCHED;
            }
            ReportUtil.writeRecord(node, avlData, this.m_reqVal, comment);
        }
        if (resultSet.getStatus() == 1) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
        }
    }
}

