/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.sysman.ois.oisc.oiscu.OiscuFatalException;
import oracle.sysman.ois.oisc.oiscx.OiscxComponentBuilder;
import oracle.sysman.ois.oisc.oiscx.OiscxFileMapReader;
import oracle.sysman.ois.oisc.oiscx.OiscxFilesListBuilder;
import oracle.sysman.ois.oisc.oiscx.OiscxIncludeData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoftwareConfigXMLGenerator {
    String m_sMapFile = "";
    String m_sCompName = null;
    String m_sPathToSourceHome = null;
    String m_sCompLangs = "";
    private String SRCHOME_PROPERTY = "SRCHOME";
    Properties m_oProperties = new Properties();
    Properties m_oSLVProps = new Properties();
    List<String> m_generatedFiles = new ArrayList<String>();
    String crsConfigFilePerms = null;
    String crsConfigFiles = null;
    String excludeListFile = null;
    String relinkedListFile = null;
    List<String> crsConfigFilesHM = new ArrayList<String>();
    List<String> excludedFiles = new ArrayList<String>();
    List<String> relinkedFiles = new ArrayList<String>();
    HashMap<String, HashMap<String, String>> crsConfigFilePermsHM = new LinkedHashMap<String, HashMap<String, String>>();
    static boolean s_unixSystem = false;

    public static final void main(String[] args) {
        Trace.out((String)"HERE");
        if (args.length < 4) {
            System.err.println("Insufficient arguments.");
            SoftwareConfigXMLGenerator.printUsage();
            System.exit(-1);
        }
        try {
            new SoftwareConfigXMLGenerator().generate(args);
        }
        catch (MalformedURLException e) {
            System.out.println("Error occured while generating XML:");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (IOException e) {
            System.out.println("Error occured while generating XML:");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (SAXException e) {
            System.out.println("Error occured while generating XML:");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (ParserConfigurationException e) {
            System.out.println("Error occured while generating XML:");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (TransformerException e) {
            System.out.println("Error occured while generating XML:");
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public void generate(String[] args) throws IOException, MalformedURLException, SAXException, ParserConfigurationException, TransformerException {
        String outputXML = null;
        String componentName = null;
        String mapFileXSD = null;
        String srcHome = null;
        String[] mapFiles = null;
        boolean bIsHelp = false;
        for (int i = 0; !bIsHelp && i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-mapfiles") && mapFiles == null) {
                mapFiles = args[++i].trim().split(",");
            } else if (args[i].equalsIgnoreCase("-xsd") && mapFileXSD == null) {
                mapFileXSD = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-comp") && componentName == null) {
                componentName = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-output") && outputXML == null) {
                outputXML = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-srcHome") && srcHome == null) {
                srcHome = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-crsconfig_fileperms") && this.crsConfigFilePerms == null) {
                this.crsConfigFilePerms = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-crsconfig_files") && this.crsConfigFiles == null) {
                this.crsConfigFiles = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-exclude_list") && this.excludeListFile == null) {
                this.excludeListFile = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-relinked_list") && this.relinkedListFile == null) {
                this.relinkedListFile = args[++i].trim();
            } else {
                bIsHelp = true;
                break;
            }
            if (!args[i].trim().equalsIgnoreCase("-help")) continue;
            bIsHelp = true;
            break;
        }
        if (bIsHelp) {
            SoftwareConfigXMLGenerator.printUsage();
            return;
        }
        File outputXMLFile = new File(outputXML);
        Document softwareDocument = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder softwareConfBuilder = factory.newDocumentBuilder();
        Element softwareComponentsEle = null;
        Element existingSoftCompEle = null;
        if (outputXMLFile.exists()) {
            softwareDocument = softwareConfBuilder.parse(outputXMLFile);
            softwareComponentsEle = softwareDocument.getDocumentElement();
            NodeList softComponentList = softwareComponentsEle.getElementsByTagName("SoftwareComponent");
            for (int i = 0; i < softComponentList.getLength(); ++i) {
                Element ele = (Element)softComponentList.item(i);
                if (!ele.getAttribute("Name").equals(componentName)) continue;
                existingSoftCompEle = ele;
            }
        } else {
            softwareDocument = softwareConfBuilder.newDocument();
            softwareComponentsEle = softwareDocument.createElement("SoftwareComponents");
        }
        Element softwareComponentEle = softwareDocument.createElement("SoftwareComponent");
        softwareComponentEle.setAttribute("Name", componentName);
        this.process(componentName, mapFileXSD, mapFiles, srcHome, this.crsConfigFiles, this.crsConfigFilePerms, softwareDocument, softwareComponentEle);
        if (existingSoftCompEle != null) {
            softwareComponentsEle.replaceChild(softwareComponentEle, existingSoftCompEle);
        } else {
            softwareComponentsEle.appendChild(softwareComponentEle);
        }
        this.printSoftwareConfFile(softwareComponentsEle, outputXML);
    }

    private static void printUsage() {
        System.out.println("Input Parameters:  -mapfiles <comma separated map file names>");
        System.out.println("-xsd <map file xsd schema>");
        System.out.println("-comp <cmponent name, crs|database>");
        System.out.println("-output <output xml file>");
        System.out.println("-srcHome <source home>");
        System.out.println("-crsconfig_fileperms <crs config file perms>");
        System.out.println("-crsconfig_files <crs config files>");
        System.out.println("-exclude_list <file containing list of files to be excluded>");
        System.out.println("-relinked_list <file containing list of files relinked>");
        System.out.println("-help <print usage>");
    }

    private void printSoftwareConfFile(Element rootElement, String outputFile) throws TransformerException, FileNotFoundException {
        DOMSource xmlSource = new DOMSource(rootElement);
        StreamResult result = new StreamResult(new FileOutputStream(outputFile));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(xmlSource, result);
    }

    public void process(String componentName, String schemaLoc, String[] m_sMapFiles, String srcHome, String crsConfigFiles, String crsConfigFilePerms, Document softwareDocument, Element softwareComponentEle) {
        String currentOSFamily = "unix";
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (!nativeSystem.isUnixSystem()) {
            currentOSFamily = "windows";
        }
        if ("crs".equalsIgnoreCase(componentName) && crsConfigFiles != null) {
            this.processCrsConfigFiles(crsConfigFiles, this.crsConfigFilesHM, currentOSFamily);
        }
        if ("crs".equalsIgnoreCase(componentName) && crsConfigFilePerms != null) {
            this.processCrsConfigFilePerms(crsConfigFilePerms, this.crsConfigFilePermsHM, currentOSFamily);
        }
        if (this.excludeListFile != null) {
            this.processExcludeFiles();
        }
        if (this.relinkedListFile != null) {
            this.processRelinkedFiles();
        }
        try {
            System.setProperty("OSP_Schema_Location", schemaLoc);
            String key = "%" + this.SRCHOME_PROPERTY + "%";
            this.m_oSLVProps.setProperty(key, srcHome);
            for (String mapFile : m_sMapFiles) {
                File fMAP = new File(mapFile);
                if (!fMAP.exists() || !fMAP.isFile()) {
                    this.logErr("Invalid MAP file:" + mapFile, null, 0, false);
                    continue;
                }
                this.generateFileList(mapFile, softwareDocument, softwareComponentEle, this.crsConfigFilesHM, this.crsConfigFilePermsHM);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void processCrsConfigFilePerms(String crsConfigFilePerms, HashMap<String, HashMap<String, String>> crsConfigFilePermsHM, String currentOSFamily) {
        try {
            BufferedReader filePermsReader = new BufferedReader(new FileReader(crsConfigFilePerms));
            String line = null;
            while ((line = filePermsReader.readLine()) != null) {
                String fileName;
                String[] fileAttributes;
                String osList;
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || !(osList = (fileAttributes = line.split("\\s"))[0]).equalsIgnoreCase("all") && !osList.equalsIgnoreCase(currentOSFamily) || !(fileName = this.normalizePath(fileAttributes[1])).contains("%ORA_CRS_HOME%")) continue;
                fileName = fileName.replaceAll("ORA_CRS_HOME", "ORACLE_HOME");
                String fileOwner = fileAttributes[2];
                String fileGroup = fileAttributes[3];
                String filePerms = fileAttributes[4];
                HashMap<String, String> fileAttributeHM = new HashMap<String, String>();
                fileAttributeHM.put("OWNER", fileOwner);
                fileAttributeHM.put("GROUP", fileGroup);
                fileAttributeHM.put("PERMISSIONS", filePerms);
                crsConfigFilePermsHM.put(fileName, fileAttributeHM);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void processCrsConfigFiles(String crsConfigFiles, List<String> crsConfigFilesHM, String currentOSFamily) {
        try {
            BufferedReader filesReader = new BufferedReader(new FileReader(crsConfigFiles));
            String line = null;
            while ((line = filesReader.readLine()) != null) {
                String destPath;
                String[] fileMapping;
                String osList;
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || !(osList = (fileMapping = line.split("\\s"))[0]).equalsIgnoreCase("all") && !osList.equalsIgnoreCase(currentOSFamily)) continue;
                String srcPath = fileMapping[1];
                if (srcPath.contains("%ORA_CRS_HOME%")) {
                    srcPath = this.normalizePath(srcPath.replaceAll("ORA_CRS_HOME", "ORACLE_HOME"));
                }
                if (!(destPath = this.normalizePath(fileMapping[2])).contains("%ORA_CRS_HOME%")) continue;
                destPath = destPath.replaceAll("ORA_CRS_HOME", "ORACLE_HOME");
                crsConfigFilesHM.add(srcPath + "|" + destPath);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void processExcludeFiles() {
        try {
            BufferedReader filesReader = new BufferedReader(new FileReader(this.excludeListFile));
            String line = null;
            while ((line = filesReader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                String destPath = line.trim();
                if (destPath.contains("%ORA_CRS_HOME%")) {
                    destPath = destPath.replaceAll("ORA_CRS_HOME", "ORACLE_HOME");
                }
                this.excludedFiles.add(this.normalizePath(destPath).toLowerCase());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processRelinkedFiles() {
        try {
            BufferedReader filesReader = new BufferedReader(new FileReader(this.relinkedListFile));
            String line = null;
            while ((line = filesReader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                String destPath = line.trim();
                if (destPath.contains("%ORA_CRS_HOME%")) {
                    destPath = destPath.replaceAll("ORA_CRS_HOME", "ORACLE_HOME");
                }
                this.relinkedFiles.add(this.normalizePath(destPath).toLowerCase());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean generateFileList(final String mapFile, Document softwareDocument, Element softwareComponentEle, List<String> crsConfigFilesHM, HashMap<String, HashMap<String, String>> crsConfigFilePermsHM) {
        OiscxFilesListBuilder oFileListBuilder = new OiscxFilesListBuilder(this.m_oSLVProps, this.m_sCompLangs){
            final HashMap<String, String> permissionHM;
            {
                super(x0, x1);
                this.permissionHM = new HashMap();
            }

            public void addInclude(OiscxIncludeData incl) throws SAXException {
                super.addInclude(incl);
                String dest = incl.getDest();
                dest = this.substituteMacrosInString(dest);
                String destRename = incl.getDestRename();
                destRename = this.substituteMacrosInString(destRename);
                this.permissionHM.put(dest + File.separator + destRename, incl.getPerm());
                Trace.out((String)(mapFile + ":" + dest + File.separator + destRename));
            }

            public ArrayList getFoundFilesList() {
                ArrayList foundFileList = super.getFoundFilesList();
                for (Object oFileO : foundFileList) {
                    OiscxFilesListBuilder.OiscxInclude oFile = (OiscxFilesListBuilder.OiscxInclude)oFileO;
                    String perm = this.permissionHM.get(oFile.getDest());
                    if (perm == null) continue;
                    oFile.setPerms(perm);
                }
                return foundFileList;
            }
        };
        oFileListBuilder.setStageLangs(Locale.ENGLISH.toString());
        OiscxFileMapReader oFileMapReader = new OiscxFileMapReader((OiscxComponentBuilder)oFileListBuilder);
        int pos = mapFile.lastIndexOf(".map.xml");
        String textLocation = mapFile.substring(0, pos);
        try {
            oFileMapReader.parse(null, textLocation);
        }
        catch (OiscuFatalException e) {
            this.logErr("Fatal Exception occured :" + e.getMessage(), null, 0, false);
            this.logErr("Failed to parse mapfile.Exiting", null, 0, false);
            return false;
        }
        ArrayList results = oFileListBuilder.getFoundFilesList();
        int iSize1 = results != null ? results.size() : 0;
        for (int i = 0; i < iSize1; ++i) {
            OiscxFilesListBuilder.OiscxInclude oFile = (OiscxFilesListBuilder.OiscxInclude)results.get(i);
            if (oFile == null) continue;
            this.createElement(softwareDocument, softwareComponentEle, oFile.getSource().getPath(), oFile.getDest(), oFile.getPerms(), crsConfigFilePermsHM);
        }
        for (String file : crsConfigFilesHM) {
            String[] srcDest = file.split("|");
            this.createElement(softwareDocument, softwareComponentEle, srcDest[0], srcDest[1], null, crsConfigFilePermsHM);
        }
        return true;
    }

    private void createElement(Document softwareDocument, Element softwareComponentEle, String src, String sDest, String permission, HashMap<String, HashMap<String, String>> crsConfigFilePermsHM) {
        String crsConfigPerm;
        Element softwareFileEle = null;
        String owner = null;
        String group = null;
        HashMap<String, String> crsConfigFileHM = crsConfigFilePermsHM.get(sDest);
        if (crsConfigFileHM != null && (crsConfigPerm = crsConfigFileHM.get("PERMISSIONS")) != null) {
            permission = crsConfigPerm;
        }
        if (this.excludedFiles.contains(this.normalizePath(sDest).toLowerCase())) {
            return;
        }
        if (this.isInstantiated(sDest)) {
            return;
        }
        if (this.m_generatedFiles.contains(sDest)) {
            return;
        }
        this.m_generatedFiles.add(sDest);
        sDest = this.normalizePath(sDest);
        String[] pathComponents = sDest.split(Pattern.quote(File.separator));
        String path = "";
        boolean binLibJlib = false;
        for (int j = 1; j < pathComponents.length - 1; ++j) {
            binLibJlib = pathComponents[j].equalsIgnoreCase("bin") || pathComponents[j].equalsIgnoreCase("lib") || pathComponents[j].equalsIgnoreCase("jlib");
            path = path + pathComponents[j] + File.separator;
        }
        if (!binLibJlib) {
            return;
        }
        String fileName = pathComponents[pathComponents.length - 1];
        if (this.relinkedFiles.contains(this.normalizePath(sDest).toLowerCase())) {
            permission = null;
        }
        softwareFileEle = softwareDocument.createElement("File");
        softwareComponentEle.appendChild(softwareFileEle);
        softwareFileEle.setAttribute("Path", path);
        softwareFileEle.setAttribute("Name", fileName);
        if (s_unixSystem && permission != null && permission.length() > 0) {
            softwareFileEle.setAttribute("Permissions", permission);
        }
        if (owner != null && owner.length() > 0) {
            softwareFileEle.setAttribute("Owner", owner);
        }
        if (group != null && group.length() > 0) {
            softwareFileEle.setAttribute("Group", group);
        }
    }

    private void logErr(String string, Object object, int information, boolean b) {
        System.err.println(information + " " + string);
    }

    private String normalizePath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        path = s_unixSystem ? path.replaceAll(Pattern.quote("\\"), Matcher.quoteReplacement(File.separator)) : path.replaceAll(Pattern.quote("/"), Matcher.quoteReplacement(File.separator));
        return path;
    }

    private boolean isInstantiated(String file) {
        if (file == null) {
            return false;
        }
        return file.toLowerCase().endsWith("sbs") || file.toLowerCase().endsWith("template") || file.toLowerCase().endsWith("tmpl") || file.toLowerCase().endsWith("dbl");
    }

    static {
        s_unixSystem = new SystemFactory().CreateSystem().isUnixSystem();
        int tracingLvl = 5;
        String traceFileName = "SoftwareConfigXMLGenerator.log";
        boolean tracetostdout = false;
        Trace.enableTracing();
        boolean conRes = Trace.configure((boolean)false, (boolean)tracetostdout, (boolean)true, (boolean)true, (String)traceFileName, (boolean)true);
        Trace.out((String)("Trace.configure returns " + conRes));
        Trace.setTraceLevel((int)tracingLvl);
        Trace.out((String)("tracing is on at level " + tracingLvl + " to file " + traceFileName));
    }
}

