/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.config;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.Constraint;
import oracle.ops.verification.framework.config.InvalidConstraintDataException;
import oracle.ops.verification.framework.config.PeerCompatible;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;

public class SpaceConstraint
extends Constraint
implements PeerCompatible {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1056", false);
    private String m_location;
    private long m_reqSpace = 0L;

    public SpaceConstraint(String quali, String fbaction, String loc, long val) {
        super("SPACE", quali, fbaction);
        this.m_location = loc;
        this.m_reqSpace = val;
        this.setValid(false);
    }

    public SpaceConstraint(Hashtable ht) throws InvalidConstraintDataException {
        super("SPACE");
        this.validate(ht);
        this.m_qualifier = (String)ht.get("Qualifier");
        this.m_fbAction = (String)ht.get("FallbackAction");
        this.m_location = (String)ht.get("KeyData");
        if (!this.m_qualifier.equals("COMPARE")) {
            Vector rdVec = (Vector)ht.get("RefData");
            this.m_reqSpace = Long.parseLong((String)rdVec.firstElement());
        }
        this.setValid(true);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getName());
        sb.append("[Qualifier: " + this.m_qualifier);
        sb.append(", FallbackAction: " + this.m_fbAction);
        sb.append(", Space reqd: " + this.m_reqSpace + "]");
        return sb.toString();
    }

    public void validate(Hashtable ht) throws InvalidConstraintDataException {
        super.validate(ht);
        if (!((String)ht.get("Type")).equals("SPACE")) {
            String mesg = s_msgBundle.getMessage("5450", false);
            throw new InvalidConstraintDataException(mesg);
        }
        String quali = (String)ht.get("Qualifier");
        int dsetlen = 0;
        if (!ht.containsKey("KeyData")) {
            throw new InvalidConstraintDataException(s_msgBundle.getMessage("5451", true, (Object[])new String[]{"KeyData"}));
        }
        if (quali.equals("GTE")) {
            if (!ht.containsKey("RefData")) {
                throw new InvalidConstraintDataException(s_msgBundle.getMessage("5452", true, (Object[])new String[]{"RefData"}));
            }
            dsetlen = 5;
            if (ht.size() != dsetlen) {
                String errtxt = s_msgBundle.getMessage("5453", true, (Object[])new String[]{this.getClass().getName(), new Integer(dsetlen).toString(), new Integer(ht.size()).toString()});
                throw new InvalidConstraintDataException(errtxt);
            }
        } else if (quali.equals("COMPARE")) {
            dsetlen = 4;
            if (ht.size() != dsetlen) {
                String errtxt = s_msgBundle.getMessage("5453", true, (Object[])new String[]{this.getClass().getName(), new Integer(dsetlen).toString(), new Integer(ht.size()).toString()});
                throw new InvalidConstraintDataException(errtxt);
            }
        } else {
            throw new InvalidConstraintDataException(s_msgBundle.getMessage("5454", true, (Object[])new String[]{quali, this.getClass().getName()}));
        }
    }

    public boolean applyConstraint(String[] nodeList, ResultSet rset) throws InvalidConstraintDataException {
        if (!this.isValid()) {
            throw new InvalidConstraintDataException(s_msgBundle.getMessage("5455", true));
        }
        GlobalExecution globalExec = new GlobalExecution();
        return globalExec.getFreeSpace(nodeList, this.m_location, rset);
    }

    public boolean checkCompatibility(String[] nodeList, String refNode, ResultSet resultSet) throws InvalidConstraintDataException {
        Trace.out((String)"Checking compatibility");
        if (!this.isValid()) {
            throw new InvalidConstraintDataException(s_msgBundle.getMessage("5456", true));
        }
        GlobalExecution globalExec = new GlobalExecution();
        boolean cmdStatus = globalExec.getFreeSpace(nodeList, this.m_location, resultSet);
        if (refNode == null || refNode.trim().length() == 0) {
            return cmdStatus;
        }
        Hashtable ht = resultSet.getResultTable();
        if (!ht.containsKey(refNode)) {
            Trace.out((String)"==== ERROR: refnode data missing");
            resultSet.addResult(nodeList, 2);
            resultSet.setStatus();
            return false;
        }
        Result refResult = (Result)ht.get(refNode);
        if (refResult.getStatus() == 2) {
            Trace.out((String)"==== ERROR: execution error at refnode");
            resultSet.addResult(nodeList, 2);
            resultSet.setStatus();
            return false;
        }
        try {
            Long lAvl = (Long)refResult.getResultInfoSet().firstElement();
            this.m_reqSpace = lAvl;
        }
        catch (NoSuchElementException nse) {
            Trace.out((String)nse.getMessage());
        }
        Trace.out((String)("==== Reference data: " + this.m_reqSpace));
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            boolean compStatus;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (node.equals(refNode)) {
                result.setStatus(1);
                continue;
            }
            if (result.getStatus() == 2) continue;
            long data = (Long)refResult.getResultInfoSet().firstElement();
            Trace.out((String)("==== Refdata:" + this.m_reqSpace + "Nodedata: " + data));
            boolean bl = compStatus = data == this.m_reqSpace;
            if (compStatus) {
                result.setStatus(1);
                Trace.out((String)"==== Result status reset to op_successful");
                continue;
            }
            result.setStatus(3);
            Trace.out((String)"==== Result status reset to vf_failed");
        }
        resultSet.setStatus();
        return cmdStatus;
    }

    public void report(ResultSet resultSet) {
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1011", false, (Object[])new String[]{CONSTRAINT_NAME, this.m_location}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.COMMENT);
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String tavl;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            long avlSpace = 0L;
            try {
                Long lAvl = (Long)result.getResultInfoSet().firstElement();
                avlSpace = lAvl;
                tavl = ReportUtil.unitizeByte(Long.toString(avlSpace));
            }
            catch (NoSuchElementException nse) {
                Trace.out((String)nse.getMessage());
                tavl = ReportUtil.UNKNOWN;
            }
            catch (NumberFormatException nfe) {
                Trace.out((String)nfe.getMessage());
                tavl = ReportUtil.UNKNOWN;
            }
            String comment = result.getStatus() == 1 ? (avlSpace >= this.m_reqSpace ? ReportUtil.PASSED : ReportUtil.FAILED) : ReportUtil.FAILED;
            String reqd = Long.toString(this.m_reqSpace);
            ReportUtil.writeRecord(node, tavl, ReportUtil.unitizeByte(reqd), comment);
        }
        if (resultSet.getStatus() == 1) {
            ReportUtil.printResult(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
        } else {
            ReportUtil.printResult(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
            ReportUtil.printErrorNodes(resultSet);
        }
    }

    public void reportCompatibility(ResultSet resultSet) {
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("1005", false, (Object[])new String[]{CONSTRAINT_NAME}));
        ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, CONSTRAINT_NAME);
        Hashtable t = resultSet.getResultTable();
        long avlSpace = 0L;
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String tavl;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            try {
                Long lAvl = (Long)result.getResultInfoSet().firstElement();
                avlSpace = lAvl;
                tavl = ReportUtil.unitizeByte(Long.toString(avlSpace));
            }
            catch (NoSuchElementException nse) {
                Trace.out((String)nse.getMessage());
                tavl = ReportUtil.UNKNOWN;
            }
            catch (NumberFormatException nfe) {
                Trace.out((String)nfe.getMessage());
                tavl = ReportUtil.UNKNOWN;
            }
            ReportUtil.surewriteRecord(node, tavl);
        }
        if (t.size() > 1) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1007", false, (Object[])new String[]{CONSTRAINT_NAME}));
        }
    }

    public void reportCompatibility(String refNode, ResultSet resultSet) {
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("1009", false, (Object[])new String[]{CONSTRAINT_NAME, refNode}));
        ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.AVAILABLE, ReportUtil.REF_STATUS, ReportUtil.COMMENT);
        Hashtable t = resultSet.getResultTable();
        String reqd = Long.toString(this.m_reqSpace);
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String comment;
            String avl;
            String node = (String)e.nextElement();
            if (node.equals(refNode)) continue;
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                avl = ((Long)result.getResultInfoSet().firstElement()).toString();
                comment = ReportUtil.MATCHED;
            } else if (result.getStatus() == 3) {
                avl = ((Long)result.getResultInfoSet().firstElement()).toString();
                comment = ReportUtil.MISMATCHED;
            } else {
                avl = ReportUtil.UNKNOWN;
                comment = ReportUtil.MISMATCHED;
            }
            ReportUtil.surewriteRecord(node, ReportUtil.unitizeByte(avl), ReportUtil.unitizeByte(reqd), comment);
        }
        if (resultSet.getStatus() == 1) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
        }
    }
}

