/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.config;

import java.util.Vector;
import java.util.regex.PatternSyntaxException;
import oracle.cluster.verification.OracleFileType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.AdminDataSegment;
import oracle.ops.verification.framework.config.InvalidDataFileException;
import oracle.ops.verification.framework.config.InvalidDataSegmentException;
import oracle.ops.verification.framework.config.VerificationDataManager;
import oracle.ops.verification.framework.util.VerificationUtil;

public class VDMUtil {
    static String s_fsep = System.getProperty("file.separator");
    static String BRANCH_PEER = "peer_compatibility";
    static String TAG_10gR1 = "10gR1";
    static String TAG_10gR2 = "10gR2";
    static AdminDataSegment s_admDataSeg;

    public static String getCmd4RemExec() {
        Trace.out((String)"==== getCmd4RemExec() called...");
        String remCmd = null;
        remCmd = s_admDataSeg.getProperty("rem_command");
        Trace.out((String)("==== PROP_REM_COMMAND = '" + remCmd + "'"));
        return remCmd;
    }

    public static String[] getCmdFiles4RemExec() {
        String[] cmdFiles;
        String filesStr = null;
        Trace.out((String)"==== getCmdFiles4RemExec() called...");
        filesStr = s_admDataSeg.getProperty("rem_cmd_files");
        Trace.out((String)("==== PROP_REM_CDMFILES = '" + filesStr + "'"));
        if (filesStr == null) {
            return null;
        }
        Vector vector = VerificationUtil.getTokens(filesStr, ",");
        if (vector != null) {
            cmdFiles = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                cmdFiles[i] = (String)vector.elementAt(i);
            }
        } else {
            cmdFiles = new String[]{};
        }
        return cmdFiles;
    }

    public static String getAdminDataFilename() {
        String cvhome = VerificationUtil.getCVHome();
        String fullpath = cvhome + "cv" + s_fsep + "cvdata" + s_fsep + "admin.xml";
        Trace.out((String)("==== Admin data file: " + fullpath));
        return fullpath;
    }

    public static String getSoftwareConfigDataFilename() {
        String cvhome = VerificationUtil.getCVHome();
        String fullpath = cvhome + "cv" + s_fsep + "cvdata" + s_fsep + "ora_software_cfg.xml";
        Trace.out((String)("==== Software Config data file: " + fullpath));
        return fullpath;
    }

    public static String getConstraintDataFilename() {
        String cvhome = VerificationUtil.getCVHome();
        String confile = s_admDataSeg.getProperty("file_constraints_xml");
        cvhome = cvhome.endsWith(s_fsep) ? cvhome : cvhome + s_fsep;
        confile = !confile.startsWith(s_fsep) ? confile : confile.substring(s_fsep.length());
        String fullpath = cvhome + "cv" + s_fsep + "cvdata" + s_fsep + confile;
        Trace.out((String)("==== Constraint data file: " + fullpath));
        return fullpath;
    }

    public static String getDefaultOCRVersion() {
        Trace.out((String)"==== getDefaultOCRVersion() called...");
        String ocrVer = null;
        ocrVer = s_admDataSeg.getProperty("def_ocr_ver");
        Trace.out((String)("==== PROP_DEF_OCR_VERSION = '" + ocrVer + "'"));
        return ocrVer;
    }

    public static String getNFSOptionsRegExp() throws InvalidDataFileException {
        return VDMUtil.getNFSOptionsRegExp(OracleFileType.RAC_DATA_FILES);
    }

    public static String getNFSOptionsRegExp(OracleFileType oracleFileType) throws InvalidDataFileException {
        Trace.out((String)"==== getNFSOptionsRegExp() called...");
        String nfsOptions = null;
        nfsOptions = s_admDataSeg.getProperty(oracleFileType.getAdminDataPropertyName());
        if (!VDMUtil.verifyNfsOptions(nfsOptions)) {
            Trace.out((String)("==== Invalid NFS options in admin.xml = '" + nfsOptions + "'"));
            throw new InvalidDataFileException("NFS Options specified in admin,xml has invalid syntax");
        }
        Trace.out((String)("==== PROP_DEF_NFS_OPTIONS = '" + nfsOptions + "'"));
        return nfsOptions;
    }

    private static boolean verifyNfsOptions(String xmlOptions) {
        String[] xmlOptionsArray = xmlOptions.split(",");
        if (xmlOptionsArray == null) {
            return false;
        }
        for (int i = 0; i < xmlOptionsArray.length; ++i) {
            if (VDMUtil.verifyXmlConstraints(xmlOptionsArray[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean verifyXmlConstraints(String xmlOptionsStr) {
        String[] condsArray = new String[2];
        if (xmlOptionsStr.indexOf("|") != -1) {
            condsArray = xmlOptionsStr.split("\\|", 2);
            return VDMUtil.verifyXmlConstraints(condsArray[0]) || VDMUtil.verifyXmlConstraints(condsArray[1]);
        }
        if (xmlOptionsStr.indexOf("&") != -1) {
            condsArray = xmlOptionsStr.split("\\&", 2);
            return VDMUtil.verifyXmlConstraints(condsArray[0]) && VDMUtil.verifyXmlConstraints(condsArray[1]);
        }
        return VDMUtil.verifyXmlOption(xmlOptionsStr);
    }

    private static boolean verifyXmlOption(String xmlOption) {
        String optionKey = new String("");
        if (xmlOption.indexOf("<=") != -1) {
            optionKey = xmlOption.split("<=")[0].trim();
            if (VDMUtil.verifyOptionValue(xmlOption, optionKey, "<=") != null) {
                return true;
            }
        } else if (xmlOption.indexOf(">=") != -1) {
            optionKey = xmlOption.split(">=")[0].trim();
            if (VDMUtil.verifyOptionValue(xmlOption, optionKey, ">=") != null) {
                return true;
            }
        } else if (xmlOption.indexOf("<") != -1) {
            optionKey = xmlOption.split("<")[0].trim();
            if (VDMUtil.verifyOptionValue(xmlOption, optionKey, "<") != null) {
                return true;
            }
        } else if (xmlOption.indexOf(">") != -1) {
            optionKey = xmlOption.split(">")[0].trim();
            if (VDMUtil.verifyOptionValue(xmlOption, optionKey, ">") != null) {
                return true;
            }
        } else if (xmlOption.indexOf("=") != -1) {
            optionKey = xmlOption.split("=")[0].trim();
            if (VDMUtil.verifyOptionValue(xmlOption, optionKey, "=") != null) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    private static Object verifyOptionValue(String mntOpts, String optionKey, String condition) {
        try {
            if (-1 == mntOpts.indexOf(optionKey)) {
                return null;
            }
            Object optValue = null;
            int startIndex = mntOpts.indexOf(optionKey);
            if (startIndex == -1) {
                return null;
            }
            int endIndex = mntOpts.indexOf(44, startIndex);
            if (endIndex == -1) {
                endIndex = mntOpts.length();
            }
            String optionsString = new String(mntOpts.substring(startIndex, endIndex));
            String[] optParts = optionsString.split(condition, 2);
            try {
                optValue = new Integer(optParts[1].trim());
            }
            catch (NumberFormatException e) {
                optValue = optParts[1].trim();
            }
            return optValue;
        }
        catch (IndexOutOfBoundsException ioobe) {
            return null;
        }
        catch (PatternSyntaxException pse) {
            return null;
        }
    }

    public static String getSysReqBranchNameForDatabase() {
        String disTag = VerificationUtil.getUniqueDistributionID();
        String brnName = "SystemRequirement_db_" + disTag + VDMUtil.getReleaseTag();
        Trace.out((String)("==== SysReq branch name for Database: " + brnName));
        return brnName;
    }

    public static String getSysReqBranchNameForCrs() {
        String disTag = VerificationUtil.getUniqueDistributionID();
        String brnName = "SystemRequirement_crs_" + disTag + VDMUtil.getReleaseTag();
        Trace.out((String)("==== SysReq branch name for CRS: " + brnName));
        return brnName;
    }

    public static String getPeerBranchName() {
        String disTag = VerificationUtil.getUniqueDistributionID();
        String brnName = BRANCH_PEER + "_" + disTag + VDMUtil.getReleaseTag();
        Trace.out((String)("==== Peer branch name: " + brnName));
        return brnName;
    }

    static String getReleaseTag() {
        String relTag = "";
        String reqRel = VerificationUtil.getRequestedRelease();
        if (reqRel != null && !reqRel.equalsIgnoreCase("11gR2")) {
            relTag = relTag + "_" + reqRel;
        }
        return relTag;
    }

    public static String getBranchName(String branchID) {
        String brName = null;
        if (branchID == null) {
            Trace.out((String)"==== Received requeste for brach with null brachID");
            return null;
        }
        brName = s_admDataSeg.getProperty(branchID);
        Trace.out((String)("==== PROP '" + branchID + "' = '" + brName + "'"));
        return brName;
    }

    public static String getDefaultOraInvGroup() {
        String oraInvGrp = s_admDataSeg.getProperty("def_group_oinstall");
        Trace.out((String)("==== PROP_DEF_GROUP_OINSTALL = '" + oraInvGrp + "'"));
        return oraInvGrp;
    }

    public static String getDefaultUmask() {
        String umask = s_admDataSeg.getProperty("def_umask");
        Trace.out((String)("==== PROP_DEF_UMASK = '" + umask + "'"));
        return umask;
    }

    public static String getDefaultDbaGroup() {
        String dbaGrp = s_admDataSeg.getProperty("def_group_dba");
        Trace.out((String)("==== PROP_DEF_GROUP_DBA = '" + dbaGrp + "'"));
        return dbaGrp;
    }

    public static String getDefaultAsmGroup() {
        String asmGrp = s_admDataSeg.getProperty("def_group_asmadmin");
        Trace.out((String)("==== PROP_DEF_GROUP_ASM = '" + asmGrp + "'"));
        return asmGrp;
    }

    public static String getDefaultAsmDisksPermissions() {
        String asmDisksPermissions = s_admDataSeg.getProperty("def_asm_disks_permissions");
        Trace.out((String)("==== PROP_DEF_ASM_DISKS_PERMISSIONS = '" + asmDisksPermissions + "'"));
        return asmDisksPermissions;
    }

    public static String getDefaultOperGroup() {
        String operGrp = s_admDataSeg.getProperty("def_group_oper");
        Trace.out((String)("==== PROP_DEF_GROUP_OPER = '" + operGrp + "'"));
        return operGrp;
    }

    public static String getDefaultTmpDir() {
        String tmpdir = s_admDataSeg.getProperty("def_dir_temp");
        Trace.out((String)("==== PROP_DEF_DIR_TEMP = '" + tmpdir + "'"));
        return tmpdir;
    }

    public static String getXCheckAppLoc() {
        String xChkAppLoc = null;
        xChkAppLoc = s_admDataSeg.getProperty("xcheck_app_location");
        Trace.out((String)("==== PROP_XCHK_APP_LOC = '" + xChkAppLoc + "'"));
        return xChkAppLoc;
    }

    public static String getDefaultSsh() {
        String app = null;
        app = s_admDataSeg.getProperty("def_ssh_app");
        Trace.out((String)("==== PROP_DEF_SSH_APP = '" + app + "'"));
        return app;
    }

    public static String getDefaultRsh() {
        String app = null;
        app = s_admDataSeg.getProperty("def_rsh_app");
        Trace.out((String)("==== PROP_DEF_RSH_APP = '" + app + "'"));
        return app;
    }

    public static String getDefaultScp() {
        String app = null;
        app = s_admDataSeg.getProperty("def_scp_app");
        Trace.out((String)("==== PROP_DEF_SCP_APP = '" + app + "'"));
        return app;
    }

    public static String getDefaultOcrOwner() {
        String app = null;
        app = s_admDataSeg.getProperty("def_ocr_owner");
        Trace.out((String)("==== PROP_OCR_OWNER = '" + app + "'"));
        return app;
    }

    public static String getDefaultOcrGroup() {
        String app = null;
        app = s_admDataSeg.getProperty("def_ocr_group");
        Trace.out((String)("==== PROP_OCR_GROUP = '" + app + "'"));
        return app;
    }

    public static String getDefaultOcrPermissions() {
        String app = null;
        app = s_admDataSeg.getProperty("def_ocr_permissions");
        Trace.out((String)("==== PROP_OCR_PERMISSIONS = '" + app + "'"));
        return app;
    }

    public static String getDefaultOcrSize() {
        String app = null;
        app = s_admDataSeg.getProperty("def_ocr_size");
        Trace.out((String)("==== PROP_OCR_SIZE = '" + app + "'"));
        return app;
    }

    public static String getDefaultOcrLocOwner() {
        String app = null;
        app = s_admDataSeg.getProperty("def_ocr_loc_owner");
        Trace.out((String)("==== PROP_OCR_LOC_OWNER = '" + app + "'"));
        return app;
    }

    public static String getDefaultOcrLocGroup() {
        String app = null;
        app = s_admDataSeg.getProperty("def_ocr_loc_group");
        Trace.out((String)("==== PROP_OCR_LOC_GROUP = '" + app + "'"));
        return app;
    }

    public static String getDefaultOcrLocPermissions() {
        String app = null;
        app = s_admDataSeg.getProperty("def_ocr_loc_permissions");
        Trace.out((String)("==== PROP_OCR_LOC_PERMISSIONS = '" + app + "'"));
        return app;
    }

    public static String getDefaultOlrOwnerCRS() {
        String app = null;
        app = s_admDataSeg.getProperty("def_olr_owner_crs");
        Trace.out((String)("==== PROP_OLR_OWNER = '" + app + "'"));
        return app;
    }

    public static String getDefaultOlrOwnerSIHA() {
        String app = null;
        app = s_admDataSeg.getProperty("def_olr_owner_siha");
        Trace.out((String)("==== PROP_OLR_OWNER = '" + app + "'"));
        return app;
    }

    public static String getDefaultOlrGroup() {
        String app = null;
        app = s_admDataSeg.getProperty("def_olr_group");
        Trace.out((String)("==== PROP_OLR_GROUP = '" + app + "'"));
        return app;
    }

    public static String getDefaultOlrPermissions() {
        String app = null;
        app = s_admDataSeg.getProperty("def_olr_permissions");
        Trace.out((String)("==== PROP_OLR_PERMISSIONS = '" + app + "'"));
        return app;
    }

    public static String getDefaultOlrLocOwner() {
        String app = null;
        app = s_admDataSeg.getProperty("def_olr_loc_owner");
        Trace.out((String)("==== PROP_OLR_LOC_OWNER = '" + app + "'"));
        return app;
    }

    public static String getDefaultOlrLocGroup() {
        String app = null;
        app = s_admDataSeg.getProperty("def_olr_loc_group");
        Trace.out((String)("==== PROP_OLR_LOC_GROUP = '" + app + "'"));
        return app;
    }

    public static String getDefaultOlrLocPermissions() {
        String app = null;
        app = s_admDataSeg.getProperty("def_olr_loc_permissions");
        Trace.out((String)("==== PROP_OLR_LOC_PERMISSIONS = '" + app + "'"));
        return app;
    }

    public static String getDaemonInternalName(String daemon_name) {
        String intr_name = null;
        if (daemon_name.equalsIgnoreCase("crsd")) {
            intr_name = s_admDataSeg.getProperty("DAEMON_INAME_CRS");
        } else if (daemon_name.equalsIgnoreCase("ocssd")) {
            intr_name = s_admDataSeg.getProperty("DAEMON_INAME_CSS");
        } else if (daemon_name.equalsIgnoreCase("evmd")) {
            intr_name = s_admDataSeg.getProperty("DAEMON_INAME_EVM");
        } else if (daemon_name.equalsIgnoreCase("ohasd")) {
            intr_name = s_admDataSeg.getProperty("DAEMON_INAME_OHASD");
        }
        Trace.out((String)("==== Internal name for daemon '" + daemon_name + "' is: " + intr_name));
        return intr_name;
    }

    public static String getDaemonDisplayName(String daemon_name) {
        String disp_name = null;
        if (daemon_name.equalsIgnoreCase("crsd")) {
            disp_name = s_admDataSeg.getProperty("DAEMON_DNAME_CRS");
        } else if (daemon_name.equalsIgnoreCase("ocssd")) {
            disp_name = s_admDataSeg.getProperty("DAEMON_DNAME_CSS");
        } else if (daemon_name.equalsIgnoreCase("evmd")) {
            disp_name = s_admDataSeg.getProperty("DAEMON_DNAME_EVM");
        } else if (daemon_name.equalsIgnoreCase("ohasd")) {
            disp_name = s_admDataSeg.getProperty("DAEMON_DNAME_OHASD");
        }
        Trace.out((String)("==== Display name for daemon '" + daemon_name + "' is: " + disp_name));
        return disp_name;
    }

    static {
        VerificationDataManager vdm = VerificationDataManager.getInstance();
        try {
            s_admDataSeg = (AdminDataSegment)vdm.getDataSegment("admin_data");
        }
        catch (InvalidDataSegmentException e) {
            Trace.out((String)(e.getClass().getName() + ": " + e.getMessage()));
            Trace.out((String)"==== Can not proceed without adminDataSegment");
            String err = "ERROR!! Unable to construct admin data segment. ";
            System.out.println(err);
            throw new InvalidDataFileException(err + e.getMessage());
        }
    }
}

