/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine;

import java.util.List;
import oracle.cluster.verification.FixupGeneratorResult;
import oracle.cluster.verification.NoFixupGeneratorResultException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentFactory;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.component.InvalidComponentException;
import oracle.ops.verification.framework.engine.stage.InvalidStageException;
import oracle.ops.verification.framework.engine.stage.Stage;
import oracle.ops.verification.framework.engine.stage.StageFactory;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.InvalidEnvironmentException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ClusterVerifier
implements VerificationConstants {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");

    public ClusterVerifier() throws InvalidEnvironmentException {
        Trace.out((String)"Inside ClusterVerifier() constructor...");
        try {
            VerificationUtil.getExecutionEnvironment();
        }
        catch (InvalidEnvironmentException iee) {
            ReportUtil.printError(iee.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            throw iee;
        }
    }

    public boolean verifyComponent(String componentID) throws InvalidComponentException, ComponentInitException {
        ReportUtil.printReportHeader();
        Component comp = ComponentFactory.createComponent(componentID);
        boolean retval = comp.verify();
        this.compStageWrapup();
        ReportUtil.printReportFooter(comp.getResultSet());
        return retval;
    }

    public boolean verifyStage(String stageID, int mode) throws InvalidStageException, StageInitException {
        ReportUtil.printReportHeader();
        Stage stage = StageFactory.createStage(stageID, mode);
        boolean retval = stage.verify();
        this.compStageWrapup();
        ReportUtil.printReportFooter(stage.getResultSet());
        return retval;
    }

    private void compStageWrapup() {
        if (VerificationUtil.isFixupGenerated()) {
            FixupGeneratorResult fixupRes = null;
            try {
                fixupRes = VerificationUtil.getFixupGeneratorResult();
            }
            catch (NoFixupGeneratorResultException e) {
                // empty catch block
            }
            List<String> fixableNodes = fixupRes.getFixableNodes();
            if (fixableNodes.size() != 0) {
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)("Fixable nodes:" + VerificationUtil.strList2List(fixableNodes)));
                    Trace.out((String)("Fixup script: " + fixupRes.getFixupScript()));
                }
                ReportUtil.sureprintln(s_msgBundle.getMessage("7711", false) + LSEP + VerificationUtil.strList2List(fixableNodes) + LSEP + s_msgBundle.getMessage("7712", false) + LSEP + "'" + fixupRes.getFixupScript() + "'");
            }
        }
    }
}

