/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine;

import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ErrorDescription
implements VerificationError {
    private static MessageBundle s_prvfMsgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_prkcMsgBundle = VerificationUtil.getMessageBundle("Prkc");
    private String m_errorMsg = s_prvfMsgBundle.getMessage("7505", false);
    private String m_cause = s_prvfMsgBundle.getMessage("7506", false);
    private String m_action = s_prvfMsgBundle.getMessage("7507", false);

    public ErrorDescription() {
    }

    public ErrorDescription(String errorMsg) {
        this.setErrorMessage(errorMsg);
        if (errorMsg != null && (errorMsg.startsWith("PRKC-") || errorMsg.startsWith("PRVF-"))) {
            MessageBundle messageBundle = null;
            String facility = null;
            if (errorMsg.startsWith("PRKC-")) {
                messageBundle = s_prkcMsgBundle;
                facility = "PRKC-";
            } else {
                messageBundle = s_prvfMsgBundle;
                facility = "PRVF-";
            }
            String messageKey = errorMsg.substring(facility.length()).split(":", 2)[0].trim();
            this.m_cause = messageBundle.getCause(messageKey, false);
            this.m_action = messageBundle.getAction(messageKey, false);
        }
    }

    public ErrorDescription(String errorMsg, String cause, String action) {
        this.setErrorMessage(errorMsg);
        this.setCause(cause);
        this.setAction(action);
    }

    public ErrorDescription(String errorMsg, MessageBundle msgBundle, String msgId) {
        String action;
        this.setErrorMessage(errorMsg);
        String cause = msgBundle.getCause(msgId, false);
        if (cause != null && cause.trim().length() > 0) {
            this.setCause(cause);
        }
        if ((action = msgBundle.getAction(msgId, false)) != null && action.trim().length() > 0) {
            this.setAction(action);
        }
    }

    public ErrorDescription(String msgId, MessageBundle msgBundle) {
        String action;
        this.setErrorMessage(msgBundle.getMessage(msgId, true));
        String cause = msgBundle.getCause(msgId, false);
        if (cause != null && cause.trim().length() > 0) {
            this.setCause(cause);
        }
        if ((action = msgBundle.getAction(msgId, false)) != null && action.trim().length() > 0) {
            this.setAction(action);
        }
    }

    public ErrorDescription(String msgId, String[] msgArgs, MessageBundle msgBundle) {
        String action;
        this.setErrorMessage(msgBundle.getMessage(msgId, true, (Object[])msgArgs));
        String cause = msgBundle.getCause(msgId, false);
        if (cause != null && cause.trim().length() > 0) {
            this.setCause(cause);
        }
        if ((action = msgBundle.getAction(msgId, false)) != null && action.trim().length() > 0) {
            this.setAction(action);
        }
    }

    public void setCauseAction(String key) {
        if (key != null) {
            this.m_cause = s_prvfMsgBundle.getCause(key, false);
            this.m_action = s_prvfMsgBundle.getAction(key, false);
        }
    }

    public String getErrorMessage() {
        return this.m_errorMsg;
    }

    public String getCause() {
        return this.m_cause;
    }

    public String getAction() {
        return this.m_action;
    }

    public void setErrorMessage(String errorMsg) {
        if (errorMsg != null) {
            this.m_errorMsg = errorMsg;
        }
    }

    public void setCause(String cause) {
        if (cause != null) {
            this.m_cause = cause;
        }
    }

    public void setAction(String action) {
        if (action != null) {
            this.m_action = action;
        }
    }
}

