/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.NodeResultStatus;
import oracle.cluster.verification.ResultValuesUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationResult;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.util.VerificationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Result
implements VerificationResult {
    public static final int OPERATION_SUCCESSFUL = 1;
    public static final int OPERATION_FAILED = 2;
    public static final int VERIFICATION_FAILED = 3;
    public static final int VERIFICATION_WARNING = 4;
    public static final int UNDEFINED = 5;
    private int m_status = 5;
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private Vector m_resultInfoSet = new Vector();
    private Vector m_errorInfoSet = new Vector();
    private Vector m_traceInfoSet = new Vector();
    private Vector m_verboseInfoSet = new Vector();
    private Vector m_cmdInfoSet = new Vector();
    private Vector m_globalInfoSet = new Vector();
    private String m_node;
    private boolean m_hasResultValues;
    private String m_expectedValue;
    private String m_actualValue;
    private boolean m_isFixupAvailable;
    private List<VerificationError> m_errorList = new ArrayList<VerificationError>();

    public Result(String node) {
        this.m_node = node;
    }

    public Result(String node, int status) {
        this.m_node = node;
        this.m_status = status;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void setStatus(int status) {
        this.m_status = status;
    }

    public void setStatusConditionally(int reqStatus) {
        if (this.statusWeightage(reqStatus) > this.statusWeightage(this.m_status)) {
            this.m_status = reqStatus;
        }
    }

    private int statusWeightage(int status) {
        if (status == 5) {
            return 0;
        }
        if (status == 1) {
            return 10;
        }
        if (status == 4) {
            return 15;
        }
        return 20;
    }

    public void addResultInfo(Object resultInfo) {
        this.m_resultInfoSet.addElement(resultInfo);
        this.m_globalInfoSet.addElement(resultInfo);
    }

    public void addResultInfo(Collection resultInfoSet) {
        this.m_resultInfoSet.addAll(resultInfoSet);
        this.m_globalInfoSet.addAll(resultInfoSet);
    }

    public void addTraceInfo(Object traceInfo) {
        this.m_traceInfoSet.addElement(traceInfo);
        this.m_globalInfoSet.addElement(traceInfo);
    }

    public void addErrorInfo(Object errorInfo) {
        this.m_errorInfoSet.addElement(errorInfo);
        this.m_globalInfoSet.addElement(errorInfo);
    }

    public void addErrorInfo(Collection errorInfo) {
        this.m_errorInfoSet.addAll(errorInfo);
        this.m_globalInfoSet.addAll(errorInfo);
    }

    public void addVerboseInfo(Object verboseInfo) {
        this.m_verboseInfoSet.addElement(verboseInfo);
        this.m_globalInfoSet.addElement(verboseInfo);
    }

    public void addCommandInfo(Object cmdInfo) {
        this.m_cmdInfoSet.addElement(cmdInfo);
        this.m_globalInfoSet.addElement(cmdInfo);
    }

    public void addCommandInfo(Collection cmdInfo) {
        this.m_cmdInfoSet.addAll(cmdInfo);
        this.m_globalInfoSet.addAll(cmdInfo);
    }

    public Vector getResultInfoSet() {
        return this.m_resultInfoSet;
    }

    public Vector getGlobalInfoSet() {
        return this.m_globalInfoSet;
    }

    public Vector getTraceInfoSet() {
        return this.m_traceInfoSet;
    }

    public Vector getCommandInfoSet() {
        return this.m_cmdInfoSet;
    }

    public void dumpTraceInfo() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\nDumping Result Trace Info.\n");
        Enumeration t = this.m_traceInfoSet.elements();
        while (t.hasMoreElements()) {
            buffer.append("  " + (String)t.nextElement() + "\n");
        }
        Trace.out((Object)buffer);
    }

    public void dumpResultInfo() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\nDumping Result data.\n");
        buffer.append("  Status     : " + this.m_status + "\n");
        buffer.append("  Node       : " + this.m_node + "\n");
        buffer.append("  Has Results: " + (this.m_hasResultValues ? "Yes\n" : "No\n"));
        buffer.append("  Exp. value : " + this.m_expectedValue + "\n");
        buffer.append("  Act. value : " + this.m_actualValue + "\n");
        Enumeration t = this.m_resultInfoSet.elements();
        while (t.hasMoreElements()) {
            buffer.append("  Result info: " + (String)t.nextElement() + "\n");
        }
        Trace.out((Object)buffer);
    }

    public String traceResultInfo() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\nDumping Result data.\n");
        buffer.append("  Status     : " + this.m_status + "\n");
        buffer.append("  Node       : " + this.m_node + "\n");
        buffer.append("  Has Results: " + (this.m_hasResultValues ? "Yes\n" : "No\n"));
        buffer.append("  Exp. value : " + this.m_expectedValue + "\n");
        buffer.append("  Act. value : " + this.m_actualValue + "\n");
        Enumeration t = this.m_resultInfoSet.elements();
        Object object = null;
        String objType = null;
        while (t.hasMoreElements()) {
            object = t.nextElement();
            objType = object.getClass().getName();
            objType = objType.substring(objType.lastIndexOf(".") + 1);
            buffer.append("  Info type  : " + objType + "\n");
            if (!objType.contentEquals("String")) continue;
            buffer.append("  Result info: " + (String)object + "\n");
        }
        return buffer.toString();
    }

    public Vector getErrorInfoSet() {
        return this.m_errorInfoSet;
    }

    public Vector getVerboseInfoSet() {
        return this.m_verboseInfoSet;
    }

    public static String resultStatusString(int status) {
        if (status == 1) {
            return "SUCCESSFUL";
        }
        if (status == 2) {
            return "OPERATION_FAILED";
        }
        if (status == 3) {
            return "VERIFICATION_FAILED";
        }
        if (status == 4) {
            return "VERIFICATION_WARNING";
        }
        if (status == 5) {
            return "UNDEFINED";
        }
        return "--ERROR--";
    }

    public static String resultStatusString(NodeResultStatus status) {
        return status.name();
    }

    @Override
    public NodeResultStatus getNodeResultStatus() {
        if (this.m_status == 1) {
            return NodeResultStatus.SUCCESSFUL;
        }
        if (this.m_status == 2) {
            return NodeResultStatus.OPERATION_FAILED;
        }
        if (this.m_status == 3) {
            return NodeResultStatus.VERIFICATION_FAILED;
        }
        if (this.m_status == 4) {
            return NodeResultStatus.VERIFICATION_WARNING;
        }
        return NodeResultStatus.UNDEFINED;
    }

    @Override
    public boolean hasResultValues() {
        return this.m_hasResultValues;
    }

    @Override
    public String getExpectedValue() throws ResultValuesUnavailableException {
        if (this.m_hasResultValues) {
            return this.m_expectedValue;
        }
        throw new ResultValuesUnavailableException(s_msgBundle.getMessage("7502", false));
    }

    @Override
    public String getActualValue() throws ResultValuesUnavailableException {
        if (this.m_hasResultValues) {
            return this.m_actualValue;
        }
        throw new ResultValuesUnavailableException(s_msgBundle.getMessage("7502", false));
    }

    @Override
    public boolean isFixupAvailable() {
        return this.m_isFixupAvailable;
    }

    @Override
    public String getNode() {
        return this.m_node;
    }

    @Override
    public List<VerificationError> getErrors() {
        return this.m_errorList;
    }

    public void addErrorDescription(ErrorDescription errorDesc) {
        this.m_errorList.add(errorDesc);
    }

    public void addErrorDescription(List<VerificationError> errorDescList) {
        this.m_errorList.addAll(errorDescList);
    }

    public void setHasResultValues(boolean hasResultValues) {
        this.m_hasResultValues = hasResultValues;
    }

    public void setExpectedValue(String expValue) {
        this.m_expectedValue = expValue;
    }

    public void setActualValue(String actualValue) {
        this.m_actualValue = actualValue;
    }

    public void setFixupAvailable(boolean isFixupAvailable) {
        this.m_isFixupAvailable = isFixupAvailable;
        if (isFixupAvailable) {
            VerificationUtil.setFixupGenerated(true);
        }
    }

    public String getErrMessage() {
        String errMsg = null;
        boolean msgavail = false;
        if (this.m_errorInfoSet != null && this.m_errorInfoSet.size() > 0) {
            errMsg = this.m_errorInfoSet.toString();
            msgavail = true;
        }
        if (msgavail) {
            return errMsg;
        }
        return new String("");
    }
}

