/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskUSMIntegrity;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ASMComponent
extends Component {
    private String m_release;

    ASMComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    public void init() throws ComponentInitException {
        super.init();
    }

    public boolean verify() {
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)"Commencing ASM Integrity verify()...");
        }
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        String[] crsNodes = VerificationUtil.getNodesWithCRSInstall(validNodeArr, this.m_resultSet);
        if (null == crsNodes) {
            return false;
        }
        switch (this.m_verificationType) {
            case 23: {
                this.m_release = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_RELEASE);
                TaskUSMIntegrity taskASM = new TaskUSMIntegrity(crsNodes);
                taskASM.setASMChecksOnly(true);
                retval = taskASM.perform();
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"\n>>>> ASMComponent: Upload taskASM >>>>>\n");
                }
                this.m_resultSet.uploadResultSet(taskASM.getResultSet());
                return !this.m_resultSet.anyFailure();
            }
        }
        if (Trace.isLevelEnabled((int)15)) {
            Trace.out((String)"ERROR: Invalid Verification Type!");
        }
        return false;
    }

    public String getComponentName() {
        return "ASM";
    }

    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9950", false);
    }
}

