/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskCFSIntegrity;
import oracle.ops.verification.framework.param.Argument;

public class CFSComponent
extends Component {
    String m_fileSystem;

    CFSComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    public void init() throws ComponentInitException {
        super.init();
        this.m_fileSystem = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_FILESYSTEM);
        Trace.out((String)("==== ParamManager reports File System is: " + this.m_fileSystem));
    }

    public boolean verify() {
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        switch (this.m_verificationType) {
            case 5: {
                TaskCFSIntegrity taskCFSI = new TaskCFSIntegrity(validNodeArr, this.m_fileSystem);
                Trace.out((String)"\n>>>> CFSComponent:: Upload taskCFSI >>>>>\n");
                this.m_resultSet.uploadResultSet(taskCFSI.getResultSet());
                return retval &= taskCFSI.perform();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    public String getComponentName() {
        return "CFS";
    }

    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9951", false);
    }
}

