/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.util.Vector;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public abstract class Component
implements VerificationConstants {
    protected static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    public static final int VERIFY_SPACE_AVAIL = 1;
    public static final int VERIFY_SHARED_ACCESS = 2;
    public static final int VERIFY_SYSTEM_REQUIREMENTS = 3;
    public static final int VERIFY_ADMIN_PRIVILEGES = 4;
    public static final int VERIFY_CFS_INTEGRITY = 5;
    public static final int VERIFY_CLUSTER_MGR_INTEGRITY = 6;
    public static final int VERIFY_CLUSTER_INTEGRITY = 7;
    public static final int VERIFY_OCR_INTEGRITY = 8;
    public static final int VERIFY_CRS_INTEGRITY = 9;
    public static final int VERIFY_NODE_CONNECTIVITY = 10;
    public static final int VERIFY_NODE_REACHABILITY = 11;
    public static final int VERIFY_PEER_COMPATIBILITY = 12;
    public static final int VERIFY_NODEAPP_EXISTENCE = 13;
    public static final int VERIFY_OLR_INTEGRITY = 14;
    public static final int VERIFY_HA_INTEGRITY = 15;
    public static final int VERIFY_SOFTWARE = 16;
    public static final int VERIFY_USM_INTEGRITY = 17;
    public static final int VERIFY_OS_COMPAT_VERSION = 18;
    public static final int VERIFY_GPNP_INTEGRITY = 19;
    public static final int VERIFY_GNS_INTEGRITY = 20;
    public static final int VERIFY_SCAN = 21;
    public static final int VERIFY_OHASD_INTEGRITY = 22;
    public static final int VERIFY_ASM_INTEGRITY = 23;
    public static final int VERIFY_CTSS_INTEGRITY = 24;
    public static final int VERIFY_VDISK_INTEGRITY = 25;
    public static final int VERIFY_HEALTH = 26;
    protected String[] m_nodeList;
    protected String[] m_validNodeList;
    protected int m_verificationType;
    protected ParamManager m_paramMgr;
    protected ResultSet m_resultSet = new ResultSet();

    public void init() throws ComponentInitException {
        this.init(true);
    }

    public void init(boolean initNodelist) throws ComponentInitException {
        try {
            this.m_paramMgr = ParamManager.getInstance();
        }
        catch (UninitializedParamManagerException e) {
            throw new ComponentInitException(e.getMessage());
        }
        if (initNodelist) {
            try {
                this.m_nodeList = VerificationUtil.getNodelist();
            }
            catch (NodelistNotFoundException e) {
                throw new ComponentInitException(e.getMessage());
            }
        }
    }

    protected boolean checkSetup() {
        String[] equivNodes;
        boolean succ = false;
        Vector<String> succNodes = new Vector<String>();
        Vector<String> failNodes = new Vector<String>();
        if (VerificationUtil.isLocalNodeOperation()) {
            equivNodes = this.getNodeList();
        } else {
            equivNodes = VerificationUtil.getUserEquivalentNodes(this.getNodeList(), this.getResultSet());
            if (null == equivNodes) {
                succ = false;
                return false;
            }
        }
        boolean destLocSucc = VerificationUtil.checkDestLoc(equivNodes, this.getResultSet(), succNodes, failNodes, true);
        if (succNodes.size() > 0) {
            String[] tempNodeList = succNodes.toArray(new String[succNodes.size()]);
            this.setValidNodeList(tempNodeList);
        }
        succ = succNodes.size() == this.getNodeList().length;
        Trace.out((String)("succNodes passed setupChecks: " + VerificationUtil.strVect2List(succNodes)));
        return succ;
    }

    protected String[] getNodeList() {
        return this.m_nodeList;
    }

    protected void setNodeList(String[] nodeList) {
        this.m_nodeList = nodeList;
    }

    protected String[] getValidNodeList() {
        return this.m_validNodeList;
    }

    protected void setValidNodeList(String[] validNodeList) {
        this.m_validNodeList = validNodeList;
    }

    public ResultSet getResultSet() {
        return this.m_resultSet;
    }

    public abstract boolean verify();

    public final int getVerificationType() {
        return this.m_verificationType;
    }

    Component(int verificationType) throws ComponentInitException {
        this.m_verificationType = verificationType;
    }

    public abstract String getComponentName();

    public abstract String getComponentDisplayName();
}

