/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.component.ASMComponent;
import oracle.ops.verification.framework.engine.component.CFSComponent;
import oracle.ops.verification.framework.engine.component.CRSComponent;
import oracle.ops.verification.framework.engine.component.CTSSComponent;
import oracle.ops.verification.framework.engine.component.ClusterComponent;
import oracle.ops.verification.framework.engine.component.ClusterMgrComponent;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.component.GNSComponent;
import oracle.ops.verification.framework.engine.component.GPNPComponent;
import oracle.ops.verification.framework.engine.component.HAComponent;
import oracle.ops.verification.framework.engine.component.HealthComponent;
import oracle.ops.verification.framework.engine.component.InvalidComponentException;
import oracle.ops.verification.framework.engine.component.NodeAppComponent;
import oracle.ops.verification.framework.engine.component.NodeReachComponent;
import oracle.ops.verification.framework.engine.component.OCRComponent;
import oracle.ops.verification.framework.engine.component.OHASDComponent;
import oracle.ops.verification.framework.engine.component.OLRComponent;
import oracle.ops.verification.framework.engine.component.ScanComponent;
import oracle.ops.verification.framework.engine.component.SoftwareComponent;
import oracle.ops.verification.framework.engine.component.StorageComponent;
import oracle.ops.verification.framework.engine.component.SystemComponent;
import oracle.ops.verification.framework.engine.component.USMComponent;
import oracle.ops.verification.framework.engine.component.VDiskComponent;

public class ComponentFactory
implements VerificationConstants {
    public static Component createComponent(String componentID) throws InvalidComponentException, ComponentInitException {
        if (componentID.equalsIgnoreCase("space")) {
            return new StorageComponent(1);
        }
        if (componentID.equalsIgnoreCase("ssa")) {
            return new StorageComponent(2);
        }
        if (componentID.equalsIgnoreCase("sys")) {
            return new SystemComponent(3);
        }
        if (componentID.equalsIgnoreCase("admprv")) {
            return new SystemComponent(4);
        }
        if (componentID.equalsIgnoreCase("cfs")) {
            return new CFSComponent(5);
        }
        if (componentID.equalsIgnoreCase("clumgr")) {
            return new ClusterMgrComponent(6);
        }
        if (componentID.equalsIgnoreCase("clu")) {
            return new ClusterComponent(7);
        }
        if (componentID.equalsIgnoreCase("nodecon")) {
            return new ClusterComponent(10);
        }
        if (componentID.equalsIgnoreCase("nodereach")) {
            return new NodeReachComponent(11);
        }
        if (componentID.equalsIgnoreCase("peer")) {
            return new ClusterComponent(12);
        }
        if (componentID.equalsIgnoreCase("ocr")) {
            return new OCRComponent(8);
        }
        if (componentID.equalsIgnoreCase("olr")) {
            return new OLRComponent(14);
        }
        if (componentID.equalsIgnoreCase("ha")) {
            return new HAComponent(15);
        }
        if (componentID.equalsIgnoreCase("crs")) {
            return new CRSComponent(9);
        }
        if (componentID.equalsIgnoreCase("nodeapp")) {
            return new NodeAppComponent(13);
        }
        if (componentID.equalsIgnoreCase("software")) {
            return new SoftwareComponent(16);
        }
        if (componentID.equalsIgnoreCase("asm")) {
            return new ASMComponent(23);
        }
        if (componentID.equalsIgnoreCase("acfs")) {
            return new USMComponent(17);
        }
        if (componentID.equalsIgnoreCase("gpnp")) {
            return new GPNPComponent(19);
        }
        if (componentID.equalsIgnoreCase("gns")) {
            return new GNSComponent(20);
        }
        if (componentID.equalsIgnoreCase("scan")) {
            return new ScanComponent(21);
        }
        if (componentID.equalsIgnoreCase("ohasd")) {
            return new OHASDComponent(22);
        }
        if (componentID.equalsIgnoreCase("clocksync")) {
            return new CTSSComponent(24);
        }
        if (componentID.equalsIgnoreCase("vdisk")) {
            return new VDiskComponent(25);
        }
        if (componentID.equalsIgnoreCase("health")) {
            return new HealthComponent(26);
        }
        throw new InvalidComponentException("Invalid Component Tag: " + componentID);
    }
}

