/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskGNSIntegrity;
import oracle.ops.verification.framework.util.HeavyWeightVerificationUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GNSComponent
extends Component {
    GNSComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    public void init() throws ComponentInitException {
        super.init();
    }

    public boolean verify() {
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        String[] crsNodes = VerificationUtil.getNodesWithCRSInstall(validNodeArr, this.m_resultSet);
        if (null == crsNodes) {
            return false;
        }
        if (nativeSystem.isUnixSystem() && !HeavyWeightVerificationUtil.getCRSUser().equals(System.getProperty("user.name"))) {
            Trace.out((String)"user running check is not crsuser");
            return false;
        }
        switch (this.m_verificationType) {
            case 20: {
                TaskGNSIntegrity taskGNSI = new TaskGNSIntegrity(crsNodes);
                Trace.out((String)"\n>>>> GNSComponent:: Upload taskGNSI >>>>>\n");
                this.m_resultSet.uploadResultSet(taskGNSI.getResultSet());
                return retval &= taskGNSI.perform();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    public String getComponentName() {
        return "GNS";
    }

    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9956", false);
    }
}

