/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskGPNPIntegrity;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GPNPComponent
extends Component {
    GPNPComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    public void init() throws ComponentInitException {
        super.init();
    }

    public boolean verify() {
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        String[] crsNodes = VerificationUtil.getNodesWithCRSInstall(validNodeArr, this.m_resultSet);
        if (null == crsNodes) {
            return false;
        }
        switch (this.m_verificationType) {
            case 19: {
                TaskGPNPIntegrity taskGPNPI = new TaskGPNPIntegrity(crsNodes);
                Trace.out((String)"\n>>>> GPNPComponent:: Upload taskGPNPI >>>>>\n");
                this.m_resultSet.uploadResultSet(taskGPNPI.getResultSet());
                return retval &= taskGPNPI.perform();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    public String getComponentName() {
        return "GPNP";
    }

    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9957", false);
    }
}

