/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentFactory;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.component.InvalidComponentException;
import oracle.ops.verification.framework.engine.component.SystemComponent;
import oracle.ops.verification.framework.report.ReportUtil;

public class HealthComponent
extends Component {
    HealthComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    public void init() throws ComponentInitException {
        super.init();
    }

    protected boolean checkSetup() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"ENTRY");
        }
        return true;
    }

    public boolean verify() {
        boolean retval = true;
        this.checkSetup();
        switch (this.m_verificationType) {
            case 26: {
                return retval &= this.verifyComponents();
            }
        }
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"ERROR: Invalid Verification Type!");
        }
        return false;
    }

    private boolean verifyComponents() {
        boolean retval = true;
        boolean crsConfigured = false;
        boolean haConfigured = false;
        try {
            crsConfigured = new ClusterwareInfo().isCRSConfigured();
            haConfigured = new ClusterwareInfo().isHAConfigured();
        }
        catch (InstallException e) {
            this.reportFailure(e.getMessage());
            Trace.out((Exception)((Object)e));
            return false;
        }
        try {
            if (crsConfigured || haConfigured) {
                retval &= this.verifySystemComponent(crsConfigured, haConfigured);
            }
            if (crsConfigured) {
                retval &= this.verifyComponent(ComponentFactory.createComponent("clocksync"));
            }
            if (crsConfigured || haConfigured) {
                retval &= this.verifyComponent(ComponentFactory.createComponent("ohasd"));
            }
            if (crsConfigured) {
                retval &= this.verifyComponent(ComponentFactory.createComponent("crs"));
            }
            if (haConfigured) {
                retval &= this.verifyComponent(ComponentFactory.createComponent("ha"));
            }
            if (crsConfigured) {
                retval &= this.verifyComponent(ComponentFactory.createComponent("scan"));
            }
            if (crsConfigured) {
                retval &= this.verifyComponent(ComponentFactory.createComponent("nodeapp"));
            }
        }
        catch (InvalidComponentException e) {
            Trace.out((Exception)((Object)e));
            this.reportFailure(e.getMessage());
            retval = false;
        }
        catch (ComponentInitException e) {
            Trace.out((Exception)((Object)e));
            this.reportFailure(e.getMessage());
            retval = false;
        }
        return retval;
    }

    private boolean verifyComponent(Component comp) throws ComponentInitException {
        boolean retval = true;
        comp.init();
        ResultSet compRS = comp.getResultSet();
        this.m_resultSet.uploadResultSet(compRS);
        this.report(comp.getComponentName(), comp.getComponentDisplayName(), compRS);
        return retval &= comp.verify();
    }

    private boolean verifySystemComponent(boolean crsConfigured, boolean haConfigured) throws InvalidComponentException, ComponentInitException {
        boolean retval = true;
        Component comp = null;
        comp = ComponentFactory.createComponent("sys");
        ((SystemComponent)comp).setProduct("database");
        comp.init();
        ResultSet compRS = comp.getResultSet();
        this.m_resultSet.uploadResultSet(compRS);
        this.report(comp.getComponentName(), comp.getComponentDisplayName(), compRS);
        return retval &= comp.verify();
    }

    private void report(String componentName, String componentDisplayName, ResultSet rset) {
        if (!ReportUtil.isFormat()) {
            return;
        }
        Hashtable t = rset.getResultTable();
        Enumeration e = t.keys();
        ReportUtil.quietprintln(componentName + "::OVERALL_STATUS::" + ReportUtil.statusOfResultSet(rset) + "::" + componentDisplayName);
        List<VerificationError> globalErrors = rset.getErrors();
        if (globalErrors.size() > 0) {
            ReportUtil.quietprintln("MSG_START");
            for (VerificationError error : globalErrors) {
                ReportUtil.quietprintln(error.getErrorMessage());
            }
            ReportUtil.quietprintln("MSG_END");
        }
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            ReportUtil.quietprintln(componentName + "::NODE_STATUS:" + node + "::" + ReportUtil.statusOfResult(result));
            List<VerificationError> nodeErrors = result.getErrors();
            if (nodeErrors.size() <= 0) continue;
            ReportUtil.quietprintln("MSG_START");
            for (VerificationError error : nodeErrors) {
                ReportUtil.quietprintln(error.getErrorMessage());
            }
            ReportUtil.quietprintln("MSG_END");
        }
    }

    private void reportFailure(String message) {
        ReportUtil.quietprintln("HEALTH_FAILURES::");
        ReportUtil.quietprintln("MSG_START");
        ReportUtil.quietprintln(message);
        ReportUtil.quietprintln("MSG_END");
    }

    public String getComponentName() {
        return "HEALTH";
    }

    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9959", false);
    }
}

