/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.task.TaskOCRIntegrity;

public class OCRComponent
extends Component {
    OCRComponent(int verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    public void init() throws ComponentInitException {
        super.init();
    }

    public boolean verify() {
        boolean retval = this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            return false;
        }
        switch (this.m_verificationType) {
            case 8: {
                TaskOCRIntegrity taskOCRI = new TaskOCRIntegrity(validNodeArr);
                Trace.out((String)"\n>>>> OCRComponent:: Upload taskOCRI >>>>>\n");
                this.m_resultSet.uploadResultSet(taskOCRI.getResultSet());
                return retval &= taskOCRI.perform();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    public String getComponentName() {
        return "OCR";
    }

    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9962", false);
    }
}

